/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.utils;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.WindowState;

public class WindowStates
implements Serializable {
    private String _value_;
    private static Map<String, WindowStates> _table_ = new HashMap<String, WindowStates>();
    private static final String normalString = WindowState.NORMAL.toString();
    private static final String minimizedString = WindowState.MINIMIZED.toString();
    private static final String maximizedString = WindowState.MAXIMIZED.toString();
    private static final String soloString = "solo";
    public static final String _normal = "wsrp:" + normalString;
    public static final String _minimized = "wsrp:" + minimizedString;
    public static final String _maximized = "wsrp:" + maximizedString;
    public static final String _solo = "wsrp:solo";
    public static final WindowStates normal = new WindowStates(_normal);
    public static final WindowStates minimized = new WindowStates(_minimized);
    public static final WindowStates maximized = new WindowStates(_maximized);
    public static final WindowStates solo = new WindowStates("wsrp:solo");

    public WindowStates(String value) {
        this._value_ = value;
        _table_.put(this._value_, this);
    }

    public String getValue() {
        return this._value_;
    }

    public static WindowStates fromValue(String value) {
        return _table_.get(value);
    }

    public static WindowStates fromString(String value) {
        return WindowStates.fromValue(value);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._value_;
    }

    public Object readResolve() throws ObjectStreamException {
        return WindowStates.fromValue(this._value_);
    }

    public static WindowState getJsrPortletStateFromWsrpState(WindowStates wsrpState) {
        if (wsrpState == null) {
            throw new IllegalArgumentException("WSRP portlet state must not be null.");
        }
        if (wsrpState.getValue().equalsIgnoreCase(normalString)) {
            return WindowState.NORMAL;
        }
        if (wsrpState.getValue().equalsIgnoreCase(maximizedString)) {
            return WindowState.MAXIMIZED;
        }
        if (wsrpState.getValue().equalsIgnoreCase(minimizedString)) {
            return WindowState.MINIMIZED;
        }
        if (wsrpState.getValue().equalsIgnoreCase(soloString)) {
            return new WindowState(soloString);
        }
        if (wsrpState.getValue().equalsIgnoreCase(_normal)) {
            return WindowState.NORMAL;
        }
        if (wsrpState.getValue().equalsIgnoreCase(_maximized)) {
            return WindowState.MAXIMIZED;
        }
        if (wsrpState.getValue().equalsIgnoreCase(_minimized)) {
            return WindowState.MINIMIZED;
        }
        if (wsrpState.getValue().equalsIgnoreCase(_solo)) {
            return new WindowState(soloString);
        }
        System.out.println("WindowStates.getJsrPortletStateFromWsrpState " + wsrpState.getValue() + " changed with '" + normalString + "' state");
        return WindowState.NORMAL;
    }

    public static WindowStates getWsrpStateFromJsrPortletState(WindowState windowState) {
        if (windowState == null) {
            throw new IllegalArgumentException("Window state must not be null.");
        }
        if (windowState.toString().equalsIgnoreCase(_normal)) {
            return normal;
        }
        if (windowState.toString().equalsIgnoreCase(_maximized)) {
            return maximized;
        }
        if (windowState.toString().equalsIgnoreCase(_minimized)) {
            return minimized;
        }
        if (windowState.toString().equalsIgnoreCase(_solo)) {
            return solo;
        }
        if (windowState.toString().equalsIgnoreCase(WindowState.MAXIMIZED.toString())) {
            return maximized;
        }
        if (windowState.toString().equalsIgnoreCase(WindowState.MINIMIZED.toString())) {
            return minimized;
        }
        if (windowState.toString().equalsIgnoreCase(WindowState.NORMAL.toString())) {
            return normal;
        }
        if (windowState.toString().equalsIgnoreCase(soloString)) {
            return solo;
        }
        System.out.println("WindowStates.getWsrpStateFromJsrPortletState " + windowState.toString() + " changed with '" + _normal + "' mode");
        return normal;
    }

    public static String[] getWindowStatesAsStringArray() {
        return (String[])_table_.keySet().toArray();
    }

    public static String delAllPrefixWSRP(String forDelWSRP) {
        while (forDelWSRP.startsWith("wsrp:")) {
            forDelWSRP = forDelWSRP.substring("wsrp:".length());
        }
        return forDelWSRP;
    }

    public static String addPrefixWSRP(String forAddWSRP) {
        return "wsrp:" + forAddWSRP;
    }
}

