/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.utils;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;

public class Modes
implements Serializable {
    private String _value_;
    private static Map<String, Modes> _table_ = new HashMap<String, Modes>();
    private static final String viewString = PortletMode.VIEW.toString();
    private static final String editString = PortletMode.EDIT.toString();
    private static final String helpString = PortletMode.HELP.toString();
    private static final String previewString = "preview";
    public static final String _view = "wsrp:" + viewString;
    public static final String _edit = "wsrp:" + editString;
    public static final String _help = "wsrp:" + helpString;
    public static final String _preview = "wsrp:preview";
    public static final Modes view = new Modes(_view);
    public static final Modes edit = new Modes(_edit);
    public static final Modes help = new Modes(_help);
    public static final Modes preview = new Modes("wsrp:preview");

    public Modes(String value) {
        this._value_ = value;
        _table_.put(this._value_, this);
    }

    public String getValue() {
        return this._value_;
    }

    public static Modes fromValue(String value) {
        return _table_.get(value);
    }

    public static Modes fromString(String value) {
        return Modes.fromValue(value);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._value_;
    }

    public Object readResolve() throws ObjectStreamException {
        return Modes.fromValue(this._value_);
    }

    public static PortletMode getJsrPortletModeFromWsrpMode(Modes wsrpMode) {
        if (wsrpMode == null) {
            throw new IllegalArgumentException("WSRP portlet mode must not be null.");
        }
        if (wsrpMode.getValue().equalsIgnoreCase(viewString)) {
            return PortletMode.VIEW;
        }
        if (wsrpMode.getValue().equalsIgnoreCase(editString)) {
            return PortletMode.EDIT;
        }
        if (wsrpMode.getValue().equalsIgnoreCase(helpString)) {
            return PortletMode.HELP;
        }
        if (wsrpMode.getValue().equalsIgnoreCase(previewString)) {
            return new PortletMode(previewString);
        }
        if (wsrpMode.getValue().equalsIgnoreCase(_view)) {
            return PortletMode.VIEW;
        }
        if (wsrpMode.getValue().equalsIgnoreCase(_edit)) {
            return PortletMode.EDIT;
        }
        if (wsrpMode.getValue().equalsIgnoreCase(_help)) {
            return PortletMode.HELP;
        }
        if (wsrpMode.getValue().equalsIgnoreCase(_preview)) {
            return new PortletMode(previewString);
        }
        System.out.println("Modes.getJsrPortletModeFromWsrpMode " + wsrpMode.getValue() + " changed with '" + viewString + "' mode");
        return PortletMode.VIEW;
    }

    public static Modes getWsrpModeFromJsrPortletMode(PortletMode portletMode) {
        if (portletMode == null) {
            throw new IllegalArgumentException("Portlet mode must not be null.");
        }
        if (portletMode.toString().equalsIgnoreCase(_view)) {
            return view;
        }
        if (portletMode.toString().equalsIgnoreCase(_edit)) {
            return edit;
        }
        if (portletMode.toString().equalsIgnoreCase(_help)) {
            return help;
        }
        if (portletMode.toString().equalsIgnoreCase(_preview)) {
            return preview;
        }
        if (portletMode.toString().equalsIgnoreCase(PortletMode.VIEW.toString())) {
            return view;
        }
        if (portletMode.toString().equalsIgnoreCase(PortletMode.EDIT.toString())) {
            return edit;
        }
        if (portletMode.toString().equalsIgnoreCase(PortletMode.HELP.toString())) {
            return help;
        }
        if (portletMode.toString().equalsIgnoreCase(previewString)) {
            return preview;
        }
        System.out.println("Modes.getWsrpModeFromJsrPortletMode " + portletMode.toString() + " changed with '" + _view + "' mode");
        return view;
    }

    public static String delAllPrefixWSRP(String forDelWSRP) {
        while (forDelWSRP.startsWith("wsrp:")) {
            forDelWSRP = forDelWSRP.substring("wsrp:".length());
        }
        return forDelWSRP;
    }

    public static String addPrefixWSRP(String forAddWSRP) {
        return "wsrp:" + forAddWSRP;
    }
}

