/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.consumer.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp.consumer.URLGenerator;
import org.exoplatform.services.wsrp.consumer.URLRewriter;
import org.exoplatform.services.wsrp.exceptions.WSRPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLRewriterImpl
implements URLRewriter {
    private URLGenerator urlGenerator;
    private Log log;

    public URLRewriterImpl(URLGenerator urlGenerator) {
        this.urlGenerator = urlGenerator;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp.consumer");
    }

    @Override
    public String rewriteURLs(String path, String markup) throws WSRPException {
        this.log.debug((Object)("Rewrite URL : " + markup));
        StringBuffer resultMarkup = new StringBuffer("");
        int markupIndex = 0;
        int rewriteStartPos = -1;
        int rewriteEndPos = -1;
        while (markupIndex < markup.length()) {
            rewriteStartPos = -1;
            rewriteEndPos = -1;
            rewriteStartPos = markup.indexOf("wsrp_rewrite?", markupIndex);
            if (rewriteStartPos != -1 && rewriteStartPos + "wsrp_rewrite?".length() - 1 <= markup.length() - 2 && (rewriteEndPos = markup.indexOf("/wsrp_rewrite", markupIndex)) != -1) {
                rewriteEndPos += "/wsrp_rewrite".length();
            }
            if (rewriteStartPos != -1 && rewriteEndPos != -1) {
                resultMarkup.append(markup.substring(markupIndex, rewriteStartPos));
                String submarkup = markup.substring(rewriteStartPos, rewriteEndPos);
                this.rewrite(path, resultMarkup, submarkup);
                markupIndex = rewriteEndPos;
                continue;
            }
            resultMarkup.append(markup.substring(markupIndex, markup.length()));
            markupIndex = markup.length();
        }
        this.log.debug((Object)("Markup returned : " + resultMarkup.toString()));
        return resultMarkup.toString();
    }

    private void rewrite(String baseURL, StringBuffer markup, String rewriteURL) throws WSRPException {
        Map<String, String> params = this.createParameterMap(rewriteURL);
        if (rewriteURL.indexOf("blockingAction") != -1) {
            markup.append(this.urlGenerator.getBlockingActionURL(baseURL, params));
        } else if (rewriteURL.indexOf("render") != -1) {
            markup.append(this.urlGenerator.getRenderURL(baseURL, params));
        } else if (rewriteURL.indexOf("resource") != -1) {
            markup.append(this.urlGenerator.getResourceURL(baseURL, params));
        }
    }

    private Map<String, String> createParameterMap(String rewriteURL) throws WSRPException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (rewriteURL.indexOf("blockingAction") != -1) {
            params.put("wsrp-urlType", "blockingAction");
        } else if (rewriteURL.indexOf("render") != -1) {
            params.put("wsrp-urlType", "render");
        } else if (rewriteURL.indexOf("resource") != -1) {
            params.put("wsrp-urlType", "resource");
        } else {
            throw new WSRPException("OperationFailed");
        }
        int equals = 0;
        int next = 0;
        int end = rewriteURL.indexOf("/wsrp_rewrite");
        int index = rewriteURL.indexOf("&");
        int lengthNext = 0;
        String subNext = null;
        while (index != -1) {
            subNext = rewriteURL.substring(index, index + "&amp;".length());
            lengthNext = subNext.equals("&amp;") ? "&amp;".length() : "&".length();
            equals = rewriteURL.indexOf("=", index + lengthNext);
            next = rewriteURL.indexOf("&", equals);
            if (equals != -1) {
                if (next != -1) {
                    params.put(rewriteURL.substring(index + lengthNext, equals), rewriteURL.substring(equals + 1, next));
                } else {
                    params.put(rewriteURL.substring(index + lengthNext, equals), rewriteURL.substring(equals + 1, end));
                }
            }
            index = next;
        }
        return params;
    }
}

