/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import org.apache.axis.client.Stub;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wsrp2.consumer.ConsumerEnvironment;
import org.exoplatform.services.wsrp2.consumer.GroupSessionMgr;
import org.exoplatform.services.wsrp2.consumer.PortletDriver;
import org.exoplatform.services.wsrp2.consumer.Producer;
import org.exoplatform.services.wsrp2.consumer.URLRewriter;
import org.exoplatform.services.wsrp2.consumer.URLTemplateComposer;
import org.exoplatform.services.wsrp2.consumer.User;
import org.exoplatform.services.wsrp2.consumer.UserSessionMgr;
import org.exoplatform.services.wsrp2.consumer.WSRPBaseRequest;
import org.exoplatform.services.wsrp2.consumer.WSRPEventsRequest;
import org.exoplatform.services.wsrp2.consumer.WSRPInteractionRequest;
import org.exoplatform.services.wsrp2.consumer.WSRPMarkupRequest;
import org.exoplatform.services.wsrp2.consumer.WSRPPortlet;
import org.exoplatform.services.wsrp2.consumer.WSRPResourceRequest;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.intf.WSRP_v2_Markup_PortType;
import org.exoplatform.services.wsrp2.intf.WSRP_v2_PortletManagement_PortType;
import org.exoplatform.services.wsrp2.type.BlockingInteractionResponse;
import org.exoplatform.services.wsrp2.type.ClientData;
import org.exoplatform.services.wsrp2.type.ClonePortlet;
import org.exoplatform.services.wsrp2.type.CookieProtocol;
import org.exoplatform.services.wsrp2.type.DestroyPortlets;
import org.exoplatform.services.wsrp2.type.DestroyPortletsResponse;
import org.exoplatform.services.wsrp2.type.EventParams;
import org.exoplatform.services.wsrp2.type.GetMarkup;
import org.exoplatform.services.wsrp2.type.GetPortletDescription;
import org.exoplatform.services.wsrp2.type.GetPortletProperties;
import org.exoplatform.services.wsrp2.type.GetPortletPropertyDescription;
import org.exoplatform.services.wsrp2.type.GetResource;
import org.exoplatform.services.wsrp2.type.HandleEvents;
import org.exoplatform.services.wsrp2.type.HandleEventsResponse;
import org.exoplatform.services.wsrp2.type.InitCookie;
import org.exoplatform.services.wsrp2.type.InteractionParams;
import org.exoplatform.services.wsrp2.type.InvalidCookieFault;
import org.exoplatform.services.wsrp2.type.MarkupContext;
import org.exoplatform.services.wsrp2.type.MarkupParams;
import org.exoplatform.services.wsrp2.type.MarkupResponse;
import org.exoplatform.services.wsrp2.type.MimeRequest;
import org.exoplatform.services.wsrp2.type.MimeResponse;
import org.exoplatform.services.wsrp2.type.NavigationalContext;
import org.exoplatform.services.wsrp2.type.PerformBlockingInteraction;
import org.exoplatform.services.wsrp2.type.PortletContext;
import org.exoplatform.services.wsrp2.type.PortletDescription;
import org.exoplatform.services.wsrp2.type.PortletDescriptionResponse;
import org.exoplatform.services.wsrp2.type.PortletPropertyDescriptionResponse;
import org.exoplatform.services.wsrp2.type.PropertyList;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.ReleaseSessions;
import org.exoplatform.services.wsrp2.type.ResourceContext;
import org.exoplatform.services.wsrp2.type.ResourceParams;
import org.exoplatform.services.wsrp2.type.ResourceResponse;
import org.exoplatform.services.wsrp2.type.ReturnAny;
import org.exoplatform.services.wsrp2.type.RuntimeContext;
import org.exoplatform.services.wsrp2.type.ServiceDescription;
import org.exoplatform.services.wsrp2.type.SessionParams;
import org.exoplatform.services.wsrp2.type.SetPortletProperties;
import org.exoplatform.services.wsrp2.type.StateChange;
import org.exoplatform.services.wsrp2.type.Templates;
import org.exoplatform.services.wsrp2.type.UserContext;

public class PortletDriverImpl
implements PortletDriver {
    private WSRPPortlet portlet = null;
    private WSRP_v2_Markup_PortType markupPort = null;
    private WSRP_v2_PortletManagement_PortType portletManagementPort = null;
    private ConsumerEnvironment consumer = null;
    private Producer producer = null;
    private CookieProtocol initCookie = CookieProtocol.none;
    private Log log;
    private OrganizationService orgService;

    public PortletDriverImpl(ExoContainer cont, WSRPPortlet portlet) throws WSRPException {
        this.consumer = (ConsumerEnvironment)cont.getComponentInstanceOfType(ConsumerEnvironment.class);
        this.orgService = (OrganizationService)cont.getComponentInstanceOfType(OrganizationService.class);
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2.consumer");
        this.portlet = portlet;
        this.producer = this.consumer.getProducerRegistry().getProducer(portlet.getPortletKey().getProducerId());
        this.portletManagementPort = this.producer.getPortletManagementInterface();
        ServiceDescription serviceDescription = this.producer.getServiceDescription(false);
        if (serviceDescription != null) {
            this.initCookie = serviceDescription.getRequiresInitCookie();
            this.log.debug((Object)("Requires cookie initialization : " + this.initCookie.getValue()));
            if (this.initCookie == null) {
                this.initCookie = CookieProtocol.none;
            }
        }
    }

    public WSRPPortlet getPortlet() {
        return this.portlet;
    }

    private void resetInitCookie(UserSessionMgr userSession) throws WSRPException {
        this.log.debug((Object)"reset cookies");
        if (this.initCookie.getValue().equalsIgnoreCase("none")) {
            userSession.setInitCookieDone(false);
        } else if (this.initCookie.getValue().equalsIgnoreCase("perGroup")) {
            PortletDescription portletDescription = null;
            portletDescription = this.producer.getPortletDescription(this.getPortlet().getParent());
            String groupID = null;
            if (portletDescription != null && (groupID = portletDescription.getGroupID()) != null) {
                GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
                groupSession.setInitCookieDone(false);
            }
        }
    }

    private void checkInitCookie(UserSessionMgr userSession) throws WSRPException {
        this.log.debug((Object)("init cookies : " + this.initCookie.getValue()));
        if (this.initCookie.getValue().equalsIgnoreCase("perUser")) {
            this.log.debug((Object)"cookies management per user");
            if (!userSession.isInitCookieDone()) {
                this.log.debug((Object)("Init cookies : " + userSession));
                this.markupPort = userSession.getWSRPMarkupService();
                userSession.setInitCookieRequired(true);
                this.initCookie(userSession);
                userSession.setInitCookieDone(true);
            }
        } else if (this.initCookie.getValue().equalsIgnoreCase("perGroup")) {
            this.log.debug((Object)"cookies management per group");
            PortletDescription portletDescription = this.producer.getPortletDescription(this.getPortlet().getParent());
            String groupID = null;
            if (portletDescription != null) {
                groupID = portletDescription.getGroupID();
                this.log.debug((Object)("Group Id used for cookies management : " + groupID));
            }
            if (groupID != null) {
                GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
                this.markupPort = groupSession.getWSRPMarkupService();
                if (!groupSession.isInitCookieDone()) {
                    this.log.debug((Object)("Group session in init cookies : " + groupSession));
                    groupSession.setInitCookieRequired(true);
                    this.initCookie(userSession);
                    groupSession.setInitCookieDone(true);
                }
            }
        } else {
            this.markupPort = userSession.getWSRPMarkupService();
        }
    }

    private MarkupParams getMarkupParams(WSRPBaseRequest request) {
        MarkupParams markupParams = new MarkupParams();
        this.fillMimeRequestParams(markupParams, request);
        return markupParams;
    }

    private RuntimeContext getRuntimeContext(WSRPBaseRequest request, String baseURL) throws WSRPException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("PortletDriverImpl.getRuntimeContext() baseURL = " + baseURL));
        }
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setUserAuthentication(this.consumer.getUserAuthentication());
        runtimeContext.setPortletInstanceKey(request.getPortletInstanceKey());
        URLTemplateComposer templateComposer = this.consumer.getTemplateComposer();
        if (templateComposer != null) {
            runtimeContext.setNamespacePrefix(templateComposer.getNamespacePrefix());
            Boolean doesUrlTemplateProcess = null;
            Boolean getTemplatesStoredInSession = null;
            PortletDescription desc = this.producer.getPortletDescription(this.getPortlet().getParent());
            if (desc != null) {
                doesUrlTemplateProcess = desc.getDoesUrlTemplateProcessing();
                getTemplatesStoredInSession = desc.getTemplatesStoredInSession();
                if (getTemplatesStoredInSession.booleanValue()) {
                    // empty if block
                }
                Templates templates = null;
                if (doesUrlTemplateProcess != null && doesUrlTemplateProcess.booleanValue()) {
                    templates = new Templates();
                    if (baseURL != null) {
                        templates.setBlockingActionTemplate(templateComposer.createBlockingActionTemplate(baseURL));
                        templates.setRenderTemplate(templateComposer.createRenderTemplate(baseURL));
                        templates.setDefaultTemplate(templateComposer.createDefaultTemplate(baseURL));
                        templates.setResourceTemplate(templateComposer.createResourceTemplate(baseURL));
                        templates.setSecureBlockingActionTemplate(templateComposer.createSecureBlockingActionTemplate(baseURL));
                        templates.setSecureRenderTemplate(templateComposer.createSecureRenderTemplate(baseURL));
                        templates.setSecureDefaultTemplate(templateComposer.createSecureDefaultTemplate(baseURL));
                        templates.setSecureResourceTemplate(templateComposer.createSecureResourceTemplate(baseURL));
                    }
                }
                runtimeContext.setTemplates(templates);
            }
        }
        runtimeContext.setSessionParams(new SessionParams(null, request.getSessionID()));
        runtimeContext.setPageState(null);
        runtimeContext.setPortletStates(null);
        runtimeContext.setExtensions(null);
        return runtimeContext;
    }

    private UserContext getUserContext(UserSessionMgr userSession) {
        User user;
        UserContext userContext = null;
        if (userSession.getUserID() != null && (user = this.consumer.getUserRegistry().getUser(userSession.getUserID())) != null) {
            userContext = user.getUserContext();
        }
        if (userContext == null) {
            userContext = new UserContext();
            userContext.setUserContextKey("dummyUserContextKey");
        }
        return userContext;
    }

    private InteractionParams getInteractionParams(WSRPInteractionRequest actionRequest) {
        InteractionParams interactionParams = new InteractionParams();
        interactionParams.setPortletStateChange(this.consumer.getPortletStateChange());
        if (!this.portlet.isConsumerConfigured() && interactionParams.getPortletStateChange().toString().equalsIgnoreCase("readWrite")) {
            interactionParams.setPortletStateChange(StateChange.cloneBeforeWrite);
        }
        interactionParams.setInteractionState(actionRequest.getInteractionState());
        interactionParams.setFormParameters(actionRequest.getFormParameters());
        interactionParams.setUploadContexts(actionRequest.getUploadContexts());
        interactionParams.setExtensions(actionRequest.getExtensions());
        return interactionParams;
    }

    public MarkupResponse getMarkup(WSRPMarkupRequest markupRequest, UserSessionMgr userSession, String baseURL) throws WSRPException {
        this.checkInitCookie(userSession);
        MarkupResponse response = null;
        try {
            MarkupContext markupContext = markupRequest.getCachedMarkup();
            if (markupContext == null) {
                UserContext userCtx;
                this.log.debug((Object)"get non cached markup");
                GetMarkup request = new GetMarkup();
                request.setPortletContext(this.getPortlet().getPortletContext());
                request.setMarkupParams(this.getMarkupParams(markupRequest));
                request.setRuntimeContext(this.getRuntimeContext(markupRequest, baseURL));
                RegistrationContext regCtx = this.producer.getRegistrationContext();
                if (regCtx != null) {
                    this.log.debug((Object)("Registration context used in getMarkup : " + regCtx.getRegistrationHandle()));
                    request.setRegistrationContext(regCtx);
                }
                if ((userCtx = this.getUserContext(userSession)) != null) {
                    request.setUserContext(userCtx);
                }
                org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
                String password = user.getPassword();
                this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
                response = this.markupPort.getMarkup(request);
            } else {
                this.log.debug((Object)"get cached markup");
                response = new MarkupResponse();
                response.setMarkupContext(markupContext);
            }
            markupContext = response.getMarkupContext();
            Boolean requiresRewriting = markupContext.getRequiresRewriting();
            this.log.debug((Object)("requires URL rewriting : " + requiresRewriting));
            String content = this.getContent(markupContext);
            if (markupContext.getMimeType().startsWith("text/")) {
                String rewrittenMarkup = null;
                if (requiresRewriting.booleanValue()) {
                    URLRewriter urlRewriter = this.consumer.getURLRewriter();
                    rewrittenMarkup = urlRewriter.rewriteURLs(baseURL, content);
                    this.log.debug((Object)("rewrittenMarkup = " + rewrittenMarkup));
                    if (rewrittenMarkup != null) {
                        markupContext.setItemString(rewrittenMarkup);
                        try {
                            markupContext.setItemBinary(markupContext.getItemString().getBytes("utf-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            markupContext.setItemBinary(markupContext.getItemString().getBytes());
                        }
                    }
                } else {
                    String oldBaseURL = baseURL + "&" + "portal:type" + "=" + "blockingAction";
                    String newBaseURL = baseURL + "&" + "portal:type" + "=" + "action";
                    rewrittenMarkup = content.replace(oldBaseURL, newBaseURL);
                    markupContext.setItemString(rewrittenMarkup);
                    try {
                        markupContext.setItemBinary(markupContext.getItemString().getBytes("utf-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        markupContext.setItemBinary(markupContext.getItemString().getBytes());
                    }
                }
            }
        }
        catch (InvalidCookieFault cookieFault) {
            this.log.error((Object)"Problem with cookies ", (Throwable)((Object)cookieFault));
            this.resetInitCookie(userSession);
            this.getMarkup(markupRequest, userSession, baseURL);
        }
        catch (RemoteException wsrpFault) {
            this.log.error((Object)"Remote exception ", (Throwable)wsrpFault);
            throw new WSRPException("OperationFailed", wsrpFault);
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public BlockingInteractionResponse performBlockingInteraction(WSRPInteractionRequest actionRequest, UserSessionMgr userSession, String baseURL) throws WSRPException {
        this.checkInitCookie(userSession);
        BlockingInteractionResponse response = null;
        try {
            UserContext userCtx;
            PerformBlockingInteraction request = new PerformBlockingInteraction();
            request.setPortletContext(this.getPortlet().getPortletContext());
            request.setInteractionParams(this.getInteractionParams(actionRequest));
            request.setMarkupParams(this.getMarkupParams(actionRequest));
            request.setRuntimeContext(this.getRuntimeContext(actionRequest, baseURL));
            RegistrationContext regCtx = this.producer.getRegistrationContext();
            if (regCtx != null) {
                request.setRegistrationContext(regCtx);
            }
            if ((userCtx = this.getUserContext(userSession)) != null) {
                request.setUserContext(userCtx);
            }
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.markupPort.performBlockingInteraction(request);
        }
        catch (InvalidCookieFault cookieFault) {
            this.resetInitCookie(userSession);
            this.performBlockingInteraction(actionRequest, userSession, baseURL);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public PortletContext clonePortlet(UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        ClonePortlet request = new ClonePortlet();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        PortletContext response = null;
        try {
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.portletManagementPort.clonePortlet(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public DestroyPortletsResponse destroyPortlets(String[] portletHandles, UserSessionMgr userSession) throws WSRPException {
        DestroyPortlets request = new DestroyPortlets();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setPortletHandles(portletHandles);
        DestroyPortletsResponse response = null;
        try {
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.portletManagementPort.destroyPortlets(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public ReturnAny releaseSessions(String[] sessionIDs, UserSessionMgr userSession) throws WSRPException {
        this.checkInitCookie(userSession);
        ReleaseSessions request = new ReleaseSessions();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setSessionIDs(sessionIDs);
        ReturnAny response = null;
        try {
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.markupPort.releaseSessions(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public void initCookie(UserSessionMgr userSession) throws WSRPException {
        InitCookie request = new InitCookie();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            this.log.debug((Object)("Registration context used in initCookie : " + regCtx.getRegistrationHandle()));
            request.setRegistrationContext(regCtx);
            request.setUserContext(this.getUserContext(userSession));
        }
        try {
            this.log.debug((Object)"Call initCookie on Markup Port");
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            this.markupPort.initCookie(request);
        }
        catch (RemoteException wsrpFault) {
            this.log.error((Object)"Problem while initializing cookies", (Throwable)wsrpFault);
            throw new WSRPException("Problem while initializing cookies", wsrpFault);
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
    }

    public PortletDescriptionResponse getPortletDescription(UserSessionMgr userSession, String[] desiredLocales) throws WSRPException {
        GetPortletDescription request = new GetPortletDescription();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setPortletContext(this.getPortlet().getPortletContext());
        UserContext userCtx = this.getUserContext(userSession);
        if (userCtx != null) {
            request.setUserContext(userCtx);
        }
        request.setDesiredLocales(desiredLocales);
        PortletDescriptionResponse response = null;
        try {
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.portletManagementPort.getPortletDescription(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        GetPortletPropertyDescription request = new GetPortletPropertyDescription();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        request.setDesiredLocales(this.consumer.getSupportedLocales());
        PortletPropertyDescriptionResponse response = null;
        try {
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.portletManagementPort.getPortletPropertyDescription(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public PropertyList getPortletProperties(String[] names, UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        GetPortletProperties request = new GetPortletProperties();
        request.setPortletContext(this.getPortlet().getPortletContext());
        request.setNames(names);
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        PropertyList response = null;
        try {
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.portletManagementPort.getPortletProperties(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public PortletContext setPortletProperties(PropertyList properties, UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        SetPortletProperties request = new SetPortletProperties();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        request.setPropertyList(properties);
        PortletContext response = null;
        try {
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.portletManagementPort.setPortletProperties(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    public ResourceResponse getResource(WSRPResourceRequest resourceRequest, UserSessionMgr userSession, String baseURL) throws WSRPException {
        this.checkInitCookie(userSession);
        ResourceResponse response = null;
        try {
            ResourceContext resourceContext = resourceRequest.getCachedResource();
            if (resourceContext == null) {
                UserContext userCtx;
                this.log.debug((Object)"get non cached resource");
                GetResource request = new GetResource();
                request.setPortletContext(this.getPortlet().getPortletContext());
                request.setResourceParams(this.getResourceParams(resourceRequest));
                request.setRuntimeContext(this.getRuntimeContext(resourceRequest, baseURL));
                RegistrationContext regCtx = this.producer.getRegistrationContext();
                if (regCtx != null) {
                    request.setRegistrationContext(regCtx);
                }
                if ((userCtx = this.getUserContext(userSession)) != null) {
                    request.setUserContext(userCtx);
                }
                org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
                String password = user.getPassword();
                this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
                response = this.markupPort.getResource(request);
            } else {
                this.log.debug((Object)"get cached resource");
                response = new ResourceResponse();
                response.setResourceContext(resourceContext);
            }
            resourceContext = response.getResourceContext();
            Boolean requiresRewriting = resourceContext.getRequiresRewriting();
            this.log.debug((Object)("requires URL rewriting : " + requiresRewriting));
            String content = this.getContent(resourceContext);
            if (resourceContext.getMimeType().startsWith("text/")) {
                String rewrittenMarkup = null;
                if (requiresRewriting.booleanValue()) {
                    URLRewriter urlRewriter = this.consumer.getURLRewriter();
                    rewrittenMarkup = urlRewriter.rewriteURLs(baseURL, content);
                    this.log.debug((Object)("rewrittenMarkup = " + rewrittenMarkup));
                    if (rewrittenMarkup != null) {
                        resourceContext.setItemString(rewrittenMarkup);
                        try {
                            resourceContext.setItemBinary(resourceContext.getItemString().getBytes("utf-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            resourceContext.setItemBinary(resourceContext.getItemString().getBytes());
                        }
                    }
                } else {
                    String oldBaseURL = baseURL + "&" + "portal:type" + "=" + "blockingAction";
                    String newBaseURL = baseURL + "&" + "portal:type" + "=" + "action";
                    rewrittenMarkup = content.replace(oldBaseURL, newBaseURL);
                    resourceContext.setItemString(rewrittenMarkup);
                    try {
                        resourceContext.setItemBinary(resourceContext.getItemString().getBytes("utf-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        resourceContext.setItemBinary(resourceContext.getItemString().getBytes());
                    }
                }
            }
        }
        catch (InvalidCookieFault cookieFault) {
            this.log.error((Object)"Problem with cookies ", (Throwable)((Object)cookieFault));
            this.resetInitCookie(userSession);
            this.getResource(resourceRequest, userSession, baseURL);
        }
        catch (RemoteException wsrpFault) {
            this.log.error((Object)"Remote exception ", (Throwable)wsrpFault);
            throw new WSRPException("OperationFailed", wsrpFault);
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    private String getContent(MimeResponse mimeResponse) {
        this.log.debug((Object)("mimeResponse.getItemString() = " + mimeResponse.getItemString()));
        this.log.debug((Object)("mimeResponse.getItemBinary() = " + mimeResponse.getItemBinary()));
        String content = null;
        content = mimeResponse.getItemBinary() != null ? new String(mimeResponse.getItemBinary()) : mimeResponse.getItemString();
        return content;
    }

    private ResourceParams getResourceParams(WSRPResourceRequest resourceRequest) {
        ResourceParams resourceParams = new ResourceParams();
        this.fillMimeRequestParams(resourceParams, resourceRequest);
        resourceParams.setFormParameters(resourceRequest.getFormParameters());
        resourceParams.setUploadContexts(resourceRequest.getUploadContexts());
        resourceParams.setResourceID(resourceRequest.getResourceID());
        resourceParams.setPortletStateChange(resourceRequest.getPortletStateChange());
        resourceParams.setResourceState(resourceRequest.getResourceState());
        resourceParams.setResourceCacheability(resourceRequest.getResourceCacheability());
        return resourceParams;
    }

    private void fillMimeRequestParams(MimeRequest params, WSRPBaseRequest request) {
        ClientData clientData = new ClientData();
        if (this.producer.getRegistrationData() != null) {
            clientData.setUserAgent(this.producer.getRegistrationData().getConsumerAgent());
        }
        clientData.setCcppHeaders(null);
        clientData.setClientAttributes(null);
        params.setClientData(clientData);
        params.setSecureClientCommunication(request.isSecureClientCommunication());
        params.setLocales(request.getLocales());
        params.setMimeTypes(request.getMimeTypes());
        params.setMode(request.getMode());
        params.setWindowState(request.getWindowState());
        params.setMarkupCharacterSets(this.consumer.getCharacterEncodingSet());
        params.setValidateTag(request.getValidateTag());
        params.setValidNewModes(request.getValidNewModes());
        params.setValidNewWindowStates(request.getValidNewWindowStates());
        if (request.getNavigationalState() != null || request.getNavigationalValues() != null && request.getNavigationalValues().length != 0) {
            params.setNavigationalContext(this.getNavigationalContext(request));
        } else {
            params.setNavigationalContext(new NavigationalContext(null, null, null));
        }
        params.setExtensions(null);
    }

    private NavigationalContext getNavigationalContext(WSRPBaseRequest request) {
        NavigationalContext navCont = new NavigationalContext();
        navCont.setOpaqueValue(request.getNavigationalState());
        navCont.setPublicValues(request.getNavigationalValues());
        navCont.setExtensions(null);
        return navCont;
    }

    public HandleEventsResponse handleEvents(WSRPEventsRequest eventRequest, UserSessionMgr userSession, String baseURL) throws WSRPException {
        this.checkInitCookie(userSession);
        HandleEventsResponse response = null;
        try {
            UserContext userCtx;
            HandleEvents request = new HandleEvents();
            request.setPortletContext(this.getPortlet().getPortletContext());
            request.setEventParams(this.getEventParams(eventRequest));
            request.setMarkupParams(this.getMarkupParams(eventRequest));
            request.setRuntimeContext(this.getRuntimeContext(eventRequest, baseURL));
            RegistrationContext regCtx = this.producer.getRegistrationContext();
            if (regCtx != null) {
                request.setRegistrationContext(regCtx);
            }
            if ((userCtx = this.getUserContext(userSession)) != null) {
                request.setUserContext(userCtx);
            }
            org.exoplatform.services.organization.User user = this.orgService.getUserHandler().findUserByName(userSession.getUserID());
            String password = user.getPassword();
            this.applySecurityParams((Stub)this.markupPort, userSession.getUserID(), password);
            response = this.markupPort.handleEvents(request);
        }
        catch (InvalidCookieFault cookieFault) {
            this.resetInitCookie(userSession);
            this.handleEvents(eventRequest, userSession, baseURL);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        catch (Exception ex) {
            this.log.error((Object)"Remote exception ", (Throwable)ex);
            throw new WSRPException("OperationFailed", ex);
        }
        return response;
    }

    private EventParams getEventParams(WSRPEventsRequest eventRequest) {
        EventParams eventParams = new EventParams();
        eventParams.setEvents(eventRequest.getEvents());
        eventParams.setPortletStateChange(this.consumer.getPortletStateChange());
        if (!this.portlet.isConsumerConfigured() && eventParams.getPortletStateChange().toString().equalsIgnoreCase("readWrite")) {
            eventParams.setPortletStateChange(StateChange.cloneBeforeWrite);
        }
        eventParams.setExtensions(null);
        return eventParams;
    }

    private void applySecurityParams(Stub port, String userID, String password) {
        if (userID != null && password != null) {
            port.setUsername(userID);
            port.setPassword(password);
            port._setProperty("javax.xml.rpc.session.maintain", (Object)Boolean.FALSE);
            port._setProperty("user", (Object)userID);
        }
    }
}

