/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.AdminClient;

public class WSRPStarter
extends HttpServlet {
    private AxisThread axis;
    private ExoContainer container;
    private String base = "http://localhost:8080/";
    private String path = "portal/services2";
    private String username = null;
    private String password = null;
    protected int delayBeforeStartSec = 0;
    protected int retries = 1;
    protected int delayRetrySec = 3;
    private String deployWSDD = "org/exoplatform/services/wsrp2/wsdl/deploy.wsdd";
    private final Log log = ExoLogger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public WSRPStarter() {
        this.logDebug("org.exoplatform.services.wsrp2.producer.impl.WSRPStarter.WSRPStarter() entered");
    }

    public void init(ServletConfig config) throws ServletException {
        this.logDebug("org.exoplatform.services.wsrp2.producer.impl.WSRPStarter.init() entered");
        this.processInitParams(config);
        this.start();
    }

    private void processInitParams(ServletConfig config) {
        String credentials;
        if (config.getInitParameter("base") != null) {
            this.base = config.getInitParameter("base");
            this.logDebug("WSRPStarter.init() base = " + this.base);
        }
        if (config.getInitParameter("path") != null) {
            this.path = config.getInitParameter("path");
            this.logDebug("WSRPStarter.init() path = " + this.path);
        }
        if (config.getInitParameter("deploy-wsdd") != null) {
            this.deployWSDD = config.getInitParameter("deploy-wsdd");
            this.logDebug("WSRPStarter.init() deployWSDD = " + this.deployWSDD);
        }
        if (config.getInitParameter("credentials") != null && (credentials = config.getInitParameter("credentials")).indexOf("/") > -1) {
            this.username = credentials.substring(0, credentials.indexOf("/"));
            this.password = credentials.substring(credentials.indexOf("/") + 1);
        }
        try {
            this.delayBeforeStartSec = Integer.parseInt(config.getInitParameter("delay-before-start-sec"));
            this.logDebug("WSRPStarter.init() delayBeforeStartSec = " + this.delayBeforeStartSec);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.retries = Integer.parseInt(config.getInitParameter("retries"));
            this.logDebug("WSRPStarter.init() retries = " + this.retries);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.delayRetrySec = Integer.parseInt(config.getInitParameter("delay-retry-sec"));
            this.logDebug("WSRPStarter.init() delayRetrySec = " + this.delayRetrySec);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void start() {
        this.logDebug("org.exoplatform.services.wsrp2.producer.impl.WSRPStarter.run() entered");
        try {
            String wurl = this.base + this.path;
            String[] args = this.username != null && this.password != null ? new String[]{"-l" + wurl, "-u" + this.username, "-w" + this.password} : new String[]{"-l" + wurl};
            this.logDebug(" --- WSRP2: url opt: " + wurl);
            Options opts = new Options(args);
            URL wsdd = Thread.currentThread().getContextClassLoader().getResource(this.deployWSDD);
            this.logDebug(" --- WSRP2: WSDD url: " + wsdd);
            this.axis = new AxisThread(opts, wsdd);
            this.axis.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logDebug(Object message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(message);
        }
    }

    class AxisThread
    extends Thread {
        Options opts;
        URL wsdd;

        AxisThread(Options opts, URL wsdd) {
            this.opts = opts;
            this.wsdd = wsdd;
        }

        public void run() {
            try {
                WSRPStarter.this.logDebug(" --- WSRP2: axis thread started");
                try {
                    Thread.currentThread();
                    Thread.sleep(WSRPStarter.this.delayBeforeStartSec * 1000, 0);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                for (int i = 1; i <= WSRPStarter.this.retries; ++i) {
                    InputStream is = this.wsdd.openStream();
                    WSRPStarter.this.logDebug(" --- WSRP2: axis thread: attempt: " + i + " at: " + new Date(System.currentTimeMillis()));
                    try {
                        AdminClient admin = new AdminClient();
                        String result = admin.process(this.opts, is);
                        if (result == null) continue;
                        WSRPStarter.this.logDebug(" --- WSRP2: axis: " + result);
                        break;
                    }
                    catch (Exception e) {
                        WSRPStarter.this.log.error((Object)(" --- WSRP2: axis thread got an exception: " + e));
                        e.printStackTrace();
                        WSRPStarter.this.log.error((Object)(" --- WSRP2: axis thread got an exception: cause: " + e.getCause()));
                        if (e.getCause() != null) {
                            e.getCause().printStackTrace();
                        }
                        if (i >= WSRPStarter.this.retries) continue;
                        try {
                            Thread.sleep(WSRPStarter.this.delayRetrySec * 1000, 0);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
                WSRPStarter.this.logDebug(" --- WSRP2: axis thread finished");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

