/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;

public class AdminClient {
    protected static Log log;
    private static ThreadLocal<EngineConfiguration> defaultConfiguration;
    protected Call call;
    protected static final String ROOT_UNDEPLOY;

    public static void setDefaultConfiguration(EngineConfiguration config) {
        defaultConfiguration.set(config);
    }

    private static String getUsageInfo() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.getMessage((String)"acUsage00")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage01")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage02")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage03")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage04")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage05")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage06")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage07")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage08")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage09")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage10")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage11")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage12")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage13")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage14")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage15")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage16")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage17")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage18")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage19")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage20")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage21")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage22")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage23")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage24")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage25")).append(lSep);
        msg.append(Messages.getMessage((String)"acUsage26")).append(lSep);
        return msg.toString();
    }

    public AdminClient() {
        try {
            EngineConfiguration config = defaultConfiguration.get();
            Service service = config != null ? new Service(config) : new Service();
            this.call = (Call)service.createCall();
        }
        catch (ServiceException e) {
            System.err.println(Messages.getMessage((String)"couldntCall00") + ": " + (Object)((Object)e));
            this.call = null;
        }
    }

    public Call getCall() {
        return this.call;
    }

    public String list(Options opts) throws Exception {
        this.processOpts(opts);
        return this.list();
    }

    public String list() throws Exception {
        log.debug((Object)Messages.getMessage((String)"doList00"));
        String str = "<m:list xmlns:m=\"http://xml.apache.org/axis/wsdd/\"/>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String quit(Options opts) throws Exception {
        this.processOpts(opts);
        return this.quit();
    }

    public String quit() throws Exception {
        log.debug((Object)Messages.getMessage((String)"doQuit00"));
        String str = "<m:quit xmlns:m=\"http://xml.apache.org/axis/wsdd/\"/>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String undeployHandler(String handlerName) throws Exception {
        log.debug((Object)Messages.getMessage((String)"doQuit00"));
        String str = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://xml.apache.org/axis/wsdd/" + "\">" + "<handler name=\"" + handlerName + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String undeployService(String serviceName) throws Exception {
        log.debug((Object)Messages.getMessage((String)"doQuit00"));
        String str = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://xml.apache.org/axis/wsdd/" + "\">" + "<service name=\"" + serviceName + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String process(String[] args) throws Exception {
        StringBuffer sb = new StringBuffer();
        Options opts = new Options(args);
        opts.setDefaultURL("http://localhost:8080/axis/services/AdminService");
        if (opts.isFlagSet('d') <= 0) {
            // empty if block
        }
        if ((args = opts.getRemainingArgs()) == null || opts.isFlagSet('?') > 0) {
            System.out.println(Messages.getMessage((String)"usage00", (String)"AdminClient [Options] [list | <deployment-descriptor-files>]"));
            System.out.println("");
            System.out.println(AdminClient.getUsageInfo());
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            ByteArrayInputStream input = null;
            if (args[i].equals("list")) {
                sb.append(this.list(opts));
                continue;
            }
            if (args[i].equals("quit")) {
                sb.append(this.quit(opts));
                continue;
            }
            if (args[i].equals("passwd")) {
                System.out.println(Messages.getMessage((String)"changePwd00"));
                if (args[i + 1] == null) {
                    System.err.println(Messages.getMessage((String)"needPwd00"));
                    return null;
                }
                String str = "<m:passwd xmlns:m=\"http://xml.apache.org/axis/wsdd/\">";
                str = str + args[i + 1];
                str = str + "</m:passwd>";
                input = new ByteArrayInputStream(str.getBytes());
                ++i;
                sb.append(this.process(opts, input));
                continue;
            }
            if (args[i].indexOf(File.pathSeparatorChar) == -1) {
                System.out.println(Messages.getMessage((String)"processFile00", (String)args[i]));
                sb.append(this.process(opts, args[i]));
                continue;
            }
            StringTokenizer tokenizer = null;
            tokenizer = new StringTokenizer(args[i], File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String file = tokenizer.nextToken();
                System.out.println(Messages.getMessage((String)"processFile00", (String)file));
                sb.append(this.process(opts, file));
                if (!tokenizer.hasMoreTokens()) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void processOpts(Options opts) throws Exception {
        if (this.call == null) {
            throw new Exception(Messages.getMessage((String)"nullCall00"));
        }
        this.call.setTargetEndpointAddress(new URL(opts.getURL()));
        this.call.setUsername(opts.getUser());
        this.call.setPassword(opts.getPassword());
        String tName = opts.isValueSet('t');
        if (tName != null && !tName.equals("")) {
            this.call.setProperty("transport_name", (Object)tName);
        }
    }

    public String process(InputStream input) throws Exception {
        return this.process(null, input);
    }

    public String process(URL xmlURL) throws Exception {
        return this.process(null, xmlURL.openStream());
    }

    public String process(String xmlFile) throws Exception {
        FileInputStream in = new FileInputStream(xmlFile);
        String result = this.process(null, in);
        in.close();
        return result;
    }

    public String process(Options opts, String xmlFile) throws Exception {
        this.processOpts(opts);
        return this.process(xmlFile);
    }

    public String process(Options opts, InputStream input) throws Exception {
        if (this.call == null) {
            throw new Exception(Messages.getMessage((String)"nullCall00"));
        }
        if (opts != null) {
            this.processOpts(opts);
        }
        this.call.setUseSOAPAction(true);
        this.call.setSOAPActionURI("AdminService");
        Vector result = null;
        Object[] params = new Object[]{new SOAPBodyElement(input)};
        result = (Vector)this.call.invoke(params);
        input.close();
        if (result == null || result.isEmpty()) {
            throw new AxisFault(Messages.getMessage((String)"nullResponse00"));
        }
        SOAPBodyElement body = (SOAPBodyElement)result.elementAt(0);
        return body.toString();
    }

    public static void main(String[] args) {
        try {
            AdminClient admin = new AdminClient();
            String result = admin.process(args);
            if (result != null) {
                System.out.println(result);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(Messages.getMessage((String)"exception00") + ": " + e);
            System.exit(1);
        }
    }

    static Class _mthclass$(String x0) throws Exception {
        return Class.forName(x0);
    }

    static {
        defaultConfiguration = new ThreadLocal();
        log = LogFactory.getLog((String)org.apache.axis.client.AdminClient.class.getName());
        ROOT_UNDEPLOY = WSDDConstants.QNAME_UNDEPLOY.getLocalPart();
    }
}

