/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.PersistentStateManager;
import org.exoplatform.services.wsrp2.producer.PortletContainerProxy;
import org.exoplatform.services.wsrp2.producer.PortletManagementOperationsInterface;
import org.exoplatform.services.wsrp2.producer.impl.utils.Utils;
import org.exoplatform.services.wsrp2.type.CopiedPortlet;
import org.exoplatform.services.wsrp2.type.CopyPortletsResponse;
import org.exoplatform.services.wsrp2.type.DestroyPortletsResponse;
import org.exoplatform.services.wsrp2.type.ExportPortletsResponse;
import org.exoplatform.services.wsrp2.type.ExportedPortlet;
import org.exoplatform.services.wsrp2.type.FailedPortlets;
import org.exoplatform.services.wsrp2.type.GetPortletsLifetimeResponse;
import org.exoplatform.services.wsrp2.type.ImportPortlet;
import org.exoplatform.services.wsrp2.type.ImportPortletsResponse;
import org.exoplatform.services.wsrp2.type.Lifetime;
import org.exoplatform.services.wsrp2.type.LocalizedString;
import org.exoplatform.services.wsrp2.type.ModelDescription;
import org.exoplatform.services.wsrp2.type.PortletContext;
import org.exoplatform.services.wsrp2.type.PortletDescription;
import org.exoplatform.services.wsrp2.type.PortletDescriptionResponse;
import org.exoplatform.services.wsrp2.type.PortletLifetime;
import org.exoplatform.services.wsrp2.type.PortletPropertyDescriptionResponse;
import org.exoplatform.services.wsrp2.type.Property;
import org.exoplatform.services.wsrp2.type.PropertyList;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.ResourceList;
import org.exoplatform.services.wsrp2.type.ReturnAny;
import org.exoplatform.services.wsrp2.type.SetPortletsLifetimeResponse;
import org.exoplatform.services.wsrp2.type.UserContext;

public class PortletManagementOperationsInterfaceImpl
implements PortletManagementOperationsInterface {
    private PortletContainerProxy proxy;
    private Log log;
    private PersistentStateManager stateManager;

    public PortletManagementOperationsInterfaceImpl(PersistentStateManager stateManager, PortletContainerProxy portletContainerProxy) {
        this.proxy = portletContainerProxy;
        this.stateManager = stateManager;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
    }

    public PortletContext clonePortlet(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, Lifetime lifetime) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Clone a portlet for the registered consumer : " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        String newPortletHandle = null;
        try {
            if (this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("Clone a Consumer Configured Portlet with handle : " + portletHandle));
                PropertyList list = this.getPortletProperties(registrationContext, portletContext, userContext, null);
                newPortletHandle = this.createNewPortletHandle(portletHandle);
                this.stateManager.addConsumerConfiguredPortletHandle(newPortletHandle, registrationContext);
                portletContext.setPortletHandle(newPortletHandle);
                this.setPortletProperties(registrationContext, portletContext, userContext, list);
            } else {
                this.log.debug((Object)("Clone a Producer Offered Portlet with handle : " + portletHandle));
                if (!this.proxy.isPortletOffered(portletHandle)) {
                    this.log.debug((Object)"The latter handle is not offered by the Producer");
                    Exception2Fault.handleException(new WSRPException("InvalidHandle"));
                }
                newPortletHandle = this.createNewPortletHandle(portletHandle);
                this.stateManager.addConsumerConfiguredPortletHandle(newPortletHandle, registrationContext);
            }
            if (lifetime != null) {
                this.stateManager.putPortletLifetime(newPortletHandle, lifetime);
            }
        }
        catch (WSRPException e) {
            this.log.error((Object)"Can not clone portlet", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        this.log.debug((Object)("New portlet handle : " + newPortletHandle));
        PortletContext clonedPortletContext = new PortletContext();
        clonedPortletContext.setPortletHandle(newPortletHandle);
        clonedPortletContext.setScheduledDestruction(lifetime);
        return clonedPortletContext;
    }

    public CopyPortletsResponse copyPortlets(RegistrationContext toRegistrationContext, UserContext toUserContext, RegistrationContext fromRegistrationContext, UserContext fromUserContext, PortletContext[] fromPortletContexts, Lifetime lifetime) throws RemoteException {
        String registrationHandle = fromRegistrationContext.getRegistrationHandle();
        this.log.debug((Object)("Copying portlets for the registered consumer : " + registrationHandle));
        Utils.checkRegistration(fromRegistrationContext, this.stateManager);
        ArrayList<CopiedPortlet> copiedPortlets = new ArrayList<CopiedPortlet>();
        ArrayList<FailedPortlets> failedPortlets = new ArrayList<FailedPortlets>();
        for (int i = 0; i < fromPortletContexts.length; ++i) {
            String portletHandle = fromPortletContexts[i].getPortletHandle();
            String newPortletHandle = null;
            try {
                PropertyList list = this.getPortletProperties(fromRegistrationContext, fromPortletContexts[i], fromUserContext, null);
                newPortletHandle = this.createNewPortletHandle(portletHandle);
                PortletContext newPortletContext = new PortletContext();
                newPortletContext.setPortletHandle(newPortletHandle);
                if (lifetime != null) {
                    newPortletContext.setScheduledDestruction(lifetime);
                }
                newPortletContext.setPortletState(fromPortletContexts[i].getPortletState());
                CopiedPortlet copiedPortlet = new CopiedPortlet();
                copiedPortlet.setNewPortletContext(newPortletContext);
                copiedPortlets.add(copiedPortlet);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Can not copy portlet", (Throwable)e);
                FailedPortlets failedPortlet = new FailedPortlets();
                LocalizedString reason = new LocalizedString();
                reason.setValue("Cannot copy portlet");
                failedPortlet.setReason(reason);
                failedPortlets.add(failedPortlet);
                e.printStackTrace();
            }
        }
        CopiedPortlet[] arrayCopied = copiedPortlets.toArray(new CopiedPortlet[copiedPortlets.size()]);
        FailedPortlets[] arrayFailed = failedPortlets.toArray(new FailedPortlets[failedPortlets.size()]);
        CopyPortletsResponse copyPortletsResponse = new CopyPortletsResponse();
        copyPortletsResponse.setCopiedPortlets(arrayCopied);
        copyPortletsResponse.setFailedPortlets(arrayFailed);
        return copyPortletsResponse;
    }

    public ExportPortletsResponse exportPortlets(RegistrationContext registrationContext, PortletContext[] portletContexts, UserContext userContext, Lifetime lifetime, boolean exportByValueRequired) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Exporting portlets for the registered consumer : " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        ArrayList<ExportedPortlet> exportedPortlets = new ArrayList<ExportedPortlet>();
        ArrayList<FailedPortlets> failedPortlets = new ArrayList<FailedPortlets>();
        if (exportByValueRequired) {
            Exception2Fault.handleException(new WSRPException("ExportByValueNotSupported"));
        }
        for (int i = 0; i < portletContexts.length; ++i) {
            PortletContext portContext = portletContexts[i];
            try {
                byte[] exportData = portContext.getPortletState();
                ExportedPortlet exportedPortlet = new ExportedPortlet();
                exportedPortlet.setExportData(exportData);
                exportedPortlet.setPortletHandle(portContext.getPortletHandle());
                exportedPortlets.add(exportedPortlet);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Can not copy portlet", (Throwable)e);
                FailedPortlets failedPortlet = new FailedPortlets();
                LocalizedString reason = new LocalizedString();
                reason.setValue("Cannot copy portlet");
                failedPortlet.setReason(reason);
                failedPortlets.add(failedPortlet);
                e.printStackTrace();
            }
        }
        ExportPortletsResponse exportPortletsResponse = new ExportPortletsResponse();
        if (lifetime != null) {
            exportPortletsResponse.setLifetime(lifetime);
        }
        ExportedPortlet[] arrayExported = exportedPortlets.toArray(new ExportedPortlet[exportedPortlets.size()]);
        FailedPortlets[] arrayFailed = failedPortlets.toArray(new FailedPortlets[failedPortlets.size()]);
        exportPortletsResponse.setExportedPortlet(arrayExported);
        exportPortletsResponse.setFailedPortlets(arrayFailed);
        return exportPortletsResponse;
    }

    public ImportPortletsResponse importPortlets(RegistrationContext registrationContext, byte[] importContext, ImportPortlet[] importPortlets, UserContext userContext, Lifetime lifetime) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Exporting portlets for the registered consumer : " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        ArrayList<ImportPortlet> importedPortlets = new ArrayList<ImportPortlet>();
        ArrayList<FailedPortlets> failedPortlets = new ArrayList<FailedPortlets>();
        for (int i = 0; i < importPortlets.length; ++i) {
            ImportPortlet importPortlet = importPortlets[i];
            try {
                importedPortlets.add(importPortlet);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Can not import portlet", (Throwable)e);
                FailedPortlets failedPortlet = new FailedPortlets();
                LocalizedString reason = new LocalizedString();
                reason.setValue("Cannot import portlet");
                failedPortlet.setReason(reason);
                failedPortlets.add(failedPortlet);
                e.printStackTrace();
            }
        }
        ImportPortletsResponse importPortletsResponse = new ImportPortletsResponse();
        return importPortletsResponse;
    }

    public ReturnAny releaseExport(byte[] exportContext, UserContext userContext, RegistrationContext registrationContext) {
        return new ReturnAny();
    }

    public Lifetime setExportLifetime(RegistrationContext registrationContext, byte[] exportContext, UserContext userContext, Lifetime lifetime) throws RemoteException {
        return lifetime;
    }

    public DestroyPortletsResponse destroyPortlets(RegistrationContext registrationContext, String[] portletHandles, UserContext userContext) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Destroy portlet for registration handle " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        ArrayList<FailedPortlets> fails = new ArrayList<FailedPortlets>();
        for (int i = 0; i < portletHandles.length; ++i) {
            String portletHandle = portletHandles[i];
            try {
                if (this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                    this.log.debug((Object)("Destroy a consumer configured portlet : " + portletHandle));
                    this.stateManager.removeConsumerConfiguredPortletHandle(portletHandle, registrationContext);
                    continue;
                }
                this.log.debug((Object)("Can't destroy a portlet that did not exist : " + portletHandle));
                FailedPortlets failedPortlets = new FailedPortlets();
                failedPortlets.setPortletHandles(new String[]{portletHandle});
                failedPortlets.setReason(new LocalizedString("Can't destroy a portlet that did not exist", ""));
                fails.add(failedPortlets);
                continue;
            }
            catch (WSRPException e) {
                Exception2Fault.handleException(e);
            }
        }
        DestroyPortletsResponse response = new DestroyPortletsResponse();
        FailedPortlets[] array = fails.toArray(new FailedPortlets[fails.size()]);
        if (array != null) {
            response.setFailedPortlets(array);
        }
        return response;
    }

    public GetPortletsLifetimeResponse getPortletsLifetime(RegistrationContext registrationContext, PortletContext[] portletContexts, UserContext userContext) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Set portlet properties for registration handle " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        ArrayList<PortletLifetime> portletLifetimes = new ArrayList<PortletLifetime>();
        ArrayList<FailedPortlets> failedPortlets = new ArrayList<FailedPortlets>();
        for (int i = 0; i < portletContexts.length; ++i) {
            PortletContext portletContext = portletContexts[i];
            String portletHandle = portletContext.getPortletHandle();
            try {
                Lifetime lifetimeResult = this.stateManager.getPortletLifetime(portletHandle);
                PortletLifetime portletLifetime = new PortletLifetime();
                portletLifetime.setPortletContext(portletContext);
                portletLifetime.setScheduledDestruction(lifetimeResult);
                portletLifetimes.add(portletLifetime);
                continue;
            }
            catch (Exception e) {
                FailedPortlets fPortlet = new FailedPortlets();
                failedPortlets.add(fPortlet);
            }
        }
        PortletLifetime[] arrayLifetime = portletLifetimes.toArray(new PortletLifetime[portletLifetimes.size()]);
        FailedPortlets[] arrayFailed = failedPortlets.toArray(new FailedPortlets[failedPortlets.size()]);
        GetPortletsLifetimeResponse lfResponse = new GetPortletsLifetimeResponse();
        lfResponse.setFailedPortlets(arrayFailed);
        lfResponse.setPortletLifetime(arrayLifetime);
        return lfResponse;
    }

    public SetPortletsLifetimeResponse setPortletsLifetime(RegistrationContext registrationContext, PortletContext[] portletContexts, UserContext userContext, Lifetime lifetime) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Set portlet properties for registration handle " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        ArrayList<PortletLifetime> portletLifetimes = new ArrayList<PortletLifetime>();
        ArrayList<FailedPortlets> failedPortlets = new ArrayList<FailedPortlets>();
        for (int i = 0; i < portletContexts.length; ++i) {
            PortletContext portletContext = portletContexts[i];
            String portletHandle = portletContext.getPortletHandle();
            try {
                Lifetime lifetimeResult = this.stateManager.putPortletLifetime(portletHandle, lifetime);
                PortletLifetime portletLifetime = new PortletLifetime();
                portletLifetime.setPortletContext(portletContext);
                portletLifetime.setScheduledDestruction(lifetimeResult);
                portletLifetimes.add(portletLifetime);
                continue;
            }
            catch (Exception e) {
                FailedPortlets fPortlet = new FailedPortlets();
                failedPortlets.add(fPortlet);
            }
        }
        PortletLifetime[] arrayUpdated = portletLifetimes.toArray(new PortletLifetime[portletLifetimes.size()]);
        FailedPortlets[] arrayFailed = failedPortlets.toArray(new FailedPortlets[failedPortlets.size()]);
        SetPortletsLifetimeResponse setLifetimeResponse = new SetPortletsLifetimeResponse();
        setLifetimeResponse.setUpdatedPortlet(arrayUpdated);
        setLifetimeResponse.setFailedPortlets(arrayFailed);
        return setLifetimeResponse;
    }

    public PortletDescriptionResponse getPortletDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] desiredLocales) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Get portlet description for registration handle " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        try {
            if (!this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("This portlet handle " + portletHandle + " is not valid in the scope of that registration "));
                Exception2Fault.handleException(new WSRPException("AccessDenied"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        PortletDescription pD = this.proxy.getPortletDescription(portletHandle, desiredLocales);
        ResourceList resourceList = this.proxy.getResourceList(desiredLocales);
        PortletDescriptionResponse response = new PortletDescriptionResponse();
        response.setPortletDescription(pD);
        response.setResourceList(resourceList);
        return response;
    }

    public PortletContext setPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, PropertyList propertyList) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Set portlet properties for registration handle " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        try {
            if (!this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("This portlet handle " + portletHandle + " is not valid in the scope of that registration "));
                Exception2Fault.handleException(new WSRPException("AccessDenied"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String userID = userContext.getUserContextKey();
        try {
            this.proxy.setPortletProperties(portletHandle, userID, propertyList);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        return portletContext;
    }

    public PropertyList getPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] names) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("get portlet properties for registration handle " + registrationHandle));
        Utils.checkRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        try {
            if (!this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("This portlet handle " + portletHandle + " is not valid in the scope of that registration "));
                Exception2Fault.handleException(new WSRPException("AccessDenied"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String userID = userContext.getUserContextKey();
        Map<String, String[]> properties = null;
        try {
            properties = this.proxy.getPortletProperties(portletHandle, userID);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        ArrayList<Property> properties2return = new ArrayList<Property>();
        Set<String> keys = properties.keySet();
        for (String key : keys) {
            if (names != null && !this.arrayContainsKey(names, key)) continue;
            String[] values = properties.get(key);
            Property prop = new Property();
            prop.setName(new QName(key));
            prop.setStringValue(values[0]);
            properties2return.add(prop);
        }
        PropertyList list = new PropertyList();
        list.setProperties(properties2return.toArray(new Property[properties2return.size()]));
        list.setResetProperties(null);
        return list;
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] desiredLocales) throws RemoteException {
        PortletPropertyDescriptionResponse portletPropertyDescriptionResponse = new PortletPropertyDescriptionResponse();
        ModelDescription modelDescription = new ModelDescription();
        modelDescription.setPropertyDescriptions(null);
        ResourceList resourceList = new ResourceList();
        resourceList.setResources(null);
        portletPropertyDescriptionResponse.setModelDescription(null);
        portletPropertyDescriptionResponse.setResourceList(null);
        return portletPropertyDescriptionResponse;
    }

    private boolean arrayContainsKey(String[] array, String key) {
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    private String createNewPortletHandle(String portletHandle) {
        String[] keys = StringUtils.split((String)portletHandle, (String)"/");
        String newPortletHandle = keys[0] + "/" + keys[1] + "/" + IdentifierUtil.generateUUID((Object)portletHandle);
        return newPortletHandle;
    }
}

