/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletContainerPlugin;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.helper.WindowInfosContainer;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.EventInput;
import org.exoplatform.services.portletcontainer.pci.EventOutput;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceInput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletDataImp;
import org.exoplatform.services.wsrp2.consumer.ConsumerEnvironment;
import org.exoplatform.services.wsrp2.consumer.GroupSessionMgr;
import org.exoplatform.services.wsrp2.consumer.PortletDriver;
import org.exoplatform.services.wsrp2.consumer.PortletKey;
import org.exoplatform.services.wsrp2.consumer.PortletSession;
import org.exoplatform.services.wsrp2.consumer.PortletWindowSession;
import org.exoplatform.services.wsrp2.consumer.Producer;
import org.exoplatform.services.wsrp2.consumer.ProducerRegistry;
import org.exoplatform.services.wsrp2.consumer.URLTemplateComposer;
import org.exoplatform.services.wsrp2.consumer.User;
import org.exoplatform.services.wsrp2.consumer.UserSession;
import org.exoplatform.services.wsrp2.consumer.UserSessionMgr;
import org.exoplatform.services.wsrp2.consumer.WSRPEventsRequest;
import org.exoplatform.services.wsrp2.consumer.WSRPInteractionRequest;
import org.exoplatform.services.wsrp2.consumer.WSRPMarkupRequest;
import org.exoplatform.services.wsrp2.consumer.WSRPPortlet;
import org.exoplatform.services.wsrp2.consumer.WSRPResourceRequest;
import org.exoplatform.services.wsrp2.consumer.adapters.PortletKeyAdapter;
import org.exoplatform.services.wsrp2.consumer.adapters.UserAdapter;
import org.exoplatform.services.wsrp2.consumer.adapters.WSRPBaseRequestAdapter;
import org.exoplatform.services.wsrp2.consumer.adapters.WSRPEventsRequestAdapter;
import org.exoplatform.services.wsrp2.consumer.adapters.WSRPInteractionRequestAdapter;
import org.exoplatform.services.wsrp2.consumer.adapters.WSRPMarkupRequestAdapter;
import org.exoplatform.services.wsrp2.consumer.adapters.WSRPPortletAdapter;
import org.exoplatform.services.wsrp2.consumer.adapters.WSRPResourceRequestAdapter;
import org.exoplatform.services.wsrp2.consumer.impl.helpers.UserSessionImpl;
import org.exoplatform.services.wsrp2.consumer.portlets.WSRPAdminPortletDataImp;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp2.type.BlockingInteractionResponse;
import org.exoplatform.services.wsrp2.type.ClientData;
import org.exoplatform.services.wsrp2.type.EventDescription;
import org.exoplatform.services.wsrp2.type.HandleEventsResponse;
import org.exoplatform.services.wsrp2.type.ItemDescription;
import org.exoplatform.services.wsrp2.type.LocalizedString;
import org.exoplatform.services.wsrp2.type.MarkupContext;
import org.exoplatform.services.wsrp2.type.MarkupResponse;
import org.exoplatform.services.wsrp2.type.MarkupType;
import org.exoplatform.services.wsrp2.type.MimeResponse;
import org.exoplatform.services.wsrp2.type.NamedString;
import org.exoplatform.services.wsrp2.type.NavigationalContext;
import org.exoplatform.services.wsrp2.type.ParameterDescription;
import org.exoplatform.services.wsrp2.type.PersonName;
import org.exoplatform.services.wsrp2.type.PortletContext;
import org.exoplatform.services.wsrp2.type.PortletDescription;
import org.exoplatform.services.wsrp2.type.ResourceContext;
import org.exoplatform.services.wsrp2.type.ResourceResponse;
import org.exoplatform.services.wsrp2.type.ServiceDescription;
import org.exoplatform.services.wsrp2.type.SessionContext;
import org.exoplatform.services.wsrp2.type.StateChange;
import org.exoplatform.services.wsrp2.type.UpdateResponse;
import org.exoplatform.services.wsrp2.type.UserContext;
import org.exoplatform.services.wsrp2.type.UserProfile;
import org.exoplatform.services.wsrp2.utils.JAXBEventTransformer;
import org.exoplatform.services.wsrp2.utils.Modes;
import org.exoplatform.services.wsrp2.utils.Utils;
import org.exoplatform.services.wsrp2.utils.WindowStates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPConsumerPlugin
implements PortletContainerPlugin {
    private static final String[] characterEncodings = new String[]{"UTF-8"};
    private static final String[] mimeTypes = new String[]{"text/html", "text/wml"};
    public static final String[] SUPPORTED_LOCALES = new String[]{"en", "fr"};
    private static final String consumerAgent = "exoplatform.3.0";
    private static final String userAgent = "userAgent";
    protected WSRPAdminPortletDataImp adminPortlet = null;
    public static final String USER_SESSIONS_KEY = "user_session_key";
    private ExoContainer container;
    private ConsumerEnvironment consumer;
    private PortletContainerService pcService;
    private URLTemplateComposer templateComposer;
    private PortletContainerConf pcConf;
    private WSRPConfiguration conf;
    private Log log;
    private String pluginName;
    private static boolean init = false;

    public WSRPConsumerPlugin(ExoContainerContext context, ConsumerEnvironment consumer, PortletContainerService pcService, URLTemplateComposer templateComposer, PortletContainerConf pcConf, WSRPConfiguration conf) {
        this.container = context.getContainer();
        this.consumer = consumer;
        this.pcService = pcService;
        this.templateComposer = templateComposer;
        this.pcConf = pcConf;
        this.conf = conf;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
        this.initConsumer();
    }

    public void setName(String name) {
        this.pluginName = name;
    }

    public String getName() {
        return this.pluginName;
    }

    public void setDescription(String description) {
        this.pcConf.setDescription(description);
    }

    public String getDescription() {
        return this.pcConf.getDescription();
    }

    public void setMajorVersion(int majorVersion) {
        this.pcConf.setMajorVersion(majorVersion);
    }

    public void setMinorVersion(int minorVersion) {
        this.pcConf.setMinorVersion(minorVersion);
    }

    public void setProperties(Map<String, String> properties) {
        this.pcConf.setProperties(properties);
    }

    protected void initConsumer() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"WSRPConsumerPlugin.initConsumer");
        }
        this.consumer.setCharacterEncodingSet(characterEncodings);
        this.consumer.setConsumerAgent(consumerAgent);
        this.consumer.setMimeTypes(mimeTypes);
        this.consumer.setPortletStateChange(StateChange.readWrite);
        this.consumer.setSupportedModes(this.getPortletModes(this.pcService.getSupportedPortletModes()));
        this.consumer.setSupportedWindowStates(this.getWindowStates(this.pcService.getSupportedWindowStates()));
        this.consumer.setUserAuthentication("wsrp:none");
        this.consumer.setSupportedLocales(SUPPORTED_LOCALES);
        this.adminPortlet = new WSRPAdminPortletDataImp(this.container, this.conf.getAdminPortletParams());
        init = true;
    }

    private String[] getPortletModes(Collection<PortletMode> supportedPortletModes) {
        String[] array = new String[supportedPortletModes.size()];
        int i = 0;
        for (PortletMode portletMode : supportedPortletModes) {
            array[i] = portletMode.toString();
            ++i;
        }
        return array;
    }

    private String[] getWindowStates(Collection<WindowState> supportedWindowStates) {
        String[] array = new String[supportedWindowStates.size()];
        int i = 0;
        for (WindowState windowState : supportedWindowStates) {
            array[i] = windowState.toString();
            ++i;
        }
        return array;
    }

    public Collection<PortletMode> getSupportedPortletModes() {
        if (!init) {
            return null;
        }
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        ArrayList<PortletMode> result = null;
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                ServiceDescription desc = producer.getServiceDescription();
                result = new ArrayList<PortletMode>();
                ItemDescription[] iDArray = desc.getCustomModeDescriptions();
                if (iDArray == null) continue;
                for (int j = 0; j < iDArray.length; ++j) {
                    ItemDescription iD = iDArray[j];
                    String mode = iD.getItemName();
                    if (result.contains(mode)) continue;
                    result.add(new PortletMode(mode));
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Collection<WindowState> getSupportedWindowStates() {
        if (!init) {
            return null;
        }
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        ArrayList<WindowState> result = null;
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                ServiceDescription desc = producer.getServiceDescription();
                result = new ArrayList<WindowState>();
                ItemDescription[] iDArray = desc.getCustomWindowStateDescriptions();
                if (iDArray == null) continue;
                for (int j = 0; j < iDArray.length; ++j) {
                    ItemDescription iD = iDArray[j];
                    String state = iD.getItemName();
                    if (result.contains(state)) continue;
                    result.add(new WindowState(state));
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Collection<PortletMode> getPortletModes(String portletAppName, String portletName, String markup) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.getPortletModes(markup);
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        if (!init) {
            return null;
        }
        ArrayList<PortletMode> result = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        while (i.hasNext()) {
            Producer producer = i.next();
            if (!producer.getID().equalsIgnoreCase(producerID)) continue;
            try {
                ServiceDescription sD = producer.getServiceDescription();
                result = new ArrayList<PortletMode>();
                PortletDescription[] portletDescriptions = sD.getOfferedPortlets();
                if (portletDescriptions == null) continue;
                for (int k = 0; k < portletDescriptions.length; ++k) {
                    PortletDescription portletDescription = portletDescriptions[k];
                    String portletHandleTemp = portletDescription.getPortletHandle();
                    if (!portletHandleTemp.equalsIgnoreCase(portletHandle)) continue;
                    MarkupType[] markupType = portletDescription.getMarkupTypes();
                    for (int j = 0; j < markupType.length; ++j) {
                        MarkupType type = markupType[j];
                        if (!type.getMimeType().equalsIgnoreCase(markup)) continue;
                        String[] result_in_array = type.getModes();
                        for (int m = 0; m < result_in_array.length; ++m) {
                            result.add(Modes.getJsrPortletMode(result_in_array[m]));
                        }
                    }
                    return result;
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public final String[] getPortalManagedPortletModes(String portletAppName, String portletName) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return new String[0];
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        if (!init) {
            return null;
        }
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> producers = pregistry.getAllProducers();
        while (producers.hasNext()) {
            Producer producer = producers.next();
            if (!producer.getID().equalsIgnoreCase(producerID)) continue;
            try {
                ServiceDescription sD = producer.getServiceDescription();
                PortletDescription[] portletDescriptions = sD.getOfferedPortlets();
                if (portletDescriptions == null) continue;
                for (int iPD = 0; iPD < portletDescriptions.length; ++iPD) {
                    PortletDescription portletDescription = portletDescriptions[iPD];
                    if (!portletDescription.getPortletHandle().equalsIgnoreCase(portletAppName + "/" + portletName)) continue;
                    return portletDescription.getPortletManagedModes();
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getPortletHandle(String portletAppName, String portletName) {
        if (portletAppName == null || portletName == null) {
            return null;
        }
        String result = null;
        result = !portletAppName.contains("@") ? portletAppName : portletAppName.substring(portletAppName.indexOf("@") + 1);
        result = result + "/" + portletName;
        return result;
    }

    public boolean isModeSuported(String portletAppName, String portletName, String markup, PortletMode mode) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.isModeSuported(markup, mode);
        }
        return false;
    }

    public Collection<WindowState> getWindowStates(String portletAppName, String portletName, String markup) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.getWindowStates(markup);
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        if (!init) {
            return null;
        }
        ArrayList<WindowState> result = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        while (i.hasNext()) {
            Producer producer = i.next();
            if (!producer.getID().equalsIgnoreCase(producerID)) continue;
            try {
                ServiceDescription sD = producer.getServiceDescription();
                result = new ArrayList<WindowState>();
                PortletDescription[] portletDescriptions = sD.getOfferedPortlets();
                if (portletDescriptions == null) continue;
                for (int k = 0; k < portletDescriptions.length; ++k) {
                    PortletDescription portletDescription = portletDescriptions[k];
                    String portletHandleTemp = portletDescription.getPortletHandle();
                    if (!portletHandleTemp.equalsIgnoreCase(portletHandle)) continue;
                    MarkupType[] markupType = portletDescription.getMarkupTypes();
                    for (int j = 0; j < markupType.length; ++j) {
                        MarkupType type = markupType[j];
                        if (!type.getMimeType().equalsIgnoreCase(markup)) continue;
                        String[] result_in_array = type.getWindowStates();
                        for (int m = 0; m < result_in_array.length; ++m) {
                            result.add(WindowStates.getJsrWindowState(result_in_array[m]));
                        }
                    }
                    return result;
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isStateSupported(String portletAppName, String portletName, String markup, WindowState state) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.isStateSupported(markup, state);
        }
        return false;
    }

    public boolean isEventPayloadTypeMatches(String portletAppName, QName eventName, Serializable payload) {
        EventDescription[] eds;
        ServiceDescription sd;
        Producer producer = this.getProducer(this.getProducerID(portletAppName));
        try {
            sd = producer.getServiceDescription();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd != null && (eds = sd.getEventDescriptions()) != null) {
            for (EventDescription ed : eds) {
                if ((ed.getName() == null || !ed.getName().equals(eventName)) && (ed.getAliases() == null || !Utils.getQNameList(ed.getAliases()).contains(eventName))) continue;
                if (ed.getType() == null) {
                    return false;
                }
                try {
                    Class<?> clazz = Class.forName(ed.getType().toString());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Event loaded class for eventName: '" + eventName + "' is: " + clazz));
                    }
                    return clazz.isInstance(payload);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public Map<String, PortletData> getAllPortletMetaData() {
        this.log.debug((Object)"getAllPortletMetaData() entered");
        HashMap<String, PortletData> result = new HashMap<String, PortletData>();
        result.put("@WSRP2App/WSRPAdminPortlet", (PortletData)this.adminPortlet);
        String producerId = null;
        String portletHandle = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                ServiceDescription desc = producer.getServiceDescription();
                producerId = producer.getID();
                PortletDescription[] portletDescriptions = desc.getOfferedPortlets();
                if (portletDescriptions == null) continue;
                for (int k = 0; k < portletDescriptions.length; ++k) {
                    PortletDescription portletDescription = portletDescriptions[k];
                    portletHandle = portletDescription.getPortletHandle();
                    Portlet portlet = new Portlet();
                    portlet.setPortletName(portletDescription.getPortletHandle());
                    portlet.setPortletClass(null);
                    if (portletDescription.getDisplayName() != null) {
                        DisplayName displayName = new DisplayName();
                        displayName.setDisplayName(portletDescription.getDisplayName().getValue());
                        displayName.setLang("en");
                        portlet.addDisplayName(displayName);
                    }
                    if (portletDescription.getMarkupTypes() != null) {
                        for (MarkupType markupType : portletDescription.getMarkupTypes()) {
                            Supports supports = new Supports();
                            supports.setMimeType(markupType.getMimeType());
                            supports.setPortletMode(Arrays.asList(markupType.getModes()));
                            supports.setWindowState(Arrays.asList(markupType.getWindowStates()));
                            portlet.addSupports(supports);
                        }
                    }
                    portlet.setEscapeXml(Boolean.TRUE);
                    portlet.setApplication(new PortletApp());
                    if (portletDescription.getPublishedEvents() != null) {
                        for (Serializable serializable : portletDescription.getPublishedEvents()) {
                            portlet.addSupportedPublishingEvent((QName)serializable);
                        }
                    }
                    if (portletDescription.getHandledEvents() != null) {
                        for (Serializable serializable : portletDescription.getHandledEvents()) {
                            portlet.addSupportedProcessingEvent((QName)serializable);
                        }
                    }
                    if (portletDescription.getNavigationalPublicValueDescriptions() != null) {
                        for (Serializable serializable : portletDescription.getNavigationalPublicValueDescriptions()) {
                            for (QName parameterName : ((ParameterDescription)serializable).getNames()) {
                                portlet.addSupportedPublicRenderParameter(parameterName.toString());
                            }
                        }
                    }
                    if (StringUtils.split((String)portletHandle, (String)"/").length == 1) {
                        portletHandle = "unnamed/" + portletHandle;
                    }
                    result.put(producerId + "@" + portletHandle, (PortletData)new PortletDataImp(this.container, portlet, null, new ArrayList(), false));
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public PortletApp getPortletApp(String portletAppName) {
        return null;
    }

    public ResourceBundle getBundle(HttpServletRequest request, HttpServletResponse response, String portletAppName, String portletName, Locale locale) throws PortletContainerException {
        this.log.debug((Object)"getBundle method in WSRPConsumerPlugin entered");
        MapResourceBundle bundle = new MapResourceBundle(locale);
        if (portletAppName.equals("@WSRP2App") && portletName.equals("WSRPAdminPortlet")) {
            bundle.add("javax.portlet.title", (Object)"WSRPAdminPortlet");
            bundle.add("javax.portlet.short-title", (Object)"WSRPAdminPortlet");
            bundle.add("javax.portlet.keywords", (Object)"WSRPAdminPortlet");
            return bundle;
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        try {
            PortletDescription pd = this.getProducer(producerID).getPortletDescription(portletHandle);
            bundle.add("javax.portlet.title", (Object)Utils.getStringFromLocalizedString(pd.getTitle()));
            bundle.add("javax.portlet.short-title", (Object)Utils.getStringFromLocalizedString(pd.getShortTitle()));
            if (pd.getKeywords() != null) {
                bundle.add("javax.portlet.keywords", (Object)Utils.getStringFromLocalizedString(pd.getKeywords()[0]));
            } else {
                bundle.add("javax.portlet.keywords", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bundle;
    }

    public void setPortletPreference(Input input, Map<String, String> preferences) throws PortletContainerException {
    }

    public Map<String, String[]> getPortletPreference(Input input) {
        return null;
    }

    public PortletPreferences getPortletPreferences(Input input) {
        return null;
    }

    public void setPortletPreference2(Input input, Map<String, String[]> preferences) throws PortletContainerException {
    }

    public void setPortletPreferences(Input input, PortletPreferences preferences) throws PortletContainerException {
    }

    public ActionOutput processAction(HttpServletRequest request, HttpServletResponse response, ActionInput input) throws PortletContainerException {
        this.log.debug((Object)"processAction method in WSRPConsumerPlugin entered");
        if (!init) {
            return null;
        }
        ActionOutput output = new ActionOutput();
        this.configureTemplateComposer(request);
        String portletAppName = input.getInternalWindowID().getPortletApplicationName();
        String portletName = input.getInternalWindowID().getPortletName();
        String uniqueID = input.getInternalWindowID().getUniqueID();
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            this.adminPortlet.getPortletObject().processAction(input, output, request);
            return output;
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        PortletKey portletKey = null;
        try {
            portletKey = this.getPortletKey(producerID, portletHandle);
        }
        catch (Exception e) {
            throw new PortletContainerException("exception in WSRPConsumerPlugin.processAction method", (Throwable)e);
        }
        if (this.getProducer(portletKey.getProducerId()) != null) {
            try {
                String key = input.getInternalWindowID().generateKey();
                this.log.debug((Object)("use windowID : " + key));
                WSRPPortlet portlet = this.getPortlet(portletKey, portletHandle);
                String newPortletHandle = portletHandle + "/" + uniqueID;
                portlet.getPortletContext().setPortletHandle(newPortletHandle);
                UserSessionMgr userSession = this.getUserSession(request.getSession(), portletKey.getProducerId());
                PortletWindowSession windowSession = this.getWindowSession(portletKey, portlet, userSession, key);
                WSRPInteractionRequest iRequest = this.getInteractionRequest(input, windowSession);
                String baseURL = null;
                baseURL = input.getBaseURL();
                BlockingInteractionResponse iResponse = this.getPortletDriver(portlet).performBlockingInteraction(iRequest, userSession, baseURL);
                if (iResponse != null) {
                    this.log.debug((Object)"manage BlockingInteractionResponse object content");
                    String redirectURL = iResponse.getRedirectURL();
                    if (redirectURL != null) {
                        this.log.debug((Object)("Redirect action to URL : " + redirectURL));
                        if (redirectURL.startsWith("/") || redirectURL.startsWith("http://") || redirectURL.startsWith("https://")) {
                            output.addProperty("_send_redirect_", (Object)redirectURL);
                        } else {
                            this.log.error((Object)"Can not redirect action: a relative or incorrect path URL is given");
                        }
                    } else {
                        UpdateResponse updateResponse = iResponse.getUpdateResponse();
                        if (updateResponse != null) {
                            String newWindowState;
                            output.setEvents(JAXBEventTransformer.getEventsUnmarshal(updateResponse.getEvents()));
                            if (windowSession != null) {
                                this.updateSessionContext(updateResponse.getSessionContext(), windowSession.getPortletSession());
                                windowSession.updateMarkupCache(updateResponse.getMarkupContext());
                            }
                            this.updatePortletContext(updateResponse.getPortletContext(), portlet);
                            this.processNavigationalContext((EventOutput)output, updateResponse.getNavigationalContext());
                            String newMode = updateResponse.getNewMode();
                            if (newMode != null) {
                                this.log.debug((Object)("set Mode required : " + newMode));
                                output.setNextMode(Modes.getJsrPortletMode(newMode));
                            }
                            if ((newWindowState = updateResponse.getNewWindowState()) != null) {
                                this.log.debug((Object)("set new required window state : " + newWindowState));
                                output.setNextState(WindowStates.getJsrWindowState(newWindowState));
                            }
                        }
                    }
                }
                return output;
            }
            catch (WSRPException e) {
                throw new PortletContainerException("exception in WSRPConsumerPlugin.processAction method", (Throwable)e);
            }
        }
        return output;
    }

    private void processNavigationalContext(EventOutput output, NavigationalContext navigationalContext) {
        if (navigationalContext != null) {
            String navState = navigationalContext.getOpaqueValue();
            if (navState != null) {
                this.log.debug((Object)("set new navigational state : " + navState));
                output.setRenderParameter("wsrp-navigationalState", navState);
            }
            NamedString[] namedStrings = navigationalContext.getPublicValues();
            String navigationalValues = "";
            if (namedStrings != null) {
                for (NamedString namedString : namedStrings) {
                    if (navigationalValues != "") {
                        navigationalValues = navigationalValues + "&";
                    }
                    navigationalValues = navigationalValues + namedString.getName() + "=" + namedString.getValue();
                }
            }
            try {
                navigationalValues = URLEncoder.encode(navigationalValues, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            output.setRenderParameter("wsrp-navigationalValues", navigationalValues);
            Map<String, String[]> params = Utils.getMapParametersFromNamedStringArray(namedStrings);
            if (params != null) {
                for (String key : params.keySet()) {
                    output.setRenderParameters(key, params.get(key));
                }
            }
        }
    }

    private PortletDriver getPortletDriver(WSRPPortlet portlet) throws WSRPException {
        return this.consumer.getPortletDriverRegistry().getPortletDriver(portlet);
    }

    private String getProducerID(String portletAppName) {
        if (portletAppName == null) {
            return null;
        }
        if (!portletAppName.contains("@")) {
            return null;
        }
        return portletAppName.substring(0, portletAppName.indexOf("@"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RenderOutput render(HttpServletRequest request, HttpServletResponse response, RenderInput input) throws PortletContainerException {
        this.log.debug((Object)"Render method in WSRPConsumerPlugin entered");
        if (!init) {
            return null;
        }
        RenderOutput output = new RenderOutput();
        this.configureTemplateComposer(request);
        String portletAppName = input.getInternalWindowID().getPortletApplicationName();
        String portletName = input.getInternalWindowID().getPortletName();
        String uniqueID = input.getInternalWindowID().getUniqueID();
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            response.setContentType("text/html");
            this.adminPortlet.getPortletObject().render(input, output);
            return output;
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        try {
            try {
                WindowState state = input.getWindowState();
                if (!state.equals((Object)WindowState.MINIMIZED)) {
                    PortletKey portletKey = this.getPortletKey(producerID, portletHandle);
                    if (this.getProducer(portletKey.getProducerId()) == null) {
                        return output;
                    }
                    WindowID windowID = input.getInternalWindowID();
                    String key = windowID.generateKey();
                    this.log.debug((Object)("key generated by windowID : " + key));
                    response.setContentType(input.getMarkup());
                    try {
                        UserSessionMgr userSession = this.getUserSession(request.getSession(), portletKey.getProducerId());
                        WSRPPortlet portlet = this.getPortlet(portletKey, portletHandle);
                        String newPortletHandle = portletHandle + "/" + uniqueID;
                        portlet.getPortletContext().setPortletHandle(newPortletHandle);
                        PortletWindowSession portletWindowSession = this.getWindowSession(portletKey, portlet, userSession, key);
                        WSRPMarkupRequest markupRequest = this.getMarkupRequest(input, portletWindowSession);
                        String baseURL = null;
                        baseURL = input.getBaseURL();
                        MarkupResponse mResponse = this.getPortletDriver(portlet).getMarkup(markupRequest, userSession, baseURL);
                        if (mResponse != null) {
                            if (portletWindowSession != null) {
                                this.updateSessionContext(mResponse.getSessionContext(), portletWindowSession.getPortletSession());
                            }
                            this.processMarkupContext(mResponse.getMarkupContext(), output);
                        }
                        if (portletWindowSession != null) {
                            this.log.debug((Object)"Update cache");
                            portletWindowSession.updateMarkupCache(null);
                        }
                        if (input.getTitle() == null) return output;
                        output.setTitle(input.getTitle());
                        return output;
                    }
                    catch (Throwable t) {
                        this.log.error((Object)"WS Fault occured", t);
                        PrintWriter w = response.getWriter();
                        ((Writer)w).write("a WSRP Fault occured");
                        return output;
                    }
                }
                if (input.getTitle() != null) {
                    output.setTitle(input.getTitle());
                    return output;
                }
                LocalizedString locStr = this.consumer.getProducerRegistry().getProducer(producerID).getPortletDescription(portletHandle).getTitle();
                output.setTitle(Utils.getStringFromLocalizedString(locStr));
                return output;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    output.setContent(e.toString().getBytes("utf-8"));
                }
                catch (UnsupportedEncodingException unExc) {
                    output.setContent(unExc.toString().getBytes());
                }
            }
        }
        finally {
            return output;
        }
    }

    public void sendAttrs(HttpServletRequest request, HttpServletResponse response, Map<String, Object> attrs, String portletApplicationName) throws PortletContainerException {
    }

    private UserSessionMgr getUserSession(HttpSession httpSession, String producerID) throws WSRPException {
        UserSessionMgr userSession = (UserSessionMgr)httpSession.getAttribute(USER_SESSIONS_KEY + producerID);
        if (userSession == null) {
            this.log.debug((Object)"Create new UserSession");
            userSession = new UserSessionImpl(this.getProducer(producerID).getMarkupInterfaceEndpoint());
            httpSession.setAttribute(USER_SESSIONS_KEY + producerID, (Object)userSession);
        } else {
            this.log.debug((Object)"Use existing UserSession");
        }
        return userSession;
    }

    private PortletKey getPortletKey(String producerID, String portletHandle) throws PortletException {
        PortletKey portletKey = null;
        Iterator<WSRPPortlet> portlets = this.consumer.getPortletRegistry().getAllPortlets();
        while (portlets.hasNext()) {
            WSRPPortlet element = portlets.next();
            if (!producerID.equals(element.getPortletKey().getProducerId()) || !portletHandle.equals(element.getPortletKey().getPortletHandle())) continue;
            portletKey = element.getPortletKey();
        }
        if (portletKey == null) {
            portletKey = new PortletKeyAdapter();
            portletKey.setProducerId(producerID);
            this.log.debug((Object)"user portlet key, producerID : ");
            portletKey.setPortletHandle(portletHandle);
        }
        return portletKey;
    }

    private Producer getProducer(String producerID) {
        this.log.debug((Object)("getProducer : " + producerID));
        Producer producer = this.consumer.getProducerRegistry().getProducer(producerID);
        return producer;
    }

    private User getUser(HttpServletRequest request) {
        User user = null;
        WindowInfosContainer scontainer = WindowInfosContainer.getInstance();
        if (scontainer != null) {
            String userKey = scontainer.getOwner();
            this.log.debug((Object)("getUser method with user key : " + userKey));
            user = this.consumer.getUserRegistry().getUser(userKey);
            if (user == null) {
                user = new UserAdapter();
                UserContext userContext = new UserContext();
                userContext.setProfile(this.fillUserProfile(request));
                userContext.setUserContextKey(userKey);
                user.setUserID(userKey);
                user.setUserContext(userContext);
                this.consumer.getUserRegistry().addUser(user);
            }
        }
        return user;
    }

    private UserProfile fillUserProfile(HttpServletRequest request) {
        UserProfile userProfile = null;
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        if (userInfo != null) {
            userProfile = new UserProfile();
            PersonName personName = new PersonName();
            Object nameObject = userInfo.get("name.given");
            if (nameObject == null) {
                personName.setGiven("unknow name");
            } else {
                personName.setGiven(nameObject.toString());
            }
            userProfile.setName(personName);
        }
        return userProfile;
    }

    private WSRPPortlet getPortlet(PortletKey portletKey, String parentHandle) throws WSRPException {
        WSRPPortlet portlet = null;
        if (portletKey != null && (portlet = this.consumer.getPortletRegistry().getPortlet(portletKey)) == null) {
            portlet = this.createPortlet(portletKey, parentHandle);
            this.consumer.getPortletRegistry().addPortlet(portlet);
        }
        return portlet;
    }

    private WSRPPortlet createPortlet(PortletKey portletKey, String parentHandle) {
        WSRPPortletAdapter portlet = new WSRPPortletAdapter(portletKey);
        PortletContext portletContext = new PortletContext();
        portletContext.setPortletHandle(portletKey.getPortletHandle());
        portlet.setPortletContext(portletContext);
        if (parentHandle != null) {
            portlet.setParent(parentHandle);
        } else {
            portlet.setParent(portletKey.getPortletHandle());
        }
        return portlet;
    }

    private PortletWindowSession getWindowSession(PortletKey portletKey, WSRPPortlet portlet, UserSession userSession, String windowID) throws WSRPException {
        if (userSession != null) {
            this.log.debug((Object)"get group session form user session");
            String groupID = this.getPortletDescription(portlet).getGroupID();
            groupID = groupID == null ? "default" : groupID;
            this.log.debug((Object)("group ID : " + groupID));
            GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
            if (groupSession != null) {
                this.log.debug((Object)"get portlet session from group session");
                PortletSession portletSession = groupSession.getPortletSession(portletKey.getPortletHandle());
                this.log.debug((Object)("portlet handle : " + portletKey.getPortletHandle()));
                if (portletSession != null) {
                    PortletWindowSession windowSession = portletSession.getPortletWindowSession(windowID);
                    this.log.debug((Object)"success in extraction of the window session");
                    return windowSession;
                }
                this.log.error((Object)"portlet session was null");
                throw new WSRPException("InvalidSession");
            }
            this.log.error((Object)"group session was null");
            throw new WSRPException("InvalidSession");
        }
        this.log.error((Object)"user session was null");
        throw new WSRPException("InvalidSession");
    }

    private PortletDescription getPortletDescription(WSRPPortlet portlet) throws WSRPException {
        this.log.debug((Object)"getPortletDescription entered");
        String producerID = portlet.getPortletKey().getProducerId();
        Producer producer = this.getProducer(producerID);
        PortletDescription portletDesc = producer.getPortletDescription(portlet.getParent());
        if (portletDesc == null) {
            throw new WSRPException("unknownPortletDescription");
        }
        return portletDesc;
    }

    private WSRPInteractionRequest getInteractionRequest(ActionInput input, PortletWindowSession portletWindowSession) {
        this.log.debug((Object)"getInteractionRequest entered");
        WSRPInteractionRequestAdapter interactionRequest = new WSRPInteractionRequestAdapter();
        this.fillMimeRequest(interactionRequest, (Input)input, portletWindowSession);
        interactionRequest.setFormParameters(this.getRenderParametersAsNamedString((Input)input));
        interactionRequest.setInteractionState(this.getInteractionState((Input)input, portletWindowSession));
        return interactionRequest;
    }

    private String getInteractionState(Input input, PortletWindowSession portletWindowSession) {
        if (input != null && input.getRenderParameters() != null) {
            String[] interactionState = (String[])input.getRenderParameters().get("wsrp-interactionState");
            if (interactionState != null && interactionState.length != 0) {
                this.log.debug((Object)("user interaction state : " + interactionState[0]));
                portletWindowSession.setInteractionState(interactionState[0]);
            } else {
                this.log.debug((Object)"Interaction state is null");
            }
        } else {
            this.log.debug((Object)"Input input is null or input.getRenderParameters() is null");
        }
        return portletWindowSession.getInteractionState();
    }

    private NamedString[] getRenderParametersAsNamedString(Input input) {
        Map params = input.getRenderParameters();
        return Utils.getNamedStringArrayParametersFromMap(params, true);
    }

    private void fillMimeRequest(WSRPBaseRequestAdapter baseRequest, Input input, PortletWindowSession portletWindowSession) {
        SessionContext sc;
        baseRequest.setMarkupCharacterSets(characterEncodings);
        baseRequest.setClientData(this.getClientData());
        List locales = input.getLocales();
        ArrayList<String> localesStrings = new ArrayList<String>();
        if (locales != null) {
            for (Locale locale : locales) {
                localesStrings.add(locale.toString());
            }
            baseRequest.setLocales(localesStrings.toArray(new String[input.getLocales().size()]));
        } else {
            baseRequest.setLocales(SUPPORTED_LOCALES);
        }
        Collection supportedContent = this.pcConf.getSupportedContent();
        String[] mimeTypes = supportedContent.toArray(new String[supportedContent.size()]);
        baseRequest.setMimeTypes(mimeTypes);
        baseRequest.setMode(Modes.getWSRPModeString(input.getPortletMode()));
        baseRequest.setValidNewModes(null);
        baseRequest.setWindowState(WindowStates.getWSRPStateString(input.getWindowState()));
        baseRequest.setValidNewWindowStates(null);
        baseRequest.setSecureClientCommunication(false);
        baseRequest.setUserAuthentication("none");
        baseRequest.setExtensions(null);
        baseRequest.setNavigationalState(this.getNavigationalState(input, portletWindowSession));
        baseRequest.setNavigationalValues(this.getNavigationalValues(input, portletWindowSession));
        if (input.getPublicParameterMap() != null) {
            baseRequest.setNavigationalValues(Utils.getNamedStringArrayParametersFromMap(input.getPublicParameterMap()));
        }
        if ((sc = portletWindowSession.getPortletSession().getSessionContext()) != null) {
            baseRequest.setSessionID(sc.getSessionID());
        }
        baseRequest.setPortletInstanceKey(input.getInternalWindowID().generateKey());
    }

    private ClientData getClientData() {
        ClientData clientData = new ClientData();
        clientData.setUserAgent(userAgent);
        clientData.setCcppHeaders(null);
        clientData.setClientAttributes(null);
        clientData.setRequestVerb(null);
        return clientData;
    }

    private String getNavigationalState(Input input, PortletWindowSession portletWindowSession) {
        if (input != null && input.getRenderParameters() != null) {
            String[] navigationalState = (String[])input.getRenderParameters().get("wsrp-navigationalState");
            if (navigationalState != null && navigationalState.length != 0) {
                this.log.debug((Object)("user navigational state : " + navigationalState[0]));
                portletWindowSession.setNavigationalState(navigationalState[0]);
            } else {
                this.log.debug((Object)"Navigational state is null or empty");
            }
        } else {
            this.log.debug((Object)"Input input is null or input.getRenderParameters() is null");
        }
        return portletWindowSession.getNavigationalState();
    }

    private NamedString[] getNavigationalValues(Input input, PortletWindowSession portletWindowSession) {
        String parameterNavigationalValues;
        NamedString[] resultArray = null;
        if (input.getRenderParameters() != null && input.getRenderParameters().get("wsrp-navigationalValues") != null && (parameterNavigationalValues = ((String[])input.getRenderParameters().get("wsrp-navigationalValues"))[0]) != null && parameterNavigationalValues != "") {
            String[] navigationalValues;
            String parameterNavigationalValuesDec = null;
            try {
                parameterNavigationalValuesDec = URLDecoder.decode(parameterNavigationalValues, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parameterNavigationalValuesDec != null && (navigationalValues = parameterNavigationalValuesDec.split("&")) != null) {
                ArrayList<NamedString> navigationalValuesList = new ArrayList<NamedString>(navigationalValues.length);
                for (String navigationalValue : navigationalValues) {
                    navigationalValuesList.add(new NamedString(navigationalValue, null));
                }
                resultArray = navigationalValuesList.toArray(new NamedString[navigationalValues.length]);
            }
        }
        if (resultArray != null) {
            this.log.debug((Object)("user navigational values : " + resultArray));
            portletWindowSession.setNavigationalValues(resultArray);
        } else {
            this.log.debug((Object)"Navigational values are null");
        }
        return portletWindowSession.getNavigationalValues();
    }

    private void updateSessionContext(SessionContext sessionContext, PortletSession portletSession) {
        if (sessionContext != null) {
            this.log.debug((Object)"update session context");
            if (portletSession != null) {
                portletSession.setSessionContext(sessionContext);
            }
        }
    }

    private void updatePortletContext(PortletContext portletContext, WSRPPortlet portlet) throws WSRPException {
        if (portletContext != null && portlet != null) {
            this.log.debug((Object)"update portlet context");
            String newPortletHandle = portletContext.getPortletHandle();
            PortletKey portletKey = portlet.getPortletKey();
            if (newPortletHandle != null && !newPortletHandle.equals(portletKey.getPortletHandle())) {
                this.log.debug((Object)("portlet was cloned, new handle : " + newPortletHandle));
                String producerID = portletKey.getProducerId();
                PortletKeyAdapter newPortletKey = new PortletKeyAdapter();
                portletKey.setPortletHandle(newPortletHandle);
                portletKey.setPortletHandle(producerID);
                portlet = this.createPortlet(newPortletKey, portlet.getParent());
                this.consumer.getPortletRegistry().addPortlet(portlet);
            }
            portlet.setPortletContext(portletContext);
        }
    }

    private WSRPMarkupRequest getMarkupRequest(RenderInput input, PortletWindowSession portletWindowSession) {
        WSRPMarkupRequestAdapter markupRequest = new WSRPMarkupRequestAdapter();
        this.fillMimeRequest(markupRequest, (Input)input, portletWindowSession);
        markupRequest.setCachedMarkup(portletWindowSession.getCachedMarkup());
        return markupRequest;
    }

    private void processMarkupContext(MarkupContext markupContext, RenderOutput output) throws WSRPException {
        this.log.debug((Object)"process markup context for returned markup");
        if (markupContext != null && output != null) {
            this.processMimeResponse(markupContext, output);
            output.setNextPossiblePortletModes(this.getPortletModesFromStrings(markupContext.getValidNewModes()));
            String title = markupContext.getPreferredTitle();
            if (title != null) {
                this.log.debug((Object)("user title : " + title));
                output.setTitle(title);
            }
        }
    }

    private Collection<PortletMode> getPortletModesFromStrings(String[] validNewModes) {
        if (validNewModes == null) {
            return null;
        }
        ArrayList<PortletMode> portletModes = new ArrayList<PortletMode>();
        for (String mode : validNewModes) {
            portletModes.add(new PortletMode(mode));
        }
        return portletModes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceOutput serveResource(HttpServletRequest request, HttpServletResponse response, ResourceInput input) throws PortletContainerException {
        this.log.debug((Object)"serveResource method in WSRPConsumerPlugin entered");
        if (!init) {
            return null;
        }
        ResourceOutput output = new ResourceOutput();
        this.configureTemplateComposer(request);
        String portletAppName = input.getInternalWindowID().getPortletApplicationName();
        String portletName = input.getInternalWindowID().getPortletName();
        String uniqueID = input.getInternalWindowID().getUniqueID();
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            response.setContentType("text/html");
            this.adminPortlet.getPortletObject().serveResource(input, output);
            return output;
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        try {
            try {
                WindowState state = input.getWindowState();
                if (!state.equals((Object)WindowState.MINIMIZED)) {
                    PortletKey portletKey = this.getPortletKey(producerID, portletHandle);
                    if (this.getProducer(portletKey.getProducerId()) == null) {
                        return output;
                    }
                    WindowID windowID = input.getInternalWindowID();
                    String key = windowID.generateKey();
                    this.log.debug((Object)("key generated by windowID : " + key));
                    response.setContentType(input.getMarkup());
                    try {
                        UserSessionMgr userSession = this.getUserSession(request.getSession(), portletKey.getProducerId());
                        WSRPPortlet portlet = this.getPortlet(portletKey, portletHandle);
                        String newPortletHandle = portletHandle + "/" + uniqueID;
                        portlet.getPortletContext().setPortletHandle(newPortletHandle);
                        PortletWindowSession portletWindowSession = this.getWindowSession(portletKey, portlet, userSession, key);
                        WSRPResourceRequest resourceRequest = this.getResourceRequest(input, portletWindowSession);
                        String baseURL = null;
                        baseURL = input.getBaseURL();
                        ResourceResponse resResponse = this.getPortletDriver(portlet).getResource(resourceRequest, userSession, baseURL);
                        if (resResponse != null) {
                            if (portletWindowSession != null) {
                                this.updateSessionContext(resResponse.getSessionContext(), portletWindowSession.getPortletSession());
                            }
                            this.processResourceContext(resResponse.getResourceContext(), output);
                        }
                        if (portletWindowSession != null) {
                            this.log.debug((Object)"Update cache");
                            portletWindowSession.updateMarkupCache(null);
                        }
                        if (input.getTitle() == null) return output;
                        output.setTitle(input.getTitle());
                        return output;
                    }
                    catch (Throwable t) {
                        this.log.error((Object)"WS Fault occured", t);
                        PrintWriter w = response.getWriter();
                        ((Writer)w).write("a WSRP Fault occured");
                        return output;
                    }
                }
                if (input.getTitle() != null) {
                    output.setTitle(input.getTitle());
                    return output;
                }
                LocalizedString locStr = this.consumer.getProducerRegistry().getProducer(producerID).getPortletDescription(portletHandle).getTitle();
                output.setTitle(Utils.getStringFromLocalizedString(locStr));
                return output;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    output.setContent(e.toString().getBytes("utf-8"));
                }
                catch (UnsupportedEncodingException unExc) {
                    output.setContent(unExc.toString().getBytes());
                }
            }
        }
        finally {
            return output;
        }
    }

    private void configureTemplateComposer(HttpServletRequest request) {
        this.templateComposer.setHost(request.getServerName());
        this.templateComposer.setPort(request.getServerPort());
    }

    private WSRPResourceRequest getResourceRequest(ResourceInput input, PortletWindowSession portletWindowSession) {
        WSRPResourceRequestAdapter resourceRequest = new WSRPResourceRequestAdapter();
        this.fillMimeRequest(resourceRequest, (Input)input, portletWindowSession);
        resourceRequest.setFormParameters(this.getRenderParametersAsNamedString((Input)input));
        resourceRequest.setResourceID(input.getResourceID());
        resourceRequest.setResourceState(this.getResourceState((Input)input, portletWindowSession));
        resourceRequest.setResourceCacheability(input.getCacheability());
        resourceRequest.setCachedResource(portletWindowSession.getCachedResource());
        return resourceRequest;
    }

    private String getResourceState(Input input, PortletWindowSession portletWindowSession) {
        if (input != null && input.getRenderParameters() != null) {
            String[] resourceState = (String[])input.getRenderParameters().get("wsrp-resourceState");
            if (resourceState != null && resourceState.length != 0) {
                this.log.debug((Object)("user resource state : " + resourceState[0]));
                portletWindowSession.setResourceState(resourceState[0]);
            } else {
                this.log.debug((Object)"Resource state is null");
            }
        } else {
            this.log.debug((Object)"Input input is null or input.getRenderParameters() is null");
        }
        return portletWindowSession.getResourceState();
    }

    private void processResourceContext(ResourceContext resourceContext, ResourceOutput output) throws WSRPException {
        this.log.debug((Object)"process resource context for returned markup");
        if (resourceContext != null && output != null) {
            this.processMimeResponse(resourceContext, (RenderOutput)output);
        }
    }

    private void processMimeResponse(MimeResponse mimeResponse, RenderOutput output) throws WSRPException {
        this.log.debug((Object)"process resource context for returned markup");
        if (mimeResponse != null && output != null) {
            byte[] binaryMarkup;
            if (mimeResponse.getMimeType() != null) {
                output.setContentType(mimeResponse.getMimeType());
            }
            if ((binaryMarkup = mimeResponse.getItemBinary()) == null && mimeResponse.getItemString() != null) {
                this.log.debug((Object)"string markup not null");
                try {
                    binaryMarkup = mimeResponse.getItemString().getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    binaryMarkup = mimeResponse.getItemString().getBytes();
                }
            } else {
                this.log.debug((Object)"binary markup not null");
            }
            output.setContent(binaryMarkup);
        }
    }

    public EventOutput processEvent(HttpServletRequest request, HttpServletResponse response, EventInput input) throws PortletContainerException {
        this.log.debug((Object)"processEvent method in WSRPConsumerPlugin entered");
        if (!init) {
            return null;
        }
        EventOutput output = new EventOutput();
        this.configureTemplateComposer(request);
        String portletAppName = input.getInternalWindowID().getPortletApplicationName();
        String portletName = input.getInternalWindowID().getPortletName();
        String uniqueID = input.getInternalWindowID().getUniqueID();
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            this.adminPortlet.getPortletObject().processEvent(input, output);
            return output;
        }
        String producerID = this.getProducerID(portletAppName);
        String portletHandle = this.getPortletHandle(portletAppName, portletName);
        PortletKey portletKey = null;
        try {
            portletKey = this.getPortletKey(producerID, portletHandle);
        }
        catch (Exception e) {
            throw new PortletContainerException("exception in WSRPConsumerPlugin.processAction method", (Throwable)e);
        }
        if (this.getProducer(portletKey.getProducerId()) != null) {
            try {
                String key = input.getInternalWindowID().generateKey();
                this.log.debug((Object)("use windowID : " + key));
                WSRPPortlet portlet = this.getPortlet(portletKey, portletHandle);
                String newPortletHandle = portletHandle + "/" + uniqueID;
                portlet.getPortletContext().setPortletHandle(newPortletHandle);
                UserSessionMgr userSession = this.getUserSession(request.getSession(), portletKey.getProducerId());
                PortletWindowSession windowSession = this.getWindowSession(portletKey, portlet, userSession, key);
                WSRPEventsRequest iRequest = this.getEventsRequest(input, windowSession);
                String baseURL = null;
                baseURL = input.getBaseURL();
                HandleEventsResponse iResponse = this.getPortletDriver(portlet).handleEvents(iRequest, userSession, baseURL);
                if (iResponse != null) {
                    this.log.debug((Object)"manage BlockingInteractionResponse object content");
                    UpdateResponse updateResponse = iResponse.getUpdateResponse();
                    if (updateResponse != null) {
                        String newWindowState;
                        output.setEvents(JAXBEventTransformer.getEventsUnmarshal(updateResponse.getEvents()));
                        if (windowSession != null) {
                            this.updateSessionContext(updateResponse.getSessionContext(), windowSession.getPortletSession());
                            windowSession.updateMarkupCache(updateResponse.getMarkupContext());
                        }
                        this.updatePortletContext(updateResponse.getPortletContext(), portlet);
                        this.processNavigationalContext(output, updateResponse.getNavigationalContext());
                        String newMode = updateResponse.getNewMode();
                        if (newMode != null) {
                            this.log.debug((Object)("set Mode required : " + newMode));
                            output.setNextMode(Modes.getJsrPortletMode(newMode));
                        }
                        if ((newWindowState = updateResponse.getNewWindowState()) != null) {
                            this.log.debug((Object)("set new required window state : " + newWindowState));
                            output.setNextState(WindowStates.getJsrWindowState(newWindowState));
                        }
                    }
                }
                return output;
            }
            catch (WSRPException e) {
                e.printStackTrace();
                throw new PortletContainerException("exception in WSRPConsumerPlugin.processEvent method", (Throwable)e);
            }
        }
        return output;
    }

    private WSRPEventsRequest getEventsRequest(EventInput input, PortletWindowSession portletWindowSession) {
        WSRPEventsRequestAdapter eventRequest = new WSRPEventsRequestAdapter();
        this.fillMimeRequest(eventRequest, (Input)input, portletWindowSession);
        eventRequest.setEvents(JAXBEventTransformer.getEventsMarshal(input.getEvent()));
        return eventRequest;
    }

    public final Collection<String> getPortletAppNames() {
        this.log.debug((Object)"getPortletAppNames() entered");
        HashSet<String> result = new HashSet<String>();
        result.add("@WSRP2App");
        String producerId = null;
        String portletHandle = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        ServiceDescription desc = null;
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                desc = producer.getServiceDescription();
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
            producerId = producer.getID();
            PortletDescription[] portletDescriptions = desc.getOfferedPortlets();
            if (portletDescriptions == null) continue;
            for (int k = 0; k < portletDescriptions.length; ++k) {
                PortletDescription portletDescription = portletDescriptions[k];
                portletHandle = portletDescription.getPortletHandle();
                if (StringUtils.split((String)portletHandle, (String)"/").length == 1) {
                    portletHandle = "unnamed/" + portletHandle;
                }
                String newPortletHandle = producerId + "@" + portletHandle;
                String[] ss = StringUtils.split((String)newPortletHandle, (String)"/");
                String portletAppName = ss[0];
                result.add(portletAppName);
            }
        }
        return result;
    }
}

