/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPHTTPContainer;

public class AxisFilter
implements Filter {
    private String containerName = "portal";
    private ExoContainer container;
    private Log log = ExoLogger.getLogger((String)this.getClass().getName());

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log = ExoLogger.getLogger((String)this.getClass().getName());
        String containerName = filterConfig.getInitParameter("portal-container-name");
        if (containerName != null) {
            this.containerName = containerName;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("this.containerName = " + this.containerName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.setCurrentContainer();
            WSRPHTTPContainer.createInstance((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (this.container != null) {
                try {
                    this.hibernateCloseSession();
                }
                catch (Exception e) {
                    this.log.warn((Object)"An error occured while closing the hibernate sessions", (Throwable)e);
                }
            }
            try {
                WSRPHTTPContainer.setInstance(null);
            }
            catch (Exception e) {
                this.log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
            try {
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                this.log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    private void hibernateCloseSession() {
        List list = this.container.getComponentInstancesOfType(HibernateService.class);
        for (HibernateService hservice : list) {
            hservice.closeSession();
        }
    }

    private void setCurrentContainer() {
        this.container = ExoContainerContext.getContainerByName((String)this.containerName);
        if (this.container == null) {
            this.container = ExoContainerContext.getTopContainer();
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
    }

    public void destroy() {
    }
}

