/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.helper.IOUtil;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.PersistentStateManager;
import org.exoplatform.services.wsrp2.producer.impl.WSRP2StateData;
import org.exoplatform.services.wsrp2.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp2.producer.impl.helpers.ConsumerContext;
import org.exoplatform.services.wsrp2.type.Lifetime;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.RegistrationData;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentStateManagerImpl
implements PersistentStateManager {
    private static final String queryStateData = "from sd in class org.exoplatform.services.wsrp2.producer.impl.WSRP2StateData where sd.id = ?";
    private WSRPConfiguration conf;
    private final Log log = ExoLogger.getLogger((String)this.getClass().getName());
    private ExoCache cache;
    private HibernateService hservice;

    public PersistentStateManagerImpl(CacheService cacheService, HibernateService hservice, WSRPConfiguration conf) throws Exception {
        this.conf = conf;
        this.hservice = hservice;
        this.cache = cacheService.getCacheInstance(this.getClass().getName());
    }

    @Override
    public RegistrationData getRegistrationData(RegistrationContext registrationContext) throws WSRPException {
        if (this.conf.isSaveRegistrationStateOnConsumer()) {
            this.log.debug((Object)"Lookup registration stored on the consumer");
            return this.resolveRegistrationData(registrationContext);
        }
        this.log.debug((Object)"Lookup registration data stored on the producer");
        try {
            WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
            if (sD == null) {
                return null;
            }
            return ((ConsumerContext)sD.getDataObject()).getRegistationData();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not extract Registration data from persistent store");
            throw new WSRPException("OperationFailed", e);
        }
    }

    @Override
    public byte[] register(String registrationHandle, RegistrationData data) throws WSRPException {
        if (this.conf.isSaveRegistrationStateOnConsumer()) {
            this.log.debug((Object)"Register and send the registration state to the consumer");
            try {
                byte[] bytes = IOUtil.serialize((Object[])new Object[]{data});
                try {
                    this.save(registrationHandle, "java.util.Collection", new ArrayList());
                }
                catch (Exception e) {
                    this.log.error((Object)"Persistence error");
                    throw new WSRPException("OperationFailed", e);
                }
                return bytes;
            }
            catch (Exception e) {
                this.log.error((Object)"Can not serialize RegistrationData", (Throwable)e);
                throw new WSRPException("OperationFailed", e);
            }
        }
        this.log.debug((Object)"Register and save the registration state in the producer");
        ConsumerContext cC = new ConsumerContext(registrationHandle, data);
        try {
            this.save(registrationHandle, "org.exoplatform.services.wsrp2.producer.impl.helpers.ConsumerContext", cC);
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)"Persistence error");
            throw new WSRPException("OperationFailed", e);
        }
    }

    @Override
    public void deregister(RegistrationContext registrationContext) throws WSRPException {
        try {
            if (!this.conf.isSaveRegistrationStateOnConsumer()) {
                this.log.debug((Object)"Deregister the consumer (state save on producer)");
                this.remove(registrationContext.getRegistrationHandle());
            } else {
                this.log.debug((Object)"Deregister the consumer (state save on consumer)");
                this.remove(registrationContext.getRegistrationHandle());
            }
        }
        catch (Exception e) {
            throw new WSRPException("OperationFailed", e);
        }
    }

    @Override
    public boolean isRegistered(RegistrationContext registrationContext) throws WSRPException {
        this.log.debug((Object)"Look up from a registration stored");
        try {
            WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
            if (sD == null) {
                return false;
            }
            if (sD.getDataObject() != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Can not extract Registration data from persistent store");
            throw new WSRPException("OperationFailed", e);
        }
        this.log.debug((Object)"Look up failed");
        return false;
    }

    @Override
    public boolean isConsumerConfiguredPortlet(String portletHandle, RegistrationContext registrationContext) throws WSRPException {
        if (this.conf.isSaveRegistrationStateOnConsumer()) {
            Collection c = null;
            try {
                WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
                if (sD == null) {
                    return false;
                }
                c = (Collection)sD.getDataObject();
            }
            catch (Exception e) {
                this.log.error((Object)"Can not extract Registration data from persistent store", (Throwable)e);
                throw new WSRPException("OperationFailed", e);
            }
            return c.contains(portletHandle);
        }
        ConsumerContext consumerContext = null;
        try {
            WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
            if (sD == null) {
                return false;
            }
            consumerContext = (ConsumerContext)sD.getDataObject();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not extract Registration data from persistent store");
            throw new WSRPException("OperationFailed", e);
        }
        return consumerContext.isPortletHandleRegistered(portletHandle);
    }

    @Override
    public void addConsumerConfiguredPortletHandle(String portletHandle, RegistrationContext registrationContext) throws WSRPException {
        if (this.conf.isSaveRegistrationStateOnConsumer()) {
            Collection c = null;
            try {
                WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
                if (sD == null) {
                    return;
                }
                c = (Collection)sD.getDataObject();
            }
            catch (Exception e) {
                this.log.error((Object)"Can not extract Registration data from persistent store");
                throw new WSRPException("OperationFailed", e);
            }
            c.add(portletHandle);
        } else {
            ConsumerContext consumerContext = null;
            try {
                WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
                if (sD == null) {
                    return;
                }
                consumerContext = (ConsumerContext)sD.getDataObject();
            }
            catch (Exception e) {
                this.log.error((Object)"Can not extract Registration data from persistent store");
                throw new WSRPException("OperationFailed", e);
            }
            consumerContext.addPortletHandle(portletHandle);
        }
    }

    @Override
    public void removeConsumerConfiguredPortletHandle(String portletHandle, RegistrationContext registrationContext) throws WSRPException {
        if (this.conf.isSaveRegistrationStateOnConsumer()) {
            Collection c = null;
            try {
                WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
                if (sD == null) {
                    return;
                }
                c = (Collection)sD.getDataObject();
            }
            catch (Exception e) {
                this.log.error((Object)"Can not extract Registration data from persistent store");
                throw new WSRPException("OperationFailed", e);
            }
            c.remove(portletHandle);
        } else {
            ConsumerContext consumerContext = null;
            try {
                WSRP2StateData sD = this.load(registrationContext.getRegistrationHandle());
                if (sD == null) {
                    return;
                }
                consumerContext = (ConsumerContext)sD.getDataObject();
            }
            catch (Exception e) {
                this.log.error((Object)"Can not extract Registration data from persistent store");
                throw new WSRPException("OperationFailed", e);
            }
            consumerContext.removePortletHandle(portletHandle);
        }
    }

    private RegistrationData resolveRegistrationData(RegistrationContext registrationContext) throws WSRPException {
        byte[] registrationState = registrationContext.getRegistrationState();
        if (registrationState == null) {
            throw new WSRPException("MissingParameters");
        }
        Object o = null;
        try {
            o = IOUtil.deserialize((byte[])registrationState);
        }
        catch (Exception e) {
            this.log.error((Object)"Can not deserialize the RegistrationData object sent by the consumer");
            throw new WSRPException("OperationFailed", e);
        }
        if (o instanceof RegistrationData) {
            return (RegistrationData)o;
        }
        this.log.error((Object)"The registration state is not of type RegistrationData");
        throw new WSRPException("OperationFailed");
    }

    public final void save(String key, String type, Object o) throws Exception {
        Session session = this.hservice.openSession();
        WSRP2StateData data = this.load(key);
        if (data == null) {
            data = new WSRP2StateData();
            data.setId(key);
            data.setDataType(type);
            this.cache.put((Serializable)((Object)key), (Object)data);
        } else {
            session.delete((Object)data);
            session.flush();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Same data id is going to stored with: '" + data.getId() + "'"));
            }
        }
        data.setDataObject(o);
        session.save((Object)data);
        session.flush();
    }

    public final WSRP2StateData load(String key) throws Exception {
        Session session;
        List l;
        WSRP2StateData data = (WSRP2StateData)this.cache.get((Serializable)((Object)key));
        if (data == null && (l = (session = this.hservice.openSession()).createQuery(queryStateData).setString(0, key).list()).size() <= 1 && l.size() == 1) {
            data = (WSRP2StateData)l.get(0);
            this.cache.put((Serializable)((Object)key), (Object)data);
        }
        return data;
    }

    public final void remove(String key) throws Exception {
        Session session = this.hservice.openSession();
        WSRP2StateData data = (WSRP2StateData)this.cache.remove((Serializable)((Object)key));
        if (data == null) {
            List l = session.createQuery(queryStateData).setString(0, key).list();
            if (l.size() > 1) {
                throw new Exception("Expect only one configuration but found" + l.size());
            }
            if (l.size() == 1) {
                data = (WSRP2StateData)l.get(0);
                this.cache.put((Serializable)((Object)key), (Object)data);
            }
        } else {
            session.delete((Object)data);
            session.flush();
        }
    }

    @Override
    public Map<String, String[]> getNavigationalState(String navigationalState) throws WSRPException {
        return this.getState(navigationalState);
    }

    @Override
    public void putNavigationalState(String navigationalState, Map<String, String[]> renderParameters) throws WSRPException {
        this.putState(navigationalState, renderParameters);
    }

    @Override
    public Map<String, String[]> getInteractionSate(String interactionState) throws WSRPException {
        return this.getState(interactionState);
    }

    @Override
    public void putInteractionState(String interactionState, Map<String, String[]> interactionParameters) throws WSRPException {
        this.putState(interactionState, interactionParameters);
    }

    @Override
    public Map<String, String[]> getResourceState(String resourceState) throws WSRPException {
        return this.getState(resourceState);
    }

    @Override
    public void putResourceState(String resourceState, Map<String, String[]> resourceParameters) throws WSRPException {
        this.putState(resourceState, resourceParameters);
    }

    private Map<String, String[]> getState(String state) throws WSRPException {
        try {
            WSRP2StateData sD = this.load(state);
            if (sD == null) {
                return null;
            }
            return (Map)sD.getDataObject();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not extract Render Parameters Map from persistent store", (Throwable)e);
            throw new WSRPException("OperationFailed", e);
        }
    }

    private void putState(String state, Map<String, String[]> parameters) throws WSRPException {
        try {
            this.save(state, "java.util.Map", parameters);
        }
        catch (Exception e) {
            this.log.error((Object)"Can not save Render Parameters Map to persistent store", (Throwable)e);
            throw new WSRPException("OperationFailed", e);
        }
    }

    @Override
    public Lifetime putRegistrationLifetime(String registrationHandle, Lifetime lifetime) throws WSRPException {
        return this.putLifetime(registrationHandle + "lifetime", lifetime);
    }

    @Override
    public Lifetime getRegistrationLifetime(RegistrationContext registrationContext) throws WSRPException {
        this.log.debug((Object)"Look up getRegistrationLifetime");
        return this.getLifetime(registrationContext.getRegistrationHandle() + "lifetime");
    }

    @Override
    public Lifetime putPortletLifetime(String portletHandle, Lifetime lifetime) throws WSRPException {
        return this.putLifetime(portletHandle + "lifetime", lifetime);
    }

    @Override
    public Lifetime getPortletLifetime(String portletHandle) throws WSRPException {
        return this.getLifetime(portletHandle + "lifetime");
    }

    private Lifetime getLifetime(String key) throws WSRPException {
        this.log.debug((Object)"Look up getRegistrationLifetime");
        try {
            WSRP2StateData sD = this.load(key);
            if (sD == null) {
                return null;
            }
            Lifetime lf = (Lifetime)sD.getDataObject();
            lf.setCurrentTime(Calendar.getInstance());
            return lf;
        }
        catch (Exception e) {
            this.log.error((Object)"Can not extract Registration Lifetime from persistent store", (Throwable)e);
            throw new WSRPException("OperationFailed", e);
        }
    }

    private Lifetime putLifetime(String key, Lifetime lifetime) throws WSRPException {
        if (lifetime == null) {
            this.removeLifetime(key);
            return null;
        }
        try {
            this.save(key, "org.exoplatform.services.wsrp2.type.Lifetime", lifetime);
        }
        catch (Exception e) {
            this.log.error((Object)"Can not save Registration Lifetime to persistent store", (Throwable)e);
            throw new WSRPException("OperationFailed", e);
        }
        return lifetime;
    }

    private void removeLifetime(String key) throws WSRPException {
        try {
            this.remove(key);
        }
        catch (Exception e) {
            throw new WSRPException("OperationFailed", e);
        }
    }
}

