/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.exoplatform.services.wsrp2.consumer.URLTemplateComposer;

public class URLTemplateComposerImpl
implements URLTemplateComposer {
    public static final String SECURE_PROTOCOL = "https://";
    public static final String NON_SECURE_PROTOCOL = "http://";
    private String host = "localhost";
    private int port = 8080;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String createBlockingActionTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(NON_SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String createSecureBlockingActionTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String createRenderTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(NON_SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String createSecureRenderTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String createResourceTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(NON_SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String createSecureResourceTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String createDefaultTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(NON_SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String createSecureDefaultTemplate(String path) {
        StringBuffer sB = new StringBuffer();
        sB.append(SECURE_PROTOCOL);
        this.manageServerPath(sB, path);
        this.appendParameters(sB, path);
        return sB.toString();
    }

    public String getNamespacePrefix() {
        return "";
    }

    private void manageServerPath(StringBuffer stringBuffer, String path) {
        String newPath = null;
        try {
            URL url = new URL(path);
            this.host = url.getHost();
            this.port = url.getPort();
            newPath = url.getFile();
        }
        catch (MalformedURLException e) {
            newPath = path;
        }
        stringBuffer.append(this.host);
        if (this.port > 0) {
            stringBuffer.append(":").append(this.port);
        }
        stringBuffer.append(newPath);
    }

    private void appendParameters(StringBuffer stringBuffer, String path) {
        stringBuffer.append("&portal:type={wsrp-urlType}");
        stringBuffer.append("&portal:portletMode={wsrp-mode}");
        stringBuffer.append("&portal:windowState={wsrp-windowState}");
        stringBuffer.append("&portal:isSecure={wsrp-secureURL}");
        stringBuffer.append("&wsrp-portletHandle={wsrp-portletHandle}");
        stringBuffer.append("&wsrp-userContextKey={wsrp-userContextKey}");
        stringBuffer.append("&wsrp-portletInstanceKey={wsrp-portletInstanceKey}");
        stringBuffer.append("&wsrp-sessionID={wsrp-sessionID}");
        stringBuffer.append("&wsrp-pageState={wsrp-pageState}");
        stringBuffer.append("&wsrp-portletStates={wsrp-portletStates}");
        stringBuffer.append("&wsrp-navigationalState={wsrp-navigationalState}");
        stringBuffer.append("&wsrp-navigationalValues={wsrp-navigationalValues}");
        stringBuffer.append("&wsrp-requiresRewrite={wsrp-requiresRewrite}");
        stringBuffer.append("&wsrp-preferOperation={wsrp-preferOperation}");
        stringBuffer.append("&wsrp-interactionState={wsrp-interactionState}");
        stringBuffer.append("&wsrp-fragmentID={wsrp-fragmentID}");
        stringBuffer.append("&wsrp-extensions={wsrp-extensions}");
        stringBuffer.append("&wsrp-url={wsrp-url}");
        stringBuffer.append("&wsrp-resourceID={wsrp-resourceID}");
        stringBuffer.append("&wsrp-resourceState={wsrp-resourceState}");
        stringBuffer.append("&wsrp-resourceCacheability={wsrp-resourceCacheability}");
    }
}

