/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.filter;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPHttpServletRequest;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPHttpSession;

public class AxisFilter
implements Filter {
    private String containerName = "portal";
    private Integer retriesToRegister = 2;
    private ExoContainer container;
    private WSRPHttpServletRequest wsrpHttpServletRequest;
    private WSRPHttpSession wsrpHttpSession;

    public void init(FilterConfig filterConfig) throws ServletException {
        Integer retriesToRegister;
        String containerName = filterConfig.getInitParameter("portal-container-name");
        if (containerName != null) {
            this.containerName = containerName;
        }
        if ((retriesToRegister = new Integer(filterConfig.getInitParameter("retries-to-register"))) != null) {
            this.retriesToRegister = retriesToRegister;
        }
    }

    public synchronized void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.wsrpHttpServletRequest = new WSRPHttpServletRequest((HttpServletRequest)servletRequest);
        HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession();
        this.wsrpHttpSession = new WSRPHttpSession(httpSession.getId(), httpSession.getMaxInactiveInterval());
        int i = this.retriesToRegister;
        while (i != 0) {
            try {
                this.register();
                i = 0;
            }
            catch (ConcurrentModificationException e) {
                if (i <= 0) continue;
                --i;
            }
        }
        i = this.retriesToRegister;
        while (i != 0) {
            try {
                this.hibernateCloseSession();
                i = 0;
            }
            catch (ConcurrentModificationException e) {
                if (i <= 0) continue;
                --i;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void register() {
        this.container = ExoContainerContext.getContainerByName((String)this.containerName);
        if (this.container == null) {
            this.container = ExoContainerContext.getTopContainer();
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        WSRPHttpServletRequest checkwsrpHttpServletRequest = (WSRPHttpServletRequest)this.container.getComponentInstanceOfType(WSRPHttpServletRequest.class);
        if (checkwsrpHttpServletRequest == null) {
            this.container.registerComponentInstance((Object)this.wsrpHttpServletRequest);
            System.out.println("StandaloneContainer: injecting " + WSRPHttpServletRequest.class);
            this.container.registerComponentInstance((Object)this.wsrpHttpSession);
            System.out.println("StandaloneContainer: injecting " + WSRPHttpSession.class);
        }
    }

    private void hibernateCloseSession() {
        List list = this.container.getComponentInstancesOfType(HibernateService.class);
        for (HibernateService hservice : list) {
            hservice.closeSession();
        }
    }

    public void destroy() {
    }
}

