/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl.helpers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPHttpSession
implements HttpSession {
    private String sessionID;
    private Map<String, Object> attributsMap = new HashMap<String, Object>();
    private long creationTime = System.currentTimeMillis();
    private long lastAccessTime;
    private int maxInactiveInterval = 900;
    private boolean isNew = false;
    private boolean invalidated = false;

    public WSRPHttpSession(String sessionID, int maxInactiveInterval) {
        this.sessionID = sessionID;
        this.maxInactiveInterval = maxInactiveInterval;
        this.isNew = true;
    }

    public long getCreationTime() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.creationTime;
    }

    public String getId() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.sessionID;
    }

    public long getLastAccessedTime() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public ServletContext getServletContext() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return null;
    }

    public void setMaxInactiveInterval(int arg0) {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        this.maxInactiveInterval = arg0;
    }

    public int getMaxInactiveInterval() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.maxInactiveInterval;
    }

    public Object getAttribute(String arg0) {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.attributsMap.get(arg0);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return Collections.enumeration(this.attributsMap.keySet());
    }

    public void setAttribute(String arg0, Object arg1) {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        this.attributsMap.put(arg0, arg1);
    }

    public void removeAttribute(String arg0) {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        this.attributsMap.remove(arg0);
    }

    public void invalidate() {
        Set<String> keys = this.attributsMap.keySet();
        for (String key : keys) {
            this.attributsMap.remove(key);
        }
        this.invalidated = true;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public boolean isNew() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return false;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void removeValue(String arg0) {
    }

    public void putValue(String arg0, Object arg1) {
    }

    public String[] getValueNames() {
        return null;
    }

    public Object getValue(String arg0) {
        return null;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }
}

