/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.utils;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import javax.portlet.WindowState;

public class WindowStates
implements Serializable {
    private String _value_;
    private static HashMap<String, WindowStates> _table_ = new HashMap();
    private static final String normalString = WindowState.NORMAL.toString();
    private static final String minimizedString = WindowState.MINIMIZED.toString();
    private static final String maximizedString = WindowState.MAXIMIZED.toString();
    private static final String soloString = "solo";
    public static final String _normal = "wsrp:" + normalString;
    public static final String _minimized = "wsrp:" + minimizedString;
    public static final String _maximized = "wsrp:" + maximizedString;
    public static final String _solo = "wsrp:solo";
    public static final WindowStates normal = new WindowStates(_normal);
    public static final WindowStates minimized = new WindowStates(_minimized);
    public static final WindowStates maximized = new WindowStates(_maximized);
    public static final WindowStates solo = new WindowStates("wsrp:solo");

    public WindowStates(String value) {
        this._value_ = value;
        _table_.put(this._value_, this);
    }

    public String getValue() {
        return this._value_;
    }

    public static WindowStates fromValue(String value) {
        return _table_.get(value);
    }

    public static WindowStates fromString(String value) {
        return WindowStates.fromValue(value);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._value_;
    }

    public Object readResolve() throws ObjectStreamException {
        return WindowStates.fromValue(this._value_);
    }

    public static WindowState getJsrPortletStateFromWsrpState(WindowStates wsrpState) {
        if (wsrpState == null) {
            throw new IllegalArgumentException("WSRP window state must not be null.");
        }
        return WindowStates.getJsrPortletStateFromWsrpState(wsrpState.toString());
    }

    public static WindowState getJsrPortletStateFromWsrpState(String wsrpState) {
        if (wsrpState == null) {
            return null;
        }
        String windowState = WindowStates.delAllPrefixWSRP(wsrpState).toLowerCase();
        if (windowState.equalsIgnoreCase(normalString)) {
            return WindowState.NORMAL;
        }
        if (windowState.equalsIgnoreCase(maximizedString)) {
            return WindowState.MAXIMIZED;
        }
        if (windowState.equalsIgnoreCase(minimizedString)) {
            return WindowState.MINIMIZED;
        }
        if (windowState.equalsIgnoreCase(soloString)) {
            return new WindowState(soloString);
        }
        System.out.println("WindowStates.getJsrPortletStateFromWsrpState " + wsrpState + " changed with '" + normalString + "' state");
        return WindowState.NORMAL;
    }

    public static WindowStates getWsrpStateFromJsrPortletState(WindowState windowState) {
        if (windowState == null) {
            throw new IllegalArgumentException("Window state must not be null.");
        }
        return WindowStates.getWsrpStateFromJsrPortletState(windowState.toString());
    }

    public static WindowStates getWsrpStateFromJsrPortletState(String windowState) {
        if (windowState == null) {
            return null;
        }
        String wsrpState = WindowStates.addPrefixWSRP(windowState).toLowerCase();
        if (wsrpState.equalsIgnoreCase(_normal)) {
            return normal;
        }
        if (wsrpState.equalsIgnoreCase(_maximized)) {
            return maximized;
        }
        if (wsrpState.equalsIgnoreCase(_minimized)) {
            return minimized;
        }
        if (wsrpState.equalsIgnoreCase(_solo)) {
            return solo;
        }
        System.out.println("WindowStates.getWsrpStateFromJsrPortletState " + windowState + " changed with '" + _normal + "' state");
        return normal;
    }

    public static String[] getWindowStatesAsStringArray() {
        return (String[])_table_.keySet().toArray();
    }

    public static String addPrefixWSRP(String forAddWSRPPrefix) {
        return "wsrp:" + forAddWSRPPrefix;
    }

    public static String delAllPrefixWSRP(String forDelWSRPPrefix) {
        if (forDelWSRPPrefix == null) {
            return null;
        }
        while (forDelWSRPPrefix.startsWith("wsrp:")) {
            forDelWSRPPrefix = forDelWSRPPrefix.substring("wsrp:".length());
        }
        return forDelWSRPPrefix;
    }
}

