/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */

package org.exoplatform.services.wsrp2.producer;

import java.util.List;

import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.intf.InvalidRegistration;
import org.exoplatform.services.wsrp2.intf.ModifyRegistrationRequired;
import org.exoplatform.services.wsrp2.intf.OperationFailed;
import org.exoplatform.services.wsrp2.intf.ResourceSuspended;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.ServiceDescription;
import org.exoplatform.services.wsrp2.type.UserContext;

/**
 * The Interface ServiceDescriptionInterface.
 * 
 * @author Mestrallet Benjamin benjmestrallet@users.sourceforge.net
 */
public interface ServiceDescriptionInterface {
  
  /**
   * Gets the service description.
   * 
   * @param registrationContext the registration context
   * @param desiredLocales the desired locales
   * @param portletHandles the portlet handles
   * @param userContext the user context
   * 
   * @return the service description
   * 
   * @throws ResourceSuspended the resource suspended
   * @throws InvalidRegistration the invalid registration
   * @throws ModifyRegistrationRequired the modify registration required
   * @throws OperationFailed the operation failed
   * @throws WSRPException the WSRP exception
   */
  public ServiceDescription getServiceDescription(RegistrationContext registrationContext,
                                                  List<String> desiredLocales,
                                                  List<String> portletHandles,
                                                  UserContext userContext) throws ResourceSuspended,
                                                                          InvalidRegistration,
                                                                          ModifyRegistrationRequired,
                                                                          OperationFailed,
                                                                          WSRPException;

}
