/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.PersistentStateManager;
import org.exoplatform.services.wsrp2.producer.RegistrationOperationsInterface;
import org.exoplatform.services.wsrp2.type.Lifetime;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.RegistrationData;
import org.exoplatform.services.wsrp2.type.RegistrationState;
import org.exoplatform.services.wsrp2.type.ReturnAny;
import org.exoplatform.services.wsrp2.type.UserContext;

public class RegistrationOperationsInterfaceImp
implements RegistrationOperationsInterface {
    private Log log;
    private PersistentStateManager stateManager;

    public RegistrationOperationsInterfaceImp(PersistentStateManager stateManager) {
        this.stateManager = stateManager;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
    }

    public RegistrationContext register(RegistrationData data) throws RemoteException {
        data.setConsumerAgent("exoplatform.1.0");
        this.log.debug((Object)"Register method entered");
        String registrationHandle = null;
        byte[] registrationState = null;
        try {
            this.validateRegistrationDatas(data);
            registrationHandle = IdentifierUtil.generateUUID((Object)data);
            registrationState = this.stateManager.register(registrationHandle, data);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        RegistrationContext rC = new RegistrationContext();
        rC.setRegistrationHandle(registrationHandle);
        rC.setRegistrationState(registrationState);
        this.log.debug((Object)("Registration done with handle : " + registrationHandle));
        return rC;
    }

    public RegistrationContext register(RegistrationData data, Lifetime lifetime, UserContext userContext) throws RemoteException {
        data.setConsumerAgent("exoplatform.1.0");
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Register method entered for user:" + owner));
        String registrationHandle = null;
        byte[] registrationState = null;
        try {
            this.validateRegistrationDatas(data);
            registrationHandle = IdentifierUtil.generateUUID((Object)data);
            registrationState = this.stateManager.register(registrationHandle, data);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        RegistrationContext rC = new RegistrationContext();
        rC.setRegistrationHandle(registrationHandle);
        rC.setRegistrationState(registrationState);
        rC.setScheduledDestruction(lifetime);
        this.log.debug((Object)("Registration done with handle : " + registrationHandle + " for owner : " + owner));
        return rC;
    }

    public RegistrationState modifyRegistration(RegistrationContext registrationContext, RegistrationData data) throws RemoteException {
        this.log.debug((Object)"Modify registrion method entered");
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String registrationHandle = registrationContext.getRegistrationHandle();
        try {
            this.validateRegistrationDatas(data);
            this.stateManager.register(registrationHandle, data);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        return new RegistrationState();
    }

    public RegistrationState modifyRegistration(RegistrationContext registrationContext, RegistrationData data, UserContext userContext) throws RemoteException {
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Modify registrion method entered for owner " + owner));
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String registrationHandle = registrationContext.getRegistrationHandle();
        try {
            this.validateRegistrationDatas(data);
            this.stateManager.register(registrationHandle, data);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        return new RegistrationState();
    }

    public ReturnAny deregister(RegistrationContext registrationContext) throws RemoteException {
        this.log.debug((Object)"Deregister method entered");
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        try {
            this.stateManager.deregister(registrationContext);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        return new ReturnAny();
    }

    public ReturnAny deregister(RegistrationContext registrationContext, UserContext userContext) throws RemoteException {
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Deregister method entered for owner:" + owner));
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        try {
            this.stateManager.deregister(registrationContext);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        return new ReturnAny();
    }

    public Lifetime getRegistrationLifetime(RegistrationContext registrationContext, UserContext userContext) throws RemoteException {
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("getRegistrationLifetime method entered for owner:" + owner));
        Lifetime lifetime = registrationContext.getScheduledDestruction();
        return lifetime;
    }

    public Lifetime setRegistrationLifetime(RegistrationContext registrationContext, UserContext userContext, Lifetime lifetime) throws RemoteException {
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("setRegistrationLifetime method entered for owner:" + owner));
        registrationContext.setScheduledDestruction(lifetime);
        return lifetime;
    }

    private void validateRegistrationDatas(RegistrationData data) throws WSRPException {
        String consumerAgent = data.getConsumerAgent();
        String[] members = StringUtils.split((String)consumerAgent, (String)".");
        if (!StringUtils.isNumeric((String)members[1])) {
            throw new WSRPException("MissingParameters");
        }
        if (!StringUtils.isNumeric((String)members[2])) {
            throw new WSRPException("MissingParameters");
        }
    }
}

