/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPConfiguration {
    private boolean hasUserSpecificState;
    private boolean doesUrlTemplateProcessing;
    private boolean templatesStoredInSession;
    private boolean userContextStoredInSession;
    private boolean usesMethodGet;
    private boolean requiresRegistration;
    private boolean blockingInteractionOptimized;
    private boolean saveRegistrationStateOnConsumer;
    private boolean savePortletStateOnConsumer;
    private List<String> excludeList = null;
    private HashMap<String, String> adminPortletParams = null;

    public WSRPConfiguration(InitParams params) {
        PropertiesParam param = params.getPropertiesParam("wsrp-conf");
        this.init(param.getProperties());
        PropertiesParam paramAdminPortlet = params.getPropertiesParam("wsrp-admin-portlet-conf");
        this.initParamsAdminPortlet(paramAdminPortlet.getProperties());
        this.excludeList = params.getValuesParam("exclude-list") != null ? params.getValuesParam("exclude-list").getValues() : new ArrayList<String>();
        this.excludeList.add("@WSRP2App/WSRPAdminPortlet".substring(0, 5) + "*");
    }

    private void init(ExoProperties props) {
        this.hasUserSpecificState = props.getProperty("wsrp.has.user.specific.state").equals("true");
        this.doesUrlTemplateProcessing = props.getProperty("wsrp.does.url.template.processing").equals("true");
        this.templatesStoredInSession = props.getProperty("wsrp.templates.stored.in.session").equals("true");
        this.userContextStoredInSession = props.getProperty("wsrp.user.context.stored.in.session").equals("true");
        this.usesMethodGet = props.getProperty("wsrp.uses.method.get").equals("true");
        this.requiresRegistration = props.getProperty("wsrp.requires.registration").equals("true");
        this.blockingInteractionOptimized = props.getProperty("wsrp.perform.blocking.interaction.optimized").equals("true");
        this.saveRegistrationStateOnConsumer = props.getProperty("wsrp.save.registration.state.on.consumer").equals("true");
        this.savePortletStateOnConsumer = props.getProperty("wsrp.save.portlet.state.on.consumer").equals("true");
    }

    private void initParamsAdminPortlet(ExoProperties props) {
        if (this.adminPortletParams == null) {
            this.adminPortletParams = new HashMap();
        }
        this.adminPortletParams.put("portletTitle", props.getProperty("portletTitle"));
        this.adminPortletParams.put("consumerName", props.getProperty("consumerName"));
        this.adminPortletParams.put("consumerAgent", props.getProperty("consumerAgent"));
        this.adminPortletParams.put("producerName", props.getProperty("producerName"));
        this.adminPortletParams.put("producerURL", props.getProperty("producerURL"));
        this.adminPortletParams.put("markupIntfEndpoint", props.getProperty("markupIntfEndpoint"));
        this.adminPortletParams.put("portletManagementIntfEndpoint", props.getProperty("portletManagementIntfEndpoint"));
        this.adminPortletParams.put("registrationIntfEndpoint", props.getProperty("registrationIntfEndpoint"));
        this.adminPortletParams.put("serviceDescriptionIntfEndpoint", props.getProperty("serviceDescriptionIntfEndpoint"));
        this.adminPortletParams.put("description", props.getProperty("description"));
    }

    public boolean isHasUserSpecificState() {
        return this.hasUserSpecificState;
    }

    public boolean isDoesUrlTemplateProcessing() {
        return this.doesUrlTemplateProcessing;
    }

    public boolean isTemplatesStoredInSession() {
        return this.templatesStoredInSession;
    }

    public boolean isUserContextStoredInSession() {
        return this.userContextStoredInSession;
    }

    public boolean isUsesMethodGet() {
        return this.usesMethodGet;
    }

    public boolean isRegistrationRequired() {
        return this.requiresRegistration;
    }

    public boolean isBlockingInteractionOptimized() {
        return this.blockingInteractionOptimized;
    }

    public boolean isSaveRegistrationStateOnConsumer() {
        return this.saveRegistrationStateOnConsumer;
    }

    public boolean isSavePortletStateOnConsumer() {
        return this.savePortletStateOnConsumer;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public HashMap<String, String> getAdminPortletParams() {
        return this.adminPortletParams;
    }
}

