/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.utils;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import javax.portlet.PortletMode;

public class Modes
implements Serializable {
    private String _value_;
    private static HashMap<String, Modes> _table_ = new HashMap();
    private static final String viewString = PortletMode.VIEW.toString();
    private static final String editString = PortletMode.EDIT.toString();
    private static final String helpString = PortletMode.HELP.toString();
    private static final String previewString = "preview";
    public static final String _view = "wsrp:" + viewString;
    public static final String _edit = "wsrp:" + editString;
    public static final String _help = "wsrp:" + helpString;
    public static final String _preview = "wsrp:preview";
    public static final Modes view = new Modes(_view);
    public static final Modes edit = new Modes(_edit);
    public static final Modes help = new Modes(_help);
    public static final Modes preview = new Modes("wsrp:preview");

    public Modes(String value) {
        this._value_ = value;
        _table_.put(this._value_, this);
    }

    public String getValue() {
        return this._value_;
    }

    public static Modes fromValue(String value) {
        return _table_.get(value);
    }

    public static Modes fromString(String value) {
        return Modes.fromValue(value);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._value_;
    }

    public Object readResolve() throws ObjectStreamException {
        return Modes.fromValue(this._value_);
    }

    public static PortletMode getJsrPortletModeFromWsrpMode(Modes wsrpMode) {
        if (wsrpMode == null) {
            throw new IllegalArgumentException("WSRP portlet mode must not be null.");
        }
        return Modes.getJsrPortletModeFromWsrpMode(wsrpMode.toString());
    }

    public static PortletMode getJsrPortletModeFromWsrpMode(String wsrpMode) {
        if (wsrpMode == null) {
            return null;
        }
        String portletMode = Modes.delAllPrefixWSRP(wsrpMode).toLowerCase();
        if (portletMode.equalsIgnoreCase(viewString)) {
            return PortletMode.VIEW;
        }
        if (portletMode.equalsIgnoreCase(editString)) {
            return PortletMode.EDIT;
        }
        if (portletMode.equalsIgnoreCase(helpString)) {
            return PortletMode.HELP;
        }
        if (portletMode.equalsIgnoreCase(previewString)) {
            return new PortletMode(previewString);
        }
        System.out.println("Modes.getJsrPortletModeFromWsrpMode " + wsrpMode + " changed with '" + viewString + "' mode");
        return PortletMode.VIEW;
    }

    public static Modes getWsrpModeFromJsrPortletMode(PortletMode portletMode) {
        if (portletMode == null) {
            throw new IllegalArgumentException("Portlet mode must not be null.");
        }
        return Modes.getWsrpModeFromJsrPortletMode(portletMode.toString());
    }

    public static Modes getWsrpModeFromJsrPortletMode(String portletMode) {
        if (portletMode == null) {
            return null;
        }
        String wsrpMode = Modes.addPrefixWSRP(portletMode).toLowerCase();
        if (wsrpMode.equalsIgnoreCase(_view)) {
            return view;
        }
        if (wsrpMode.equalsIgnoreCase(_edit)) {
            return edit;
        }
        if (wsrpMode.equalsIgnoreCase(_help)) {
            return help;
        }
        if (wsrpMode.equalsIgnoreCase(_preview)) {
            return preview;
        }
        System.out.println("Modes.getWsrpModeFromJsrPortletMode " + portletMode + " changed with '" + _view + "' mode");
        return view;
    }

    public static String addPrefixWSRP(String forAddWSRPPrefix) {
        return "wsrp:" + forAddWSRPPrefix;
    }

    public static String delAllPrefixWSRP(String forDelWSRPPrefix) {
        if (forDelWSRPPrefix == null) {
            return null;
        }
        while (forDelWSRPPrefix.startsWith("wsrp:")) {
            forDelWSRPPrefix = forDelWSRPPrefix.substring("wsrp:".length());
        }
        return forDelWSRPPrefix;
    }
}

