/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.processes.notification.utils.NotificationArguments;
import org.exoplatform.processes.notification.utils.NotificationUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.TaskDto;

public class CancelRequestNotificationListener
extends Listener<TaskDto, ProjectDto> {
    public void onEvent(Event<TaskDto, ProjectDto> event) {
        TaskDto taskDto = (TaskDto)event.getSource();
        ProjectDto projectDto = (ProjectDto)event.getData();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationArguments.REQUEST_CREATOR, (Object)taskDto.getCreatedBy());
        ctx.append(NotificationArguments.PROCESS_URL, (Object)NotificationUtils.getProcessLink(projectDto.getId()));
        ctx.append(NotificationArguments.REQUEST_URL, (Object)NotificationUtils.getRequestLink(taskDto.getId()));
        ctx.append(NotificationArguments.WORKFLOW_PROJECT_ID, (Object)String.valueOf(projectDto.getId()));
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CancelRequestPlugin"))).execute(ctx);
    }
}

