/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="WorkFlow")
@ExoEntity
@Table(name="PROCESSES_WORK_FLOW")
@NamedQueries(value={@NamedQuery(name="WorkFlow.getWorkFlowByProjectId", query="SELECT DISTINCT c FROM WorkFlow c where c.projectId = :projectId"), @NamedQuery(name="WorkFlow.findAllWorkFlowsByUser", query="SELECT DISTINCT c FROM WorkFlow c where c.creatorId = :userId order by c.id desc"), @NamedQuery(name="WorkFlow.findEnabledWorkFlowsByUser", query="SELECT DISTINCT c FROM WorkFlow c where c.creatorId = :userId and  c.enabled = true order by c.id desc"), @NamedQuery(name="WorkFlow.findAllWorkFlows", query="SELECT DISTINCT c FROM WorkFlow c order by c.id desc"), @NamedQuery(name="WorkFlow.findEnabledWorkFlows", query="SELECT DISTINCT c FROM WorkFlow c where c.enabled = true order by c.id desc"), @NamedQuery(name="WorkFlow.findDisabledWorkFlows", query="SELECT DISTINCT c FROM WorkFlow c where c.enabled = false order by c.id desc")})
public class WorkFlowEntity
implements Serializable {
    @Id
    @SequenceGenerator(name="SEQ_WORK_FLOW_ID", sequenceName="SEQ_WORK_FLOW_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WORK_FLOW_ID")
    @Column(name="WORK_FLOW_ID", nullable=false)
    private Long id;
    @Column(name="TITLE", nullable=false)
    private String title;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="SUMMARY")
    private String summary;
    @Column(name="ENABLED")
    private boolean enabled;
    @Column(name="HELP_LINK")
    private String helpLink;
    @Column(name="IMAGE")
    private String image;
    @Column(name="CREATOR_ID")
    private Long creatorId;
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate;
    @Column(name="MODIFIER_ID")
    private Long modifierId;
    @Column(name="MODIFIED_DATE", nullable=false)
    private Date modifiedDate;
    @Column(name="PROJECT_ID")
    private Long projectId;
    @Column(name="ILLUSTRATION_IMAGE_ID")
    private Long illustrationImageId;
    @ElementCollection
    @CollectionTable(name="WORK_FLOW_MANAGERS", joinColumns={@JoinColumn(name="WORK_FLOW_ID")})
    private Set<String> manager = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="WORK_FLOW_PARTICIPATOR", joinColumns={@JoinColumn(name="WORK_FLOW_ID")})
    private Set<String> participator = new HashSet<String>();

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public String getImage() {
        return this.image;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Long getModifierId() {
        return this.modifierId;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getIllustrationImageId() {
        return this.illustrationImageId;
    }

    public Set<String> getManager() {
        return this.manager;
    }

    public Set<String> getParticipator() {
        return this.participator;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setModifierId(Long modifierId) {
        this.modifierId = modifierId;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public void setIllustrationImageId(Long illustrationImageId) {
        this.illustrationImageId = illustrationImageId;
    }

    public void setManager(Set<String> manager) {
        this.manager = manager;
    }

    public void setParticipator(Set<String> participator) {
        this.participator = participator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkFlowEntity)) {
            return false;
        }
        WorkFlowEntity other = (WorkFlowEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$creatorId = this.getCreatorId();
        Long other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        Long this$modifierId = this.getModifierId();
        Long other$modifierId = other.getModifierId();
        if (this$modifierId == null ? other$modifierId != null : !((Object)this$modifierId).equals(other$modifierId)) {
            return false;
        }
        Long this$projectId = this.getProjectId();
        Long other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        Long this$illustrationImageId = this.getIllustrationImageId();
        Long other$illustrationImageId = other.getIllustrationImageId();
        if (this$illustrationImageId == null ? other$illustrationImageId != null : !((Object)this$illustrationImageId).equals(other$illustrationImageId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$helpLink = this.getHelpLink();
        String other$helpLink = other.getHelpLink();
        if (this$helpLink == null ? other$helpLink != null : !this$helpLink.equals(other$helpLink)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Date this$createdDate = this.getCreatedDate();
        Date other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Date this$modifiedDate = this.getModifiedDate();
        Date other$modifiedDate = other.getModifiedDate();
        if (this$modifiedDate == null ? other$modifiedDate != null : !((Object)this$modifiedDate).equals(other$modifiedDate)) {
            return false;
        }
        Set<String> this$manager = this.getManager();
        Set<String> other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
            return false;
        }
        Set<String> this$participator = this.getParticipator();
        Set<String> other$participator = other.getParticipator();
        return !(this$participator == null ? other$participator != null : !((Object)this$participator).equals(other$participator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkFlowEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        Long $modifierId = this.getModifierId();
        result = result * 59 + ($modifierId == null ? 43 : ((Object)$modifierId).hashCode());
        Long $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        Long $illustrationImageId = this.getIllustrationImageId();
        result = result * 59 + ($illustrationImageId == null ? 43 : ((Object)$illustrationImageId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $helpLink = this.getHelpLink();
        result = result * 59 + ($helpLink == null ? 43 : $helpLink.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Date $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Date $modifiedDate = this.getModifiedDate();
        result = result * 59 + ($modifiedDate == null ? 43 : ((Object)$modifiedDate).hashCode());
        Set<String> $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
        Set<String> $participator = this.getParticipator();
        result = result * 59 + ($participator == null ? 43 : ((Object)$participator).hashCode());
        return result;
    }

    public String toString() {
        return "WorkFlowEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", summary=" + this.getSummary() + ", enabled=" + this.isEnabled() + ", helpLink=" + this.getHelpLink() + ", image=" + this.getImage() + ", creatorId=" + this.getCreatorId() + ", createdDate=" + this.getCreatedDate() + ", modifierId=" + this.getModifierId() + ", modifiedDate=" + this.getModifiedDate() + ", projectId=" + this.getProjectId() + ", illustrationImageId=" + this.getIllustrationImageId() + ", manager=" + this.getManager() + ", participator=" + this.getParticipator() + ")";
    }
}

