/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.util.Base64;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.processes.Utils.EntityMapper;
import org.exoplatform.processes.Utils.ProcessesUtils;
import org.exoplatform.processes.dao.WorkDraftDAO;
import org.exoplatform.processes.dao.WorkFlowDAO;
import org.exoplatform.processes.entity.WorkEntity;
import org.exoplatform.processes.entity.WorkFlowEntity;
import org.exoplatform.processes.model.IllustrativeAttachment;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFilter;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.model.WorkStatus;
import org.exoplatform.processes.service.ProcessesAttachmentService;
import org.exoplatform.processes.storage.ProcessesStorage;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.UserUtil;

public class ProcessesStorageImpl
implements ProcessesStorage {
    private static final Log LOG = ExoLogger.getLogger(ProcessesStorageImpl.class);
    private final WorkFlowDAO workFlowDAO;
    private final WorkDraftDAO workDraftDAO;
    private final IdentityManager identityManager;
    private final TaskService taskService;
    private final ProjectService projectService;
    private final StatusService statusService;
    private final SpaceService spaceService;
    private final ListenerService listenerService;
    private final ProcessesAttachmentService processesAttachmentService;
    private final FileService fileService;
    private final String DATE_FORMAT = "yyyy/MM/dd";
    private static final String PROCESSES_SPACE_GROUP_ID = "/spaces/processes_space";
    private static final String WORK_DRAFT_ENTITY_TYPE = "workdraft";
    private static final String TASK_ENTITY_TYPE = "task";
    private static final String WORKFLOW_ENTITY_TYPE = "workflow";
    private static final String[] DEFAULT_PROCESS_STATUS = new String[]{"Request", "RequestInProgress", "Validated", "Refused", "Canceled"};
    private static final String PROCESS_FILES_NAME_SPACE = "processesApp";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");

    public ProcessesStorageImpl(WorkFlowDAO workFlowDAO, WorkDraftDAO workDraftDAO, TaskService taskService, ProjectService projectService, StatusService statusService, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService, ProcessesAttachmentService processesAttachmentService, FileService fileService) {
        this.workFlowDAO = workFlowDAO;
        this.workDraftDAO = workDraftDAO;
        this.identityManager = identityManager;
        this.taskService = taskService;
        this.projectService = projectService;
        this.statusService = statusService;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
        this.processesAttachmentService = processesAttachmentService;
        this.fileService = fileService;
    }

    public List<WorkFlow> findAllWorkFlowsByUser(ProcessesFilter filter, int offset, int limit, long userIdentityId) {
        return EntityMapper.fromWorkflowEntities(this.workFlowDAO.findAllWorkFlowsByUser(userIdentityId, offset, limit));
    }

    public List<WorkFlow> findEnabledWorkFlowsByUser(ProcessesFilter filter, int offset, int limit, long userIdentityId) {
        return EntityMapper.fromWorkflowEntities(this.workFlowDAO.findEnabledWorkFlowsByUser(userIdentityId, offset, limit));
    }

    public List<WorkFlow> findAllWorkFlows(int offset, int limit) {
        return EntityMapper.fromWorkflowEntities(this.workFlowDAO.findAllWorkFlows(offset, limit));
    }

    public List<WorkFlow> findEnabledWorkFlows(int offset, int limit) {
        return EntityMapper.fromWorkflowEntities(this.workFlowDAO.findEnabledWorkFlows(offset, limit));
    }

    public List<WorkFlow> findDisabledWorkFlows(int offset, int limit) {
        return EntityMapper.fromWorkflowEntities(this.workFlowDAO.findDisabledWorkFlows(offset, limit));
    }

    public WorkFlow getWorkFlowById(long id) {
        return EntityMapper.fromEntity((WorkFlowEntity)this.workFlowDAO.find(Long.valueOf(id)));
    }

    public WorkFlow getWorkFlowByProjectId(long projectId) {
        return EntityMapper.fromEntity(this.workFlowDAO.getWorkFlowByProjectId(projectId));
    }

    public WorkFlow saveWorkFlow(WorkFlow workFlow, long userId) throws IllegalArgumentException {
        if (workFlow == null) {
            throw new IllegalArgumentException("workflow argument is null");
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(userId));
        if (identity == null) {
            throw new IllegalArgumentException("identity is not exist");
        }
        WorkFlowEntity workFlowEntity = EntityMapper.toEntity(workFlow);
        IllustrativeAttachment illustrativeAttachment = this.createIllustrativeImage(workFlow.getIllustrativeAttachment());
        if (illustrativeAttachment != null && !illustrativeAttachment.isToDelete()) {
            workFlowEntity.setIllustrationImageId(illustrativeAttachment.getId());
        } else if (illustrativeAttachment != null && illustrativeAttachment.isToDelete()) {
            workFlowEntity.setIllustrationImageId(null);
        }
        if (workFlow.getId() == 0L) {
            workFlowEntity.setId(null);
            workFlowEntity.setCreatedDate(new Date());
            workFlowEntity.setCreatorId(userId);
            if (workFlow.getProjectId() == 0L) {
                long projectId = this.createProject(workFlow);
                workFlowEntity.setProjectId(projectId);
            }
            workFlowEntity = (WorkFlowEntity)this.workFlowDAO.create(workFlowEntity);
            WorkFlow newWorkflow = EntityMapper.fromEntity(workFlowEntity, illustrativeAttachment);
            ProcessesUtils.broadcast(this.listenerService, "exo.process.created", userId, newWorkflow);
        } else {
            workFlowEntity.setModifiedDate(new Date());
            workFlowEntity.setModifierId(userId);
            workFlowEntity = (WorkFlowEntity)this.workFlowDAO.update(workFlowEntity);
        }
        this.processesAttachmentService.linkAttachmentsToEntity(workFlow.getAttachments(), Long.valueOf(userId), workFlowEntity.getId(), WORKFLOW_ENTITY_TYPE, workFlowEntity.getProjectId());
        return EntityMapper.fromEntity(workFlowEntity, illustrativeAttachment);
    }

    public IllustrativeAttachment getIllustrationImageById(Long illustrationId) throws FileStorageException, ObjectNotFoundException, IOException {
        if (illustrationId == null) {
            return null;
        }
        FileItem file = this.fileService.getFile(illustrationId.longValue());
        if (file == null) {
            throw new ObjectNotFoundException("Illustration image not found");
        }
        FileInfo fileInfo = file.getFileInfo();
        return new IllustrativeAttachment(fileInfo.getId(), fileInfo.getName(), file.getAsStream(), fileInfo.getMimetype(), Long.valueOf(fileInfo.getSize()), Long.valueOf(fileInfo.getUpdatedDate().getTime()));
    }

    private IllustrativeAttachment createIllustrativeImage(IllustrativeAttachment illustrativeAttachment) {
        if (illustrativeAttachment == null) {
            return null;
        }
        if (illustrativeAttachment.getFileName() == null) {
            illustrativeAttachment.setToDelete(true);
            return illustrativeAttachment;
        }
        if (illustrativeAttachment.getFileBody() == null) {
            return illustrativeAttachment;
        }
        try {
            String data = illustrativeAttachment.getFileBody().split("base64,")[1];
            byte[] bytes = Base64.decode((byte[])data.getBytes(Charset.defaultCharset().name()));
            FileItem fileItem = new FileItem(illustrativeAttachment.getId(), illustrativeAttachment.getFileName(), illustrativeAttachment.getMimeType(), PROCESS_FILES_NAME_SPACE, illustrativeAttachment.getFileSize(), new Date(), null, false, (InputStream)new ByteArrayInputStream(bytes));
            fileItem = illustrativeAttachment.getId() == null ? this.fileService.writeFile(fileItem) : this.fileService.updateFile(fileItem);
            if (fileItem != null && fileItem.getFileInfo() != null) {
                FileInfo fileInfo = fileItem.getFileInfo();
                return new IllustrativeAttachment(fileInfo.getId(), fileInfo.getName(), fileInfo.getMimetype(), Long.valueOf(fileInfo.getSize()), Long.valueOf(fileInfo.getUpdatedDate().getTime()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving illustrative attachment", (Throwable)e);
        }
        return null;
    }

    public List<Work> getWorks(long userIdentityId, WorkFilter workFilter, int offset, int limit) throws Exception {
        List<WorkFlow> workFlows = this.findAllWorkFlows(0, 0);
        List projectsIds = workFlows.stream().map(WorkFlow::getProjectId).collect(Collectors.toList());
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setProjectIds(projectsIds);
        if (workFilter.getStatus() != null) {
            taskQuery.setStatusName(workFilter.getStatus());
        }
        if (workFilter.getQuery() != null) {
            taskQuery.setKeyword(workFilter.getQuery());
        }
        if (workFilter.getCompleted() != null) {
            taskQuery.setCompleted(workFilter.getCompleted());
        }
        ArrayList<OrderBy> orderByList = new ArrayList<OrderBy>();
        orderByList.add(new OrderBy("id", false));
        taskQuery.setOrderBy(orderByList);
        taskQuery.setCreatedBy(ProcessesUtils.getUserNameByIdentityId(this.identityManager, userIdentityId));
        List tasks = this.taskService.findTasks(taskQuery, offset, limit);
        return EntityMapper.tasksToWorkList(tasks);
    }

    public Work getWorkById(long userIdentityId, long workId) {
        Identity identity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (identity == null) {
            throw new IllegalArgumentException("identity is not exist");
        }
        TaskDto taskDto = null;
        TaskQuery taskQuery = new TaskQuery();
        try {
            taskQuery.setId(workId);
            taskQuery.setCreatedBy(identity.getRemoteId());
            List list = this.taskService.findTasks(taskQuery, 0, 0);
            if (!list.isEmpty()) {
                taskDto = (TaskDto)list.get(0);
            }
        }
        catch (org.exoplatform.task.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException("work not found");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting work");
        }
        return EntityMapper.taskToWork(taskDto);
    }

    public int countWorksByWorkflow(long projectId, boolean isCompleted) throws Exception {
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setProjectIds(Arrays.asList(projectId));
        taskQuery.setCompleted(Boolean.valueOf(isCompleted));
        int tasksCount = this.taskService.countTasks(taskQuery);
        return tasksCount;
    }

    public Work getWorkById(long id) {
        try {
            return EntityMapper.taskToWork(this.taskService.getTask(id));
        }
        catch (org.exoplatform.task.exception.EntityNotFoundException e) {
            return null;
        }
    }

    private TaskDto createWorkTask(Work work, Identity identity) {
        try {
            this.projectService.getProject(Long.valueOf(work.getProjectId()));
        }
        catch (org.exoplatform.task.exception.EntityNotFoundException e) {
            throw new IllegalArgumentException("Task's project not found");
        }
        TaskDto taskDto = EntityMapper.workToTask(work);
        if (StringUtils.isEmpty((String)taskDto.getTitle())) {
            taskDto.setTitle(this.formatter.format(new Date()) + " - " + identity.getProfile().getFullName());
        }
        taskDto.setStatus(this.statusService.getDefaultStatus(work.getProjectId()));
        taskDto.setCreatedBy(identity.getRemoteId());
        taskDto.setCreatedTime(new Date());
        taskDto.setPriority(Priority.NONE);
        taskDto = this.taskService.createTask(taskDto);
        return taskDto;
    }

    private TaskDto updateWorkTask(Work work) {
        TaskDto taskDto;
        try {
            taskDto = this.taskService.getTask(work.getId());
        }
        catch (org.exoplatform.task.exception.EntityNotFoundException e) {
            throw new IllegalArgumentException("Task not found");
        }
        taskDto.setDescription(work.getDescription());
        taskDto.setTitle(work.getTitle());
        taskDto.setCompleted(work.isCompleted());
        long projectId = work.getProjectId();
        List statuses = this.statusService.getStatuses(projectId);
        StatusDto status = statuses.stream().filter(statusDto -> work.getStatus().equals(statusDto.getName())).findAny().orElse(null);
        if (status != null) {
            taskDto.setStatus(status);
        }
        if ((taskDto = this.taskService.updateTask(taskDto)).isCompleted() && taskDto.getStatus().getName().equals(DEFAULT_PROCESS_STATUS[4])) {
            ProjectDto projectDto = taskDto.getStatus().getProject();
            ProcessesUtils.broadcast(this.listenerService, "exo.process.request.canceled", taskDto, projectDto);
        }
        return taskDto;
    }

    public Work saveWork(Work work, long userId) throws IllegalArgumentException {
        if (work == null) {
            throw new IllegalArgumentException("work argument is null");
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(userId));
        if (identity == null) {
            throw new IllegalArgumentException("identity is not exist");
        }
        if (work.getId() == 0L) {
            TaskDto taskDto = this.createWorkTask(work, identity);
            ProjectDto projectDto = taskDto.getStatus().getProject();
            if (work.getDraftId() != null) {
                this.processesAttachmentService.moveAttachmentsToEntity(Long.valueOf(userId), work.getDraftId(), WORK_DRAFT_ENTITY_TYPE, Long.valueOf(taskDto.getId()), TASK_ENTITY_TYPE, Long.valueOf(projectDto.getId()));
                this.deleteWorkDraftById(work.getDraftId());
            }
            Work newWork = EntityMapper.taskToWork(taskDto);
            newWork.setCreatorId(userId);
            ProcessesUtils.broadcast(this.listenerService, "exo.process.request.created", newWork, projectDto);
            return newWork;
        }
        TaskDto taskDto = this.updateWorkTask(work);
        return EntityMapper.taskToWork(taskDto);
    }

    private long createProject(WorkFlow workFlow) {
        Space processSpace = this.spaceService.getSpaceByGroupId(PROCESSES_SPACE_GROUP_ID);
        if (processSpace == null) {
            throw new IllegalArgumentException("Space of processes not exist");
        }
        List memberships = UserUtil.getSpaceMemberships((String)processSpace.getGroupId());
        HashSet<String> managers = new HashSet<String>(Arrays.asList((String)memberships.get(0)));
        HashSet<String> participators = new HashSet<String>(Arrays.asList((String)memberships.get(1)));
        ProjectDto project = ProjectUtil.newProjectInstanceDto((String)workFlow.getTitle(), (String)workFlow.getDescription(), managers, participators);
        project = this.projectService.createProject(project);
        for (String statusName : DEFAULT_PROCESS_STATUS) {
            this.statusService.createStatus(project, statusName);
        }
        return project.getId();
    }

    public void deleteWorkflowById(Long workflowId) throws EntityNotFoundException {
        WorkFlowEntity workFlowEntity = (WorkFlowEntity)this.workFlowDAO.find(workflowId);
        if (workFlowEntity == null) {
            throw new EntityNotFoundException("Workflow not found");
        }
        try {
            ProjectDto project = this.projectService.getProject(workFlowEntity.getProjectId());
            if (project != null) {
                this.projectService.removeProject(project.getId(), true);
            }
        }
        catch (org.exoplatform.task.exception.EntityNotFoundException e) {
            LOG.error((Object)"Error while getting workflow project", (Throwable)e);
        }
        List<WorkEntity> drafts = this.workDraftDAO.getDraftsByWorkflowId(workflowId);
        if (!drafts.isEmpty()) {
            this.workDraftDAO.deleteAll(drafts);
        }
        this.workFlowDAO.delete(workFlowEntity);
    }

    public void deleteWorkById(Long workId) {
        try {
            TaskDto taskDto = this.taskService.getTask(workId.longValue());
            if (taskDto != null) {
                this.taskService.removeTask(workId.longValue());
                ProjectDto projectDto = taskDto.getStatus().getProject();
                ProcessesUtils.broadcast(this.listenerService, "exo.process.request.removed", taskDto, projectDto);
            }
        }
        catch (org.exoplatform.task.exception.EntityNotFoundException e) {
            LOG.error((Object)"Work not found", (Throwable)e);
        }
    }

    public Work updateWorkCompleted(Long workId, boolean completed) {
        TaskDto taskDto;
        try {
            taskDto = this.taskService.getTask(workId.longValue());
            if (taskDto != null) {
                taskDto.setCompleted(completed);
                taskDto = this.taskService.updateTask(taskDto);
            }
        }
        catch (org.exoplatform.task.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException("work not found");
        }
        return EntityMapper.taskToWork(taskDto);
    }

    public List<Work> findAllWorkDraftsByUser(WorkFilter workFilter, int offset, int limit, long userIdentityId) {
        return EntityMapper.fromWorkEntities(this.workDraftDAO.findAllWorkDraftsByUser(workFilter, userIdentityId, offset, limit));
    }

    public Work saveWorkDraft(Work work, long userId) {
        Identity identity = this.identityManager.getIdentity(String.valueOf(userId));
        if (identity == null) {
            throw new IllegalArgumentException("identity is not exist");
        }
        WorkEntity workEntity = EntityMapper.toEntity(work);
        if (work.getId() == 0L) {
            workEntity.setId(null);
            workEntity.setCreatedDate(new Date());
            workEntity.setCreatorId(userId);
            workEntity = (WorkEntity)this.workDraftDAO.create(workEntity);
            this.processesAttachmentService.copyAttachmentsToEntity(Long.valueOf(userId), Long.valueOf(work.getWorkFlow().getId()), WORKFLOW_ENTITY_TYPE, workEntity.getId(), WORK_DRAFT_ENTITY_TYPE, Long.valueOf(work.getWorkFlow().getProjectId()));
        } else {
            workEntity.setModifiedDate(new Date());
            workEntity = (WorkEntity)this.workDraftDAO.update(workEntity);
        }
        return EntityMapper.fromEntity(workEntity);
    }

    public Work getWorkDraftyId(long id) {
        return EntityMapper.fromEntity((WorkEntity)this.workDraftDAO.find(Long.valueOf(id)));
    }

    public void deleteWorkDraftById(long id) throws EntityNotFoundException {
        WorkEntity workEntity = (WorkEntity)this.workDraftDAO.find(Long.valueOf(id));
        if (workEntity == null) {
            throw new EntityNotFoundException("Work Draft not found");
        }
        this.workDraftDAO.delete(workEntity);
    }

    public List<WorkStatus> getAvailableWorkStatuses() {
        ArrayList<WorkStatus> statuses = new ArrayList<WorkStatus>();
        List<WorkFlow> workFlows = this.findAllWorkFlows(0, 0);
        List<Long> projectsIds = workFlows.stream().map(WorkFlow::getProjectId).collect(Collectors.toList());
        projectsIds.forEach(projectId -> statuses.addAll(EntityMapper.toWorkStatuses(this.statusService.getStatuses(projectId.longValue()))));
        statuses.sort(Comparator.comparing(WorkStatus::getRank));
        return statuses;
    }

    public List<WorkFlow> findWorkFlows(ProcessesFilter processesFilter, int offset, int limit) {
        List<WorkFlowEntity> workFlowEntities = this.workFlowDAO.findWorkFlows(processesFilter, offset, limit);
        ArrayList<WorkFlow> workFlows = new ArrayList<WorkFlow>();
        workFlowEntities.forEach(workflowEntity -> {
            IllustrativeAttachment illustrativeAttachment = null;
            try {
                illustrativeAttachment = this.getIllustrationImageById(workflowEntity.getIllustrationImageId());
                if (illustrativeAttachment != null) {
                    illustrativeAttachment.setFileInputStream(null);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while getting workflow illustration image", (Throwable)e);
            }
            workFlows.add(EntityMapper.fromEntity(workflowEntity, illustrativeAttachment));
        });
        return workFlows;
    }
}

