/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.processes.model.IllustrativeAttachment;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFilter;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.model.WorkStatus;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.processes.storage.ProcessesStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class ProcessesServiceImpl
implements ProcessesService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ProcessesServiceImpl.class);
    private IdentityManager identityManager;
    private final InitParams initParams;
    private ProcessesStorage processesStorage;
    private SpaceService spaceService;
    private OrganizationService organizationService;
    private static final String PROCESSES_SPACE_NAME_PARAM = "processesSpaceName";
    private static String PROCESSES_SPACE_NAME = "Processes Space";
    private static final String PROCESSES_SPACE_TEMPLATE_PARAM = "processesSpaceTemplate";
    private static String PROCESSES_SPACE_TEMPLATE = "community";
    private static final String PROCESSES_SPACE_GROUP_ID_PARAM = "processesSpaceGroup";
    private static String PROCESSES_SPACE_GROUP_ID = "/spaces/processes_space";
    private static final String PROCESSES_SPACE_PRETTY_NAME_PARAM = "processesSpacePrettyName";
    private static String PROCESSES_SPACE_PRETTY_NAME = "processes_space";
    private static final String PROCESSES_GROUP_PARAM = "processesGroup";
    private static String PROCESSES_GROUP = "/platform/processes";
    private static final String PROCESSES_SPACE_DESCRIPTION_PARAM = "processesSpaceDescription";
    private static String PROCESSES_SPACE_DESCRIPTION = "Space where all processes will be gathered in order to manage requests";

    public ProcessesServiceImpl(InitParams initParams, ProcessesStorage processesStorage, IdentityManager identityManager, SpaceService spaceService, OrganizationService organizationService) {
        this.initParams = initParams;
        this.identityManager = identityManager;
        this.processesStorage = processesStorage;
        this.spaceService = spaceService;
        this.organizationService = organizationService;
        if (initParams != null) {
            if (initParams.getValueParam(PROCESSES_SPACE_NAME_PARAM) != null) {
                PROCESSES_SPACE_NAME = initParams.getValueParam(PROCESSES_SPACE_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(PROCESSES_SPACE_TEMPLATE_PARAM) != null) {
                PROCESSES_SPACE_TEMPLATE = initParams.getValueParam(PROCESSES_SPACE_TEMPLATE_PARAM).getValue();
            }
            if (initParams.getValueParam(PROCESSES_SPACE_GROUP_ID_PARAM) != null) {
                PROCESSES_SPACE_GROUP_ID = initParams.getValueParam(PROCESSES_SPACE_GROUP_ID_PARAM).getValue();
            }
            if (initParams.getValueParam(PROCESSES_SPACE_PRETTY_NAME_PARAM) != null) {
                PROCESSES_SPACE_PRETTY_NAME = initParams.getValueParam(PROCESSES_SPACE_PRETTY_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(PROCESSES_GROUP_PARAM) != null) {
                PROCESSES_GROUP = initParams.getValueParam(PROCESSES_GROUP_PARAM).getValue();
            }
            if (initParams.getValueParam(PROCESSES_SPACE_DESCRIPTION_PARAM) != null) {
                PROCESSES_SPACE_DESCRIPTION = initParams.getValueParam(PROCESSES_SPACE_DESCRIPTION_PARAM).getValue();
            }
        }
    }

    public List<WorkFlow> getWorkFlows(ProcessesFilter filter, int offset, int limit, long userIdentityId) throws IllegalAccessException {
        return this.processesStorage.findWorkFlows(filter, offset, limit);
    }

    public WorkFlow getWorkFlow(long id) throws IllegalAccessException {
        return this.processesStorage.getWorkFlowById(id);
    }

    public WorkFlow createWorkFlow(WorkFlow workFlow, long userId) throws IllegalAccessException {
        if (workFlow == null) {
            throw new IllegalArgumentException("workFlow is mandatory");
        }
        if (workFlow.getId() != 0L) {
            throw new IllegalArgumentException("workFlow id must be equal to 0");
        }
        return this.processesStorage.saveWorkFlow(workFlow, userId);
    }

    public WorkFlow updateWorkFlow(WorkFlow workFlow, long userId) throws IllegalArgumentException, ObjectNotFoundException, IllegalAccessException {
        if (workFlow == null) {
            throw new IllegalArgumentException("Workflow Type is mandatory");
        }
        if (workFlow.getId() == 0L) {
            throw new IllegalArgumentException("workflow type id must not be equal to 0");
        }
        WorkFlow oldWorkFlow = this.processesStorage.getWorkFlowById(workFlow.getId());
        if (oldWorkFlow == null) {
            throw new ObjectNotFoundException("oldWorkFlow is not exist");
        }
        if (oldWorkFlow.equals((Object)workFlow)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        return this.processesStorage.saveWorkFlow(workFlow, userId);
    }

    public List<Work> getWorks(long userIdentityId, WorkFilter workFilter, int offset, int limit) throws Exception {
        return this.processesStorage.getWorks(userIdentityId, workFilter, offset, limit);
    }

    public WorkFlow getWorkFlowByProjectId(long projectId) {
        return this.processesStorage.getWorkFlowByProjectId(projectId);
    }

    public Work createWork(Work work, long userId) throws IllegalAccessException {
        if (work == null) {
            throw new IllegalArgumentException("work is mandatory");
        }
        if (work.getId() != 0L) {
            throw new IllegalArgumentException("work id must be equal to 0");
        }
        return this.processesStorage.saveWork(work, userId);
    }

    public Work updateWork(Work work, long userId) throws IllegalArgumentException, ObjectNotFoundException, IllegalAccessException {
        if (work == null) {
            throw new IllegalArgumentException("Work is mandatory");
        }
        if (work.getId() == 0L) {
            throw new IllegalArgumentException("work id must not be equal to 0");
        }
        Work oldWork = this.processesStorage.getWorkById(work.getId());
        if (oldWork == null) {
            throw new ObjectNotFoundException("oldWork is not exist");
        }
        if (oldWork.equals((Object)work)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        return this.processesStorage.saveWork(work, userId);
    }

    public void deleteWorkflowById(Long workflowId) {
        this.processesStorage.deleteWorkflowById(workflowId);
    }

    public int countWorksByWorkflow(Long projectId, Boolean isCompleted) throws Exception {
        if (projectId == null) {
            throw new IllegalArgumentException("Project Id is mandatory");
        }
        if (isCompleted == null) {
            throw new IllegalArgumentException("isCompleted should not be null");
        }
        return this.processesStorage.countWorksByWorkflow(projectId.longValue(), isCompleted.booleanValue());
    }

    public void deleteWorkById(Long workId) {
        if (workId == null) {
            throw new IllegalArgumentException("Work Id is mandatory");
        }
        this.processesStorage.deleteWorkById(workId);
    }

    public Work updateWorkCompleted(Long workId, boolean completed) {
        if (workId == null) {
            throw new IllegalArgumentException("Work id is mandatory");
        }
        return this.processesStorage.updateWorkCompleted(workId, completed);
    }

    public Work createWorkDraft(Work work, long userId) throws IllegalArgumentException {
        if (work == null) {
            throw new IllegalArgumentException("WorkDraft is mandatory");
        }
        if (work.getId() != 0L) {
            throw new IllegalArgumentException("WorkDraft id must be equal to 0");
        }
        return this.processesStorage.saveWorkDraft(work, userId);
    }

    public Work updateWorkDraft(Work work, long userId) throws IllegalArgumentException, ObjectNotFoundException {
        if (work == null) {
            throw new IllegalArgumentException("WorkDraft Type is mandatory");
        }
        if (work.getId() == 0L) {
            throw new IllegalArgumentException("WorkDraft type id must not be equal to 0");
        }
        Work oldWork = this.processesStorage.getWorkDraftyId(work.getId());
        if (oldWork == null) {
            throw new ObjectNotFoundException("oldWorkDraft is not exist");
        }
        if (oldWork.equals((Object)work)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        return this.processesStorage.saveWorkDraft(work, userId);
    }

    public List<Work> getWorkDrafts(long userIdentityId, WorkFilter workFilter, int offset, int limit) {
        return this.processesStorage.findAllWorkDraftsByUser(workFilter, offset, limit, userIdentityId);
    }

    public void deleteWorkDraftById(Long draftId) {
        if (draftId == null) {
            throw new IllegalArgumentException("WorkDraft id is mandatory");
        }
        this.processesStorage.deleteWorkDraftById(draftId.longValue());
    }

    public List<WorkStatus> getAvailableWorkStatuses() {
        return this.processesStorage.getAvailableWorkStatuses();
    }

    public Work getWorkById(long userIdentityId, Long workId) {
        if (workId == null) {
            throw new IllegalArgumentException("Work id is mandatory");
        }
        return this.processesStorage.getWorkById(userIdentityId, workId.longValue());
    }

    public IllustrativeAttachment getIllustrationImageById(Long illustrationId) throws FileStorageException, ObjectNotFoundException, IOException {
        if (illustrationId == null) {
            throw new IllegalArgumentException("IllustrationId id is mandatory");
        }
        return this.processesStorage.getIllustrationImageById(illustrationId);
    }

    public void start() {
        LOG.info((Object)"Processes Service start and default space initialize...");
        PortalContainer portalContainer = PortalContainer.getInstance();
        PortalContainer.addInitTask((ServletContext)portalContainer.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostCreateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ServletContext context, PortalContainer portalContainer) {
                ExoContainerContext.setCurrentContainer((ExoContainer)portalContainer);
                RequestLifeCycle.begin((ExoContainer)portalContainer);
                try {
                    UserACL userACL = (UserACL)portalContainer.getComponentInstanceOfType(UserACL.class);
                    ProcessesServiceImpl.this.createProcessSpace(userACL);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating Processes app default space", (Throwable)e);
                }
                finally {
                    RequestLifeCycle.end();
                    LOG.info((Object)"Processes space creation ended!");
                }
            }
        });
    }

    public void createProcessSpace(UserACL userACL) throws Exception {
        ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
        membershipEntries.add(new MembershipEntry(userACL.getAdminGroups(), "*"));
        Identity superUserIdentity = new Identity(userACL.getSuperUser(), membershipEntries);
        Space existSpace = this.spaceService.getSpaceByGroupId(PROCESSES_SPACE_GROUP_ID);
        ListAccess list = this.organizationService.getUserHandler().findUsersByGroupId(PROCESSES_GROUP);
        ArrayList managers = new ArrayList();
        if (existSpace == null) {
            Space space = new Space();
            space.setDisplayName(PROCESSES_SPACE_NAME);
            if (PROCESSES_SPACE_NAME != null) {
                space.setDisplayName(PROCESSES_SPACE_NAME);
            }
            space.setVisibility("hidden");
            space.setRegistration("closed");
            space.setPriority("2");
            space.setTemplate(PROCESSES_SPACE_TEMPLATE);
            space.setDescription(PROCESSES_SPACE_DESCRIPTION);
            space.setPrettyName(PROCESSES_SPACE_PRETTY_NAME);
            Arrays.stream((User[])list.load(0, list.getSize())).map(User::getUserName).forEach(userName -> managers.add(userName));
            space.setManagers(managers.toArray(new String[managers.size()]));
            this.spaceService.createSpace(space, superUserIdentity.getUserId());
            LOG.info((Object)"Processes app default space has been successfully initialized");
        } else {
            LOG.info((Object)"Processes Space already exist, skip its creation...");
            Arrays.stream((User[])list.load(0, list.getSize())).map(User::getUserName).forEach(userName -> managers.add(userName));
            existSpace.setManagers(managers.toArray(new String[managers.size()]));
            this.spaceService.updateSpace(existSpace);
        }
    }

    public void stop() {
    }
}

