/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.processes.Utils.ProcessesUtils;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.service.ProcessesAttachmentService;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.service.AttachmentService;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;

public class ProcessesAttachmentServiceImpl
implements ProcessesAttachmentService {
    private static final Log LOG = ExoLogger.getLogger(ProcessesAttachmentServiceImpl.class);
    private final AttachmentService attachmentService;
    private final RepositoryService repositoryService;
    private final SessionProviderService sessionProviderService;
    private final ManageDriveService manageDriveService;
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final IdentityManager identityManager;
    private final NodeFinder nodeFinder;
    private final ProjectService projectService;
    private static final String PRIVATE_FOLDER = "/Private";
    private static final String PUBLIC_FOLDER = "/Public";
    private static final String GROUP_ADMINISTRATORS = "*:/platform/administrators";
    private static final String GROUP_PROCESSES = "*:/platform/processes";
    private static final String DOC_OFORM_MIMETYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.form";
    private static final String DOCXF_EXTENSION = ".docxf";
    private static final String OFORM_EXTENSION = ".oform";
    private static final String WORKFLOW_ENTITY_TYPE = "workflow";
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public ProcessesAttachmentServiceImpl(AttachmentService attachmentService, RepositoryService repositoryService, SessionProviderService sessionProviderService, ManageDriveService manageDriveService, NodeHierarchyCreator nodeHierarchyCreator, NodeFinder nodeFinder, ProjectService projectService, IdentityManager identityManager) {
        this.attachmentService = attachmentService;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.manageDriveService = manageDriveService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.nodeFinder = nodeFinder;
        this.projectService = projectService;
        this.identityManager = identityManager;
    }

    public void linkAttachmentsToEntity(Attachment[] attachments, Long userId, Long entityId, String entityType, Long projectId) {
        if (attachments != null && attachments.length > 0) {
            Arrays.stream(attachments).map(Attachment::getId).forEach(attachmentId -> {
                try {
                    this.attachmentService.linkAttachmentToEntity(userId.longValue(), entityId.longValue(), entityType, attachmentId);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while attaching files to entity", (Throwable)e);
                }
            });
            this.moveOrCopyAttachmentsJcrNodes(Arrays.asList(attachments), entityId, entityType, false, projectId);
        }
    }

    private void linkFromEntityToEntity(Long userId, List<Attachment> attachments, Long sourceEntityId, String sourceEntityType, Long destEntityId, String destEntityType, boolean deleteSource) {
        attachments.stream().map(Attachment::getId).forEach(attachmentId -> {
            try {
                this.attachmentService.linkAttachmentToEntity(userId.longValue(), destEntityId.longValue(), destEntityType, attachmentId);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while attaching files to entity", (Throwable)e);
            }
        });
        if (attachments.size() != 0 && deleteSource) {
            try {
                this.attachmentService.deleteAllEntityAttachments(userId.longValue(), sourceEntityId.longValue(), sourceEntityType);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while removing attachments to entity source", (Throwable)e);
            }
        }
    }

    private void moveOrCopyAttachmentsJcrNodes(List<Attachment> attachments, Long destEntityId, String destEntityType, boolean copy, Long projectId) {
        Session jcrSession;
        ProjectDto projectDto;
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        HashMap<Integer, Attachment> updatedAttachments = new HashMap<Integer, Attachment>();
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        permissions.put(GROUP_ADMINISTRATORS, PermissionType.ALL);
        permissions.put(GROUP_PROCESSES, PermissionType.ALL);
        permissions.put(currentUser, PermissionType.ALL);
        try {
            projectDto = this.projectService.getProject(projectId);
            projectDto.getManager().forEach(manager -> permissions.put((String)manager, PermissionType.ALL));
            projectDto.getParticipator().forEach(participator -> permissions.put((String)participator, new String[]{"read"}));
        }
        catch (EntityNotFoundException e) {
            LOG.error((Object)"Task project not found", (Throwable)e);
            return;
        }
        try {
            jcrSession = Utils.getSystemSession((SessionProviderService)this.sessionProviderService, (RepositoryService)this.repositoryService);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error while getting jcr session", (Throwable)e);
            return;
        }
        Session session = jcrSession;
        ProjectDto project = projectDto;
        IntStream.range(0, attachments.size()).forEach(index -> {
            String attachmentId = ((Attachment)attachments.get(index)).getId();
            try {
                Node rootNode;
                DriveData driveData;
                Space space = ProcessesUtils.getProjectParentSpace(projectId);
                if (space != null) {
                    driveData = this.manageDriveService.getGroupDrive(space.getGroupId());
                    rootNode = (Node)session.getItem(driveData.getHomePath());
                } else {
                    String user = (String)project.getManager().iterator().next();
                    driveData = this.manageDriveService.getUserDrive(user);
                    String publicFolderPath = driveData.getHomePath().replace(PRIVATE_FOLDER, PUBLIC_FOLDER);
                    rootNode = (Node)session.getItem(publicFolderPath);
                }
                Node destEntityNode = !rootNode.hasNode(destEntityType) ? rootNode.addNode(destEntityType, "nt:folder") : rootNode.getNode(destEntityType);
                if (!destEntityNode.hasNode(String.valueOf(destEntityId))) {
                    destEntityNode.addNode(String.valueOf(destEntityId), "nt:folder");
                }
                String newPath = destEntityType.concat("/").concat(String.valueOf(destEntityId));
                Node attachmentNode = session.getNodeByUUID(attachmentId);
                Node destNode = Utils.getParentFolderNode((Session)session, (ManageDriveService)this.manageDriveService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (NodeFinder)this.nodeFinder, (String)driveData.getName(), (String)newPath);
                if (destNode.canAddMixin("exo:privilegeable")) {
                    destNode.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)destNode).setPermissions(permissions);
                String destPath = destNode.getPath().concat("/").concat(attachmentNode.getName());
                if (copy) {
                    session.save();
                    Workspace workspace = session.getWorkspace();
                    workspace.copy(attachmentNode.getPath(), destPath);
                    Node copyNode = (Node)session.getItem(destPath);
                    this.processDocument(copyNode, currentUser);
                    Attachment copyAttachment = this.attachmentService.getAttachmentById(copyNode.getUUID());
                    updatedAttachments.put(index, copyAttachment);
                } else {
                    Node sourceEntityIdNode = attachmentNode.getParent();
                    session.move(attachmentNode.getPath(), destPath);
                    if (attachments.size() - 1 == index && sourceEntityIdNode != null && sourceEntityIdNode.getPrimaryNodeType().isNodeType("nt:folder")) {
                        sourceEntityIdNode.remove();
                    }
                    session.save();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while moving or copying attachments", (Throwable)e);
            }
        });
        if (session != null) {
            session.logout();
        }
        updatedAttachments.forEach(attachments::set);
    }

    public void moveAttachmentsToEntity(Long userId, Long sourceEntityId, String sourceEntityType, Long destEntityId, String destEntityType, Long projectId) {
        ArrayList<Attachment> attachments = new ArrayList();
        try {
            attachments = this.attachmentService.getAttachmentsByEntity(userId.longValue(), sourceEntityId.longValue(), sourceEntityType);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting entity attachments", (Throwable)e);
        }
        if (!attachments.isEmpty()) {
            this.moveOrCopyAttachmentsJcrNodes(attachments, destEntityId, destEntityType, false, projectId);
            this.linkFromEntityToEntity(userId, attachments, sourceEntityId, sourceEntityType, destEntityId, destEntityType, true);
        }
    }

    public void copyAttachmentsToEntity(Long userId, Long sourceEntityId, String sourceEntityType, Long destEntityId, String destEntityType, Long projectId) {
        ArrayList<Attachment> attachments = new ArrayList();
        try {
            attachments = this.attachmentService.getAttachmentsByEntity(userId.longValue(), sourceEntityId.longValue(), sourceEntityType);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting entity attachments", (Throwable)e);
        }
        if (!attachments.isEmpty()) {
            this.moveOrCopyAttachmentsJcrNodes(attachments, destEntityId, destEntityType, true, projectId);
            this.linkFromEntityToEntity(userId, attachments, sourceEntityId, sourceEntityType, destEntityId, destEntityType, false);
        }
    }

    public Attachment createNewFormDocument(Long userIdentityId, String title, String path, String pathDrive, String templateName, String entityType, Long entityId) throws Exception {
        Identity identity = ConversationState.getCurrent().getIdentity();
        Attachment attachment = this.attachmentService.createNewDocument(identity, title, path, pathDrive, templateName);
        if (entityId != null && entityType != null && Objects.equals(entityType, WORKFLOW_ENTITY_TYPE)) {
            ProcessesService processesService = (ProcessesService)CommonsUtils.getService(ProcessesService.class);
            WorkFlow workFlow = processesService.getWorkFlow(entityId.longValue());
            this.linkAttachmentsToEntity(new Attachment[]{attachment}, userIdentityId, entityId, entityType, workFlow.getProjectId());
        }
        return this.attachmentService.getAttachmentById(attachment.getId());
    }

    private void processDocument(Node node, String currentUser) {
        try {
            String newName;
            String extension;
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentUser);
            String newNameSuffix = "";
            String name = node.getName();
            int pointIndex = name.lastIndexOf(".");
            String string = extension = pointIndex != -1 ? name.substring(pointIndex) : "";
            if (identity != null) {
                Profile profile = identity.getProfile();
                newNameSuffix = " - ".concat(profile.getFullName() + " - ").concat(LocalDate.now().format(formatter));
            }
            String string2 = newName = pointIndex != -1 ? name.substring(0, pointIndex).concat(newNameSuffix) : name.concat(newNameSuffix);
            if (name.endsWith(DOCXF_EXTENSION)) {
                newName = newName.concat(OFORM_EXTENSION);
                Node content = node.getNode("jcr:content");
                content.setProperty("jcr:mimeType", DOC_OFORM_MIMETYPE);
            } else {
                newName = newName.concat(extension);
            }
            if (node.hasProperty("exo:title")) {
                node.setProperty("exo:title", newName);
            }
            if (node.hasProperty("exo:name")) {
                node.setProperty("exo:name", newName);
            }
            node.save();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error while processing docxf file", (Throwable)e);
        }
    }
}

