/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.processes.entity.WorkFlowEntity;

@Entity(name="Work")
@ExoEntity
@Table(name="PROCESSES_WORK")
@NamedQueries(value={@NamedQuery(name="Work.findAllWorkDraftsByUser", query="SELECT DISTINCT w FROM Work w where w.creatorId = :userId and w.isDraft = true order by w.id desc"), @NamedQuery(name="Work.getWorkDraftByTaskId", query="SELECT DISTINCT w FROM Work w where w.taskId = :taskId and w.isDraft = true"), @NamedQuery(name="Work.findAllWorkDraftsByWorkflowId", query="SELECT DISTINCT w FROM Work w where w.workFlow.id = :workflowId and w.isDraft = true")})
public class WorkEntity
implements Serializable {
    @Id
    @SequenceGenerator(name="SEQ_WORK_ID", sequenceName="SEQ_WORK_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WORK_ID")
    @Column(name="WORK_ID", nullable=false)
    private Long id;
    @Column(name="TITLE", nullable=false)
    private String title;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CREATOR_ID")
    private Long creatorId;
    @Column(name="TASK_ID")
    private Long taskId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WORKFLOW_ID", referencedColumnName="WORK_FLOW_ID")
    private WorkFlowEntity workFlow;
    @Column(name="IS_DRAFT")
    private Boolean isDraft;
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate;
    @Column(name="MODIFIED_DATE", nullable=false)
    private Date modifiedDate;

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public WorkFlowEntity getWorkFlow() {
        return this.workFlow;
    }

    public Boolean getIsDraft() {
        return this.isDraft;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setWorkFlow(WorkFlowEntity workFlow) {
        this.workFlow = workFlow;
    }

    public void setIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkEntity)) {
            return false;
        }
        WorkEntity other = (WorkEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$creatorId = this.getCreatorId();
        Long other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        Boolean this$isDraft = this.getIsDraft();
        Boolean other$isDraft = other.getIsDraft();
        if (this$isDraft == null ? other$isDraft != null : !((Object)this$isDraft).equals(other$isDraft)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        WorkFlowEntity this$workFlow = this.getWorkFlow();
        WorkFlowEntity other$workFlow = other.getWorkFlow();
        if (this$workFlow == null ? other$workFlow != null : !((Object)this$workFlow).equals(other$workFlow)) {
            return false;
        }
        Date this$createdDate = this.getCreatedDate();
        Date other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Date this$modifiedDate = this.getModifiedDate();
        Date other$modifiedDate = other.getModifiedDate();
        return !(this$modifiedDate == null ? other$modifiedDate != null : !((Object)this$modifiedDate).equals(other$modifiedDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        Boolean $isDraft = this.getIsDraft();
        result = result * 59 + ($isDraft == null ? 43 : ((Object)$isDraft).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        WorkFlowEntity $workFlow = this.getWorkFlow();
        result = result * 59 + ($workFlow == null ? 43 : ((Object)$workFlow).hashCode());
        Date $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Date $modifiedDate = this.getModifiedDate();
        result = result * 59 + ($modifiedDate == null ? 43 : ((Object)$modifiedDate).hashCode());
        return result;
    }

    public String toString() {
        return "WorkEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", creatorId=" + this.getCreatorId() + ", taskId=" + this.getTaskId() + ", workFlow=" + this.getWorkFlow() + ", isDraft=" + this.getIsDraft() + ", createdDate=" + this.getCreatedDate() + ", modifiedDate=" + this.getModifiedDate() + ")";
    }
}

