/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.rest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.processes.Utils.ProcessesUtils;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.rest.ProcessesRest;
import org.exoplatform.processes.rest.model.WorkEntity;
import org.exoplatform.processes.rest.model.WorkFlowEntity;
import org.exoplatform.processes.rest.util.EntityBuilder;
import org.exoplatform.processes.rest.util.RestUtils;
import org.exoplatform.processes.service.ProcessesAttachmentService;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.task.service.StatusService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class EntityBuilderTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<RestUtils> REST_UTILS = Mockito.mockStatic(RestUtils.class);
    private static final MockedStatic<ProcessesUtils> PROCESSES_UTILS = Mockito.mockStatic(ProcessesUtils.class);
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ProcessesService processesService;
    @Mock
    private ProcessesAttachmentService processesAttachmentService;
    private ProcessesRest processesRest;
    private IdentityRegistry identityRegistry;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        REST_UTILS.close();
        PROCESSES_UTILS.close();
    }

    @Before
    public void setUp() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        this.identityRegistry = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        this.processesRest = new ProcessesRest(this.processesService, this.identityManager, this.processesAttachmentService);
    }

    @Test
    public void toRestEntities() throws Exception {
        StatusService statusService = (StatusService)Mockito.mock(StatusService.class);
        ArrayList<WorkFlow> workFlows = new ArrayList<WorkFlow>();
        Space space = new Space();
        space.setId("test");
        space.setPrettyName("test");
        space.setDisplayName("test");
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(1L);
        workFlow.setProjectId(1L);
        workFlows.add(workFlow);
        ArrayList<WorkFlowEntity> workFlowEntities = new ArrayList<WorkFlowEntity>();
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        workFlowEntity.setId(11L);
        workFlowEntity.setSummary("test");
        workFlowEntity.setDescription("description");
        workFlowEntity.setTitle("title");
        workFlowEntity.setProjectId(1L);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = new org.exoplatform.social.core.identity.model.Identity();
        spaceIdentity.setId("1");
        spaceIdentity.getProfile().getFullName();
        spaceIdentity.setRemoteId("test");
        spaceIdentity.setProviderId("space");
        Profile profile = new Profile();
        profile.setAvatarUrl("");
        profile.setProperty("fullName", (Object)"test");
        spaceIdentity.setProfile(profile);
        ProcessesFilter processesFilter = new ProcessesFilter();
        processesFilter.setQuery("test");
        processesFilter.setEnabled(Boolean.valueOf(true));
        COMMONS_UTILS.when(() -> CommonsUtils.getService(StatusService.class)).thenReturn((Object)statusService);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(IdentityManager.class)).thenReturn((Object)this.identityManager);
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)workFlow.getProjectId())).thenReturn((Object)space);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.processesService.getWorkFlows(processesFilter, 0, 10, 1L)).thenReturn(workFlows);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity("test")).thenReturn((Object)spaceIdentity);
        EntityBuilder.toEntity((WorkFlow)workFlow);
        EntityBuilder.fromEntity((WorkFlowEntity)workFlowEntity);
        EntityBuilder.fromRestEntities(workFlowEntities);
        workFlowEntities.add(workFlowEntity);
        List fromRestEntities = EntityBuilder.fromRestEntities(workFlowEntities);
        Assert.assertNotNull((Object)fromRestEntities);
        List toRestEntities = EntityBuilder.toRestEntities(workFlows, (String)"test");
        this.processesRest.getWorkFlows(Long.valueOf(1L), Boolean.valueOf(true), null, "test", "test", 0, 10);
        Assert.assertNotNull((Object)toRestEntities);
    }

    @Test
    public void toWorkEntity() throws ObjectNotFoundException, IllegalAccessException {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(String.valueOf(currentOwnerId))).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        WorkEntity workEntity = new WorkEntity();
        Work work = new Work();
        workEntity.setId(12L);
        workEntity.setDescription("description");
        workEntity.setCompleted(true);
        workEntity.setTitle("title");
        work.setId(12L);
        work.setDescription("description");
        work.setCompleted(true);
        work.setTitle("title");
        work.setStatus("todo");
        work.setCreatedBy("testuser");
        work.setStartDate(new Date());
        work.setEndDate(new Date());
        work.setDueDate(new Date());
        work.setCreatorId(1L);
        work.setDraftId(Long.valueOf(1L));
        work.setTaskId(Long.valueOf(1L));
        work.setIsDraft(Boolean.valueOf(false));
        Work work1 = EntityBuilder.toWork((ProcessesService)this.processesService, (WorkEntity)workEntity);
        EntityBuilder.fromEntity((WorkEntity)workEntity);
        EntityBuilder.toEntity((Work)work);
        WorkEntity toWorkEntity = EntityBuilder.toWorkEntity((ProcessesService)this.processesService, (Work)work, (String)"test");
        Mockito.when((Object)this.processesService.updateWork(work1, 1L)).thenReturn((Object)work);
        this.processesRest.updateWork(workEntity);
        Assert.assertNotNull((Object)toWorkEntity);
    }
}

