/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.notification.plugin;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.notification.plugin.RequestCommentPlugin;
import org.exoplatform.processes.notification.utils.NotificationArguments;
import org.exoplatform.processes.notification.utils.NotificationUtils;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RequestCommentPluginTest
extends TestCase {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<NotificationUtils> NOTIFICATION_UTILS = Mockito.mockStatic(NotificationUtils.class);
    @Mock
    private InitParams initParams;
    private RequestCommentPlugin requestCommentPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        EXO_CONTAINER_CONTEXT.close();
        NOTIFICATION_UTILS.close();
    }

    @Before
    public void setUp() {
        this.requestCommentPlugin = new RequestCommentPlugin(this.initParams);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
    }

    @Test
    public void isValid() {
        NotificationContext ctx1 = NotificationContextImpl.cloneInstance();
        ctx1.append(NotificationArguments.REQUEST_CREATOR, (Object)"root");
        ctx1.append(NotificationArguments.REQUEST_COMMENT_AUTHOR, (Object)"user");
        boolean valid = this.requestCommentPlugin.isValid(ctx1);
        RequestCommentPluginTest.assertTrue((boolean)valid);
        NotificationContext ctx2 = NotificationContextImpl.cloneInstance();
        ctx2.append(NotificationArguments.REQUEST_CREATOR, (Object)"root");
        ctx2.append(NotificationArguments.REQUEST_COMMENT_AUTHOR, (Object)"root");
        valid = this.requestCommentPlugin.isValid(ctx2);
        RequestCommentPluginTest.assertFalse((boolean)valid);
    }

    @Test
    public void testMakeNotification() {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationArguments.REQUEST_CREATOR, (Object)"root");
        ctx.append(NotificationArguments.REQUEST_TITLE, (Object)"test request");
        ctx.append(NotificationArguments.REQUEST_PROCESS, (Object)"test process");
        ctx.append(NotificationArguments.REQUEST_COMMENT_AUTHOR, (Object)"user");
        ctx.append(NotificationArguments.REQUEST_COMMENT, (Object)"test");
        ctx.append(NotificationArguments.PROCESS_URL, (Object)"http://exoplatfrom.com/dw/tasks/projectDetail/1");
        ctx.append(NotificationArguments.REQUEST_COMMENT_URL, (Object)"http://exoplatfrom.com/dw/processes/myRequests/requestDetails/1/comments");
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add("root");
        NotificationInfo notificationInfo = this.requestCommentPlugin.makeNotification(ctx);
        RequestCommentPluginTest.assertEquals((String)"root", (String)notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_CREATOR.getKey()));
        RequestCommentPluginTest.assertEquals((String)"http://exoplatfrom.com/dw/tasks/projectDetail/1", (String)notificationInfo.getValueOwnerParameter(NotificationArguments.PROCESS_URL.getKey()));
        RequestCommentPluginTest.assertEquals((String)"http://exoplatfrom.com/dw/processes/myRequests/requestDetails/1/comments", (String)notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_COMMENT_URL.getKey()));
        RequestCommentPluginTest.assertEquals((String)"test", (String)notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_COMMENT.getKey()));
        RequestCommentPluginTest.assertEquals((String)"test request", (String)notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_TITLE.getKey()));
        RequestCommentPluginTest.assertEquals((String)"user", (String)notificationInfo.getFrom());
        RequestCommentPluginTest.assertEquals(receivers, (Object)notificationInfo.getSendToUserIds());
    }
}

