/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.service;

import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.processes.Utils.ProcessesUtils;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.service.ProcessesAttachmentService;
import org.exoplatform.processes.service.ProcessesAttachmentServiceImpl;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.service.AttachmentService;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.service.ProjectService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ProcessesAttachmentServiceImplTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<Utils> UTILS = Mockito.mockStatic(Utils.class);
    private static final MockedStatic<ConversationState> CONVERSATION_STATE = Mockito.mockStatic(ConversationState.class);
    private static final MockedStatic<ProcessesUtils> PROCESSES_UTILS = Mockito.mockStatic(ProcessesUtils.class);
    @Mock
    private AttachmentService attachmentService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private ManageDriveService manageDriveService;
    @Mock
    private NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    private NodeFinder nodeFinder;
    @Mock
    private ProjectService projectService;
    @Mock
    private IdentityManager identityManager;
    private ProcessesAttachmentService processesAttachmentService;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        UTILS.close();
        CONVERSATION_STATE.close();
        PROCESSES_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.processesAttachmentService = new ProcessesAttachmentServiceImpl(this.attachmentService, this.repositoryService, this.sessionProviderService, this.manageDriveService, this.nodeHierarchyCreator, this.nodeFinder, this.projectService, this.identityManager);
        ConversationState conversationState = (ConversationState)Mockito.mock(ConversationState.class);
        CONVERSATION_STATE.when(() -> ConversationState.getCurrent()).thenReturn((Object)conversationState);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)conversationState.getIdentity()).thenReturn((Object)identity);
        Mockito.when((Object)this.identityManager.getIdentity((String)ArgumentMatchers.any())).thenReturn((Object)userIdentity);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"test");
        Mockito.when((Object)userIdentity.getRemoteId()).thenReturn((Object)"test");
    }

    @Test
    public void linkAttachmentsToEntity() throws Exception {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        attachment.setId("1");
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        HashSet<String> managers = new HashSet<String>();
        HashSet<String> participators = new HashSet<String>();
        managers.add("manager:/spaces/processes_space");
        participators.add("members:/spaces/processes_space");
        projectDto.setManager(managers);
        projectDto.setParticipator(participators);
        Space space = new Space();
        space.setGroupId("/spaces/processes_space");
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)1L)).thenReturn((Object)space);
        this.processesAttachmentService.linkAttachmentsToEntity(attachmentList.toArray(new Attachment[0]), Long.valueOf(1L), Long.valueOf(1L), "workflow", Long.valueOf(1L));
        ((AttachmentService)Mockito.verify((Object)this.attachmentService, (VerificationMode)Mockito.times((int)0))).linkAttachmentToEntity(1L, 1L, "workflow", "1");
        attachmentList.add(attachment);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)projectDto);
        this.processesAttachmentService.linkAttachmentsToEntity(attachmentList.toArray(new Attachment[0]), Long.valueOf(1L), Long.valueOf(1L), "workflow", Long.valueOf(1L));
        ((AttachmentService)Mockito.verify((Object)this.attachmentService, (VerificationMode)Mockito.times((int)1))).linkAttachmentToEntity(1L, 1L, "workflow", "1");
    }

    @Test
    public void moveAttachmentsToEntity() throws Exception {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        attachment.setId("1");
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        ExtendedNode extendedNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        HashSet<String> managers = new HashSet<String>();
        HashSet<String> participators = new HashSet<String>();
        managers.add("manager:/spaces/processes_space");
        participators.add("members:/spaces/processes_space");
        projectDto.setManager(managers);
        projectDto.setParticipator(participators);
        Space space = new Space();
        space.setGroupId("/spaces/processes_space");
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)projectDto);
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)1L)).thenReturn((Object)space);
        ProcessesAttachmentService processesAttachmentService1 = (ProcessesAttachmentService)Mockito.mock(ProcessesAttachmentService.class);
        Mockito.when((Object)this.attachmentService.getAttachmentsByEntity(1L, 1L, "workflow")).thenReturn(attachmentList);
        this.processesAttachmentService.moveAttachmentsToEntity(Long.valueOf(1L), Long.valueOf(1L), "workflow", Long.valueOf(1L), "workdraft", Long.valueOf(1L));
        ((ProcessesAttachmentService)Mockito.verify((Object)processesAttachmentService1, (VerificationMode)Mockito.times((int)0))).linkAttachmentsToEntity(attachmentList.toArray(new Attachment[0]), Long.valueOf(1L), Long.valueOf(1L), "workdraft", Long.valueOf(1L));
        attachmentList.add(attachment);
        UTILS.when(() -> Utils.getSystemSession((SessionProviderService)this.sessionProviderService, (RepositoryService)this.repositoryService)).thenReturn((Object)session);
        DriveData driveData = new DriveData();
        driveData.setHomePath("path");
        driveData.setName("processes.drive");
        Mockito.when((Object)this.manageDriveService.getGroupDrive("/spaces/processes_space")).thenReturn((Object)driveData);
        Mockito.when((Object)session.getItem(driveData.getHomePath())).thenReturn((Object)node);
        Mockito.when((Object)node.hasNode("workdraft")).thenReturn((Object)false);
        Mockito.when((Object)node.hasNode("1")).thenReturn((Object)false);
        Mockito.when((Object)node.addNode("workdraft", "nt:folder")).thenReturn((Object)node);
        Mockito.when((Object)node.addNode("1", "nt:folder")).thenReturn((Object)node);
        Mockito.when((Object)session.getNodeByUUID("1")).thenReturn((Object)node);
        UTILS.when(() -> Utils.getParentFolderNode((Session)session, (ManageDriveService)this.manageDriveService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (NodeFinder)this.nodeFinder, (String)driveData.getName(), (String)"workdraft/1")).thenReturn((Object)extendedNode);
        Mockito.when((Object)extendedNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        Mockito.when((Object)extendedNode.getName()).thenReturn((Object)"test");
        Mockito.when((Object)node.getName()).thenReturn((Object)"test");
        Mockito.when((Object)node.getPath()).thenReturn((Object)"srcPath");
        Mockito.when((Object)extendedNode.getPath()).thenReturn((Object)"destPath");
        Mockito.when((Object)node.getParent()).thenReturn((Object)node);
        this.processesAttachmentService.moveAttachmentsToEntity(Long.valueOf(1L), Long.valueOf(1L), "workflow", Long.valueOf(1L), "workdraft", Long.valueOf(1L));
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).move("srcPath", "destPath/test");
    }

    @Test
    public void copyAttachmentsToEntity() throws Exception {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        attachment.setId("1");
        Session session = (Session)Mockito.mock(Session.class);
        UTILS.when(() -> Utils.getSystemSession((SessionProviderService)this.sessionProviderService, (RepositoryService)this.repositoryService)).thenReturn((Object)session);
        Node node = (Node)Mockito.mock(Node.class);
        ExtendedNode extendedNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        HashSet<String> managers = new HashSet<String>();
        HashSet<String> participators = new HashSet<String>();
        managers.add("manager:/spaces/processes_space");
        participators.add("members:/spaces/processes_space");
        projectDto.setManager(managers);
        projectDto.setParticipator(participators);
        Space space = new Space();
        space.setGroupId("/spaces/processes_space");
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)1L)).thenReturn((Object)space);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)projectDto);
        ProcessesAttachmentService processesAttachmentService1 = (ProcessesAttachmentService)Mockito.mock(ProcessesAttachmentService.class);
        Mockito.when((Object)this.attachmentService.getAttachmentsByEntity(1L, 1L, "workdraft")).thenReturn(attachmentList);
        this.processesAttachmentService.copyAttachmentsToEntity(Long.valueOf(1L), Long.valueOf(1L), "workdraft", Long.valueOf(1L), "work", Long.valueOf(1L));
        ((ProcessesAttachmentService)Mockito.verify((Object)processesAttachmentService1, (VerificationMode)Mockito.times((int)0))).linkAttachmentsToEntity(attachmentList.toArray(new Attachment[0]), Long.valueOf(1L), Long.valueOf(1L), "work", Long.valueOf(1L));
        attachmentList.add(attachment);
        DriveData driveData = new DriveData();
        driveData.setHomePath("path");
        driveData.setName("processes.drive");
        Mockito.when((Object)this.manageDriveService.getGroupDrive("/spaces/processes_space")).thenReturn((Object)driveData);
        Mockito.when((Object)session.getItem(driveData.getHomePath())).thenReturn((Object)node);
        Mockito.when((Object)node.hasNode("work")).thenReturn((Object)false);
        Mockito.when((Object)node.hasNode("1")).thenReturn((Object)false);
        Mockito.when((Object)node.addNode("work", "nt:folder")).thenReturn((Object)node);
        Mockito.when((Object)node.addNode("1", "nt:folder")).thenReturn((Object)node);
        Mockito.when((Object)session.getNodeByUUID("1")).thenReturn((Object)node);
        UTILS.when(() -> Utils.getParentFolderNode((Session)session, (ManageDriveService)this.manageDriveService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (NodeFinder)this.nodeFinder, (String)driveData.getName(), (String)"work/1")).thenReturn((Object)extendedNode);
        Mockito.when((Object)extendedNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        Mockito.when((Object)extendedNode.getName()).thenReturn((Object)"test");
        Mockito.when((Object)node.getName()).thenReturn((Object)"test");
        Mockito.when((Object)node.getPath()).thenReturn((Object)"srcPath");
        Mockito.when((Object)extendedNode.getPath()).thenReturn((Object)"destPath");
        Mockito.when((Object)node.getParent()).thenReturn((Object)node);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)session.getItem("destPath/test")).thenReturn((Object)node);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)"2");
        Attachment attachment1 = new Attachment();
        attachment1.setId("2");
        Mockito.when((Object)this.attachmentService.getAttachmentById("2")).thenReturn((Object)attachment1);
        this.processesAttachmentService.copyAttachmentsToEntity(Long.valueOf(1L), Long.valueOf(1L), "workdraft", Long.valueOf(1L), "work", Long.valueOf(1L));
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)1))).copy("srcPath", "destPath/test");
        DriveData userDriveData = new DriveData();
        userDriveData.setName("user");
        userDriveData.setHomePath("path/user/Private/Documents");
        Mockito.when((Object)session.getItem("path/user/Public/Documents")).thenReturn((Object)node);
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)1L)).thenReturn(null);
        Mockito.when((Object)this.manageDriveService.getUserDrive((String)managers.iterator().next())).thenReturn((Object)userDriveData);
        UTILS.when(() -> Utils.getParentFolderNode((Session)session, (ManageDriveService)this.manageDriveService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (NodeFinder)this.nodeFinder, (String)userDriveData.getName(), (String)"work/1")).thenReturn((Object)extendedNode);
        Mockito.when((Object)session.getNodeByUUID("2")).thenReturn((Object)node);
        Mockito.when((Object)node.getName()).thenReturn((Object)"test.docxf");
        Mockito.when((Object)session.getItem("destPath/test.docxf")).thenReturn((Object)node);
        Node content = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getNode("jcr:content")).thenReturn((Object)content);
        Mockito.when((Object)node.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.when((Object)node.hasProperty("exo:name")).thenReturn((Object)true);
        this.processesAttachmentService.copyAttachmentsToEntity(Long.valueOf(1L), Long.valueOf(1L), "workdraft", Long.valueOf(1L), "work", Long.valueOf(1L));
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)1))).copy("srcPath", "destPath/test.docxf");
    }

    @Test
    public void createNewFormDocument() throws Exception {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setProjectId(1L);
        ProcessesService processesService = (ProcessesService)Mockito.mock(ProcessesService.class);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(ProcessesService.class)).thenReturn((Object)processesService);
        Mockito.when((Object)processesService.getWorkFlow(1L)).thenReturn((Object)workFlow);
        Attachment attachment = (Attachment)Mockito.mock(Attachment.class);
        Mockito.when((Object)this.attachmentService.createNewDocument((Identity)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)attachment);
        this.copyAttachmentsToEntity();
        this.processesAttachmentService.createNewFormDocument(Long.valueOf(1L), "doc", "path", "spaces.processes_space", "template", "workflow", Long.valueOf(1L));
    }
}

