/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.rest.util;

import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class RestUtils {
    private static final String PROCESSES_GROUP = "/platform/processes";

    private RestUtils() {
    }

    public static final String getCurrentUser() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    public static final Identity getCurrentUserIdentity(IdentityManager identityManager) {
        String currentUser = RestUtils.getCurrentUser();
        return identityManager.getOrCreateUserIdentity(currentUser);
    }

    public static final long getCurrentUserIdentityId(IdentityManager identityManager) {
        String currentUser = RestUtils.getCurrentUser();
        Identity identity = identityManager.getOrCreateUserIdentity(currentUser);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    public static boolean isProcessesGroupMember(org.exoplatform.services.security.Identity identity) {
        return identity != null && identity.isMemberOf(PROCESSES_GROUP);
    }

    public static boolean isProcessesGroupMember(IdentityManager identityManager, IdentityRegistry identityRegistry, long userId) {
        Identity identity = identityManager.getIdentity(userId);
        if (identity == null) {
            return false;
        }
        String remoteId = identity.getRemoteId();
        if (remoteId == null) {
            return false;
        }
        return RestUtils.isProcessesGroupMember(identityRegistry.getIdentity(remoteId));
    }
}

