/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.model.RestActivity;
import org.exoplatform.social.client.api.model.RestActivityStream;
import org.exoplatform.social.client.api.model.RestComment;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.model.RestLike;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.core.model.ModelImpl;
import org.exoplatform.social.client.core.model.RestActivityStreamImpl;
import org.exoplatform.social.client.core.model.RestCommentImpl;
import org.exoplatform.social.client.core.model.RestLikeImpl;
import org.exoplatform.social.client.core.service.ActivityServiceImpl;
import org.exoplatform.social.client.core.service.IdentityServiceImpl;
import org.exoplatform.social.client.core.util.SocialHttpClientSupport;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestActivityImpl
extends ModelImpl
implements RestActivity {
    @Override
    public String getId() {
        return this.getFieldAsString(RestActivity.Field.ID.toString());
    }

    @Override
    public void setId(String id) {
        this.setField(RestActivity.Field.ID.toString(), id);
    }

    @Override
    public String getTitle() {
        return this.getFieldAsString(RestActivity.Field.TITLE.toString());
    }

    @Override
    public void setTitle(String title) {
        this.setField(RestActivity.Field.TITLE.toString(), title);
    }

    @Override
    public String getTitleId() {
        return this.getFieldAsString(RestActivity.Field.TITLE_ID.toString());
    }

    @Override
    public void setTitleId(String titleId) {
        this.setField(RestActivity.Field.TITLE_ID.toString(), titleId);
    }

    @Override
    public String getAppId() {
        return this.getFieldAsString(RestActivity.Field.APP_ID.toString());
    }

    @Override
    public void setAppId(String appId) {
        this.setField(RestActivity.Field.APP_ID.toString(), appId);
    }

    @Override
    public Long getPostedTime() {
        return (Long)this.getField(RestActivity.Field.POSTED_TIME.toString());
    }

    @Override
    public void setPostedTime(Long postedTime) {
        this.setField(RestActivity.Field.POSTED_TIME.toString(), postedTime);
    }

    @Override
    public Double getPriority() {
        return (Double)this.getField(RestActivity.Field.PRIORITY.toString());
    }

    @Override
    public void setPriority(Double priority) {
        this.setField(RestActivity.Field.PRIORITY.toString(), priority);
    }

    @Override
    public Map<String, String> getTemplateParams() {
        return this.getFieldAsMap(RestActivity.Field.TEMPLATE_PARAMS.toString());
    }

    @Override
    public void setTemplateParams(Map<String, String> templateParams) {
        this.setField(RestActivity.Field.TEMPLATE_PARAMS.toString(), templateParams);
    }

    @Override
    public String getIdentityId() {
        return this.getFieldAsString(RestActivity.Field.IDENTITY_ID.toString());
    }

    @Override
    public void setIdentityId(String identityId) {
        this.setField(RestActivity.Field.IDENTITY_ID.toString(), identityId);
    }

    @Override
    public boolean isLiked() {
        return Boolean.parseBoolean(this.getFieldAsString(RestActivity.Field.LIKED.toString()));
    }

    @Override
    public List<RestLike> getLikes() {
        try {
            String likedIdentityString = this.getFieldAsString(RestActivity.Field.LIKED_BY_IDENTITIES.toString());
            ArrayList<RestLike> result = new ArrayList<RestLike>();
            if (likedIdentityString != null) {
                JSONArray identitiesArray = (JSONArray)JSONValue.parse((String)likedIdentityString);
                for (Object identityJsonItem : identitiesArray) {
                    JSONObject jsonObject = (JSONObject)identityJsonItem;
                    RestLikeImpl restLikeItem = new RestLikeImpl();
                    restLikeItem.setIdentityId((String)jsonObject.get((Object)"id"));
                    restLikeItem.setActivityId(this.getId());
                    result.add(restLikeItem);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public RestIdentity getPosterIdentity() {
        return new IdentityServiceImpl().get(this.getIdentityId());
    }

    @Override
    public List<RestComment> getAvailableComments() {
        String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + ".json?number_of_comments=5";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            JSONObject jsonObject = (JSONObject)JSONValue.parse((String)responseContent);
            JSONArray commentsJsonarray = (JSONArray)jsonObject.get((Object)"comments");
            List<RestCommentImpl> comments = SocialJSONDecodingSupport.JSONArrayObjectParser(RestCommentImpl.class, commentsJsonarray.toJSONString());
            ArrayList<RestComment> result = new ArrayList<RestComment>();
            result.addAll(comments);
            return result;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public void setAvailableComments(List<RestComment> restCommentList) {
    }

    @Override
    public int getTotalNumberOfComments() {
        return Integer.parseInt(this.getFieldAsString(RestActivity.Field.TOTAL_NUMBER_OF_COMMENTS.toString()));
    }

    @Override
    public List<RestComment> getTotalComments() {
        String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + "/comments.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            List<RestCommentImpl> comments = SocialJSONDecodingSupport.JSONArrayObjectParser(RestCommentImpl.class, responseContent);
            ArrayList<RestComment> result = new ArrayList<RestComment>();
            result.addAll(comments);
            return result;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public RestActivityStream getActivityStream() {
        String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + "/comment.json?activity_stream=1";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            JSONObject jsonObject = (JSONObject)JSONValue.parse((String)responseContent);
            JSONObject activityStreamJson = (JSONObject)jsonObject.get((Object)"activityStream");
            RestActivityStreamImpl activityStream = SocialJSONDecodingSupport.parser(RestActivityStreamImpl.class, activityStreamJson.toJSONString());
            return activityStream;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public String getTemplateParameter(String name) {
        Map<String, String> templateParams = this.getTemplateParams();
        if (templateParams != null) {
            return templateParams.get(name);
        }
        return null;
    }

    @Override
    public void addTemplateParameter(String name, String value) {
        Map<String, String> templateParams = this.getTemplateParams();
        if (templateParams == null) {
            templateParams = new HashMap<String, String>();
        }
        templateParams.put(name, value);
        this.setTemplateParams(templateParams);
    }
}

