/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.model;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.model.RestActivity;
import org.exoplatform.social.client.api.model.RestComment;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.core.model.ModelImpl;
import org.exoplatform.social.client.core.util.SocialHttpClientSupport;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;
import org.json.simple.parser.ParseException;

public class RestCommentImpl
extends ModelImpl
implements RestComment {
    public RestCommentImpl() {
    }

    public RestCommentImpl(String id, String identityId, String activityId, Long postedTime, String createdAt) {
        this.setId(id);
        this.setIdentityId(identityId);
        this.setActivityId(activityId);
        this.setPostedTime(postedTime);
        this.setCreatedAt(createdAt);
    }

    public String getId() {
        return this.getFieldAsString(RestComment.Field.ID.toString());
    }

    public void setId(String id) {
        this.setField(RestComment.Field.ID.toString(), id);
    }

    public String getIdentityId() {
        return this.getFieldAsString(RestComment.Field.IDENTITY_ID.toString());
    }

    public void setIdentityId(String identityId) {
        this.setField(RestComment.Field.IDENTITY_ID.toString(), identityId);
    }

    public String getActivityId() {
        return this.getFieldAsString(RestComment.Field.ACTIVITY_ID.toString());
    }

    public void setActivityId(String activityId) {
        this.setField(RestComment.Field.ACTIVITY_ID.toString(), activityId);
    }

    public String getText() {
        return this.getFieldAsString(RestComment.Field.TEXT.toString());
    }

    public void setText(String content) {
        this.setField(RestComment.Field.TEXT.toString(), content);
    }

    public Long getPostedTime() {
        return (Long)this.getField(RestComment.Field.POSTED_TIME.toString());
    }

    public void setPostedTime(Long postedTime) {
        this.setField(RestComment.Field.POSTED_TIME.toString(), postedTime);
    }

    public String getCreatedAt() {
        return this.getFieldAsString(RestComment.Field.CREATED_AT.toString());
    }

    public void setCreatedAt(String createdAt) {
        this.setField(RestComment.Field.CREATED_AT.toString(), createdAt);
    }

    public RestActivity getActivity() {
        RestActivity restActivity = null;
        try {
            String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);
            String requestURL = BASE_URL + "restActivity/" + this.getActivityId() + ".json";
            HttpResponse response = SocialHttpClientSupport.executeGet(requestURL, SocialHttpClient.POLICY.BASIC_AUTH);
            restActivity = SocialJSONDecodingSupport.parser(RestActivity.class, response);
        }
        catch (IOException e) {
            throw new ServiceException(RestCommentImpl.class, "IOException when reads Json Content.", e);
        }
        catch (ParseException e) {
            throw new ServiceException(RestCommentImpl.class, "ParseException when reads Json Content.", e);
        }
        return restActivity;
    }

    public RestIdentity getIdentity() {
        RestIdentity restIdentity = null;
        try {
            String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);
            String requestURL = BASE_URL + "restIdentity/" + this.getIdentityId() + ".json";
            HttpResponse response = SocialHttpClientSupport.executeGet(requestURL, SocialHttpClient.POLICY.BASIC_AUTH);
            restIdentity = SocialJSONDecodingSupport.parser(RestIdentity.class, response);
        }
        catch (IOException e) {
            throw new ServiceException(RestCommentImpl.class, "IOException when reads Json Content.", e);
        }
        catch (ParseException e) {
            throw new ServiceException(RestCommentImpl.class, "ParseException when reads Json Content.", e);
        }
        return restIdentity;
    }
}

