/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.auth.AccessDeniedException;
import org.exoplatform.social.client.api.common.RealtimeListAccess;
import org.exoplatform.social.client.api.model.RestActivity;
import org.exoplatform.social.client.api.model.RestComment;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.model.RestLike;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.ActivityService;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.core.model.ActivitiesRealtimeListAccess;
import org.exoplatform.social.client.core.model.RestActivityImpl;
import org.exoplatform.social.client.core.model.RestCommentImpl;
import org.exoplatform.social.client.core.model.RestLikeImpl;
import org.exoplatform.social.client.core.service.ServiceBase;
import org.exoplatform.social.client.core.util.SocialHttpClientSupport;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityServiceImpl
extends ServiceBase<RestActivity, ActivityService<RestActivity>>
implements ActivityService<RestActivity> {
    private static final String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);

    @Override
    public RestActivity create(RestActivity newInstance) throws AccessDeniedException, ServiceException {
        String POST_ACTIVITY_REQUEST_URL = BASE_URL + "activity.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(POST_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH, newInstance);
            String responseContent = SocialHttpClientSupport.getContent(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivityImpl.class, responseContent);
            return restActivity;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public RestActivity get(String uuid) throws AccessDeniedException, ServiceException {
        String GET_ACTIVITY_REQUEST_URL = BASE_URL + "activity/" + uuid + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivityImpl.class, responseContent);
            return restActivity;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public RestActivity update(RestActivity existingInstance) throws AccessDeniedException, ServiceException {
        throw new ServiceException(ActivityServiceImpl.class, "Do Not Support", null);
    }

    @Override
    public RestActivity delete(RestActivity existingInstance) throws AccessDeniedException, ServiceException {
        String DELETE_ACTIVITY_REQUEST_URL = BASE_URL + "activity/destroy/" + existingInstance.getId() + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(DELETE_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivityImpl.class, responseContent);
            return restActivity;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public RealtimeListAccess<RestActivity> getActivityStream(RestIdentity restIdentity) throws AccessDeniedException, ServiceException {
        return new ActivitiesRealtimeListAccess(restIdentity, ActivitiesRealtimeListAccess.ActivityType.ACTIVITY_STREAM);
    }

    @Override
    public RealtimeListAccess<RestActivity> getSpacesActivityStream(RestIdentity userRestIdentity) throws AccessDeniedException, ServiceException {
        return new ActivitiesRealtimeListAccess(userRestIdentity, ActivitiesRealtimeListAccess.ActivityType.USER_SPACE_ACTIVITIES);
    }

    @Override
    public RealtimeListAccess<RestActivity> getConnectionsActivityStream(RestIdentity userRestIdentity) throws AccessDeniedException, ServiceException {
        return new ActivitiesRealtimeListAccess(userRestIdentity, ActivitiesRealtimeListAccess.ActivityType.CONNECTIONS_ACTIVITIES);
    }

    @Override
    public RealtimeListAccess<RestActivity> getFeedActivityStream(RestIdentity userRestIdentity) throws AccessDeniedException, ServiceException {
        return new ActivitiesRealtimeListAccess(userRestIdentity, ActivitiesRealtimeListAccess.ActivityType.ACTIVITY_FEED);
    }

    @Override
    public RestComment createComment(RestActivity existingRestActivity, RestComment newRestComment) throws AccessDeniedException, ServiceException {
        String CREATE_COMMENT_REQUEST_URL = BASE_URL + "activity/" + existingRestActivity.getId() + "/comment.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(CREATE_COMMENT_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH, newRestComment);
            String responseContent = SocialHttpClientSupport.getContent(response);
            RestComment restComment = SocialJSONDecodingSupport.parser(RestCommentImpl.class, responseContent);
            return restComment;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, e.getMessage(), null);
        }
    }

    @Override
    public RestComment getComment(String commentId) throws AccessDeniedException, ServiceException {
        throw new ServiceException(ActivityServiceImpl.class, "Not Supported", null);
    }

    @Override
    public RestComment deleteComment(RestComment existingRestComment) throws AccessDeniedException, ServiceException {
        String DELETE_COMMENT_REQUEST_URL = BASE_URL + "activity/" + existingRestComment.getActivityId() + "/comment/destroy/" + existingRestComment.getId() + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(DELETE_COMMENT_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            RestComment restComment = SocialJSONDecodingSupport.parser(RestCommentImpl.class, responseContent);
            return restComment;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, "invalid response", null);
        }
    }

    @Override
    public RestLike like(RestActivity existingRestActivity) throws AccessDeniedException, ServiceException {
        String LIKE_ACTIVITY_REQUEST_URL = BASE_URL + "activity/" + existingRestActivity.getId() + "/like.json";
        HttpResponse response = SocialHttpClientSupport.executePost(LIKE_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
        String responseContent = SocialHttpClientSupport.getContent(response);
        try {
            JSONObject responeJson = (JSONObject)JSONValue.parse((String)responseContent);
            if (((Boolean)responeJson.get((Object)"like")).booleanValue()) {
                return new RestLikeImpl(existingRestActivity.getId(), null);
            }
            throw new ServiceException(ActivityServiceImpl.class, "invalid response", null);
        }
        catch (Exception e) {
            throw new ServiceException(ActivityServiceImpl.class, "invalid response", null);
        }
    }

    @Override
    public RestLike unlike(RestActivity existingRestActivity) throws AccessDeniedException, ServiceException {
        String LIKE_ACTIVITY_REQUEST_URL = BASE_URL + "activity/" + existingRestActivity.getId() + "/like/destroy.json";
        HttpResponse response = SocialHttpClientSupport.executePost(LIKE_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
        String responseContent = SocialHttpClientSupport.getContent(response);
        JSONObject responeJson = (JSONObject)JSONValue.parse((String)responseContent);
        if (!((Boolean)responeJson.get((Object)"like")).booleanValue()) {
            return new RestLikeImpl(existingRestActivity.getId(), null);
        }
        throw new ServiceException(ActivityServiceImpl.class, "invalid response", null);
    }
}

