/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.util;

import org.exoplatform.social.client.api.event.Lifecycle;
import org.exoplatform.social.client.api.event.LifecycleEvent;
import org.exoplatform.social.client.api.event.LifecycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleSupport<M, L> {
    private Lifecycle<M, L> lifecycle = null;
    private LifecycleListener<M, L>[] listeners = new LifecycleListener[0];
    private final Object listenersLock = new Object();

    public LifecycleSupport(Lifecycle<M, L> lifecycle) {
        this.lifecycle = lifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener<M, L> listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            LifecycleListener[] results = new LifecycleListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, results, 0, this.listeners.length);
            results[this.listeners.length] = listener;
            this.listeners = results;
        }
    }

    public void broadcastEvent(String type, L data) {
        LifecycleEvent<M, L> event = new LifecycleEvent<M, L>(this.lifecycle, type, data);
        LifecycleListener<M, L>[] interested = this.listeners;
        for (int i = 0; i < interested.length; ++i) {
            interested[i].broadcast(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener<M, L> listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != listener) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            LifecycleListener[] results = new LifecycleListener[this.listeners.length - 1];
            int j = 0;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.listeners[i];
            }
            this.listeners = results;
        }
    }

    public LifecycleListener<M, L>[] findLifecycleListeners() {
        return this.listeners;
    }
}

