/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.util;

import org.exoplatform.social.client.api.event.CRUDLifecycle;
import org.exoplatform.social.client.api.event.CRUDLifecycleEvent;
import org.exoplatform.social.client.api.event.CRUDLifecycleListener;

public class CRUDLifecycleSupport<M> {
    private CRUDLifecycle<M> crudlifecycle = null;
    private CRUDLifecycleListener<M>[] listeners = new CRUDLifecycleListener[0];
    private final Object listenersLock = new Object();

    public CRUDLifecycleSupport(CRUDLifecycle<M> crudlifecycle) {
        this.crudlifecycle = crudlifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCRUDLifecycleListener(CRUDLifecycleListener<M> listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            CRUDLifecycleListener[] results = new CRUDLifecycleListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, results, 0, this.listeners.length);
            results[this.listeners.length] = listener;
            this.listeners = results;
        }
    }

    public void broadcastEvent(String type, M data) {
        CRUDLifecycleEvent<M> event = new CRUDLifecycleEvent<M>(this.crudlifecycle, type, data);
        CRUDLifecycleListener<M>[] interested = this.listeners;
        for (int i = 0; i < interested.length; ++i) {
            interested[i].broadcast(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCRUDLifecycleListener(CRUDLifecycleListener<M> listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != listener) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            CRUDLifecycleListener[] results = new CRUDLifecycleListener[this.listeners.length - 1];
            int j = 0;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.listeners[i];
            }
            this.listeners = results;
        }
    }

    public CRUDLifecycleListener<M>[] findCRUDLifecycleListeners() {
        return this.listeners;
    }
}

