/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.net;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.exoplatform.social.client.api.SocialClientContext;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.auth.UnAuthenticatedException;
import org.exoplatform.social.client.api.net.SocialHttpClient;

public final class SocialHttpClientImpl
implements SocialHttpClient {
    public static long DEFAULT_SYNC_MIN_GZIP_BYTES = 256L;
    private static final int SOCKET_OPERATION_TIMEOUT = 60000;
    private final DefaultHttpClient delegate;
    private HttpRequestInterceptor preemptiveAuthInterceptor = new HttpRequestInterceptor(){

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthScope authScope;
            Credentials creds;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                authState.setAuthScheme((AuthScheme)new BasicScheme());
                authState.setCredentials(creds);
            }
        }
    };

    public static SocialHttpClient newInstance() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        return new SocialHttpClientImpl((ClientConnectionManager)manager, (HttpParams)params);
    }

    private SocialHttpClientImpl(ClientConnectionManager ccm, HttpParams params) {
        this.delegate = new DefaultHttpClient(ccm, params){

            protected BasicHttpProcessor createHttpProcessor() {
                BasicHttpProcessor processor = super.createHttpProcessor();
                return processor;
            }

            protected HttpContext createHttpContext() {
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.authscheme-registry", (Object)this.getAuthSchemes());
                context.setAttribute("http.cookiespec-registry", (Object)this.getCookieSpecs());
                context.setAttribute("http.auth.credentials-provider", (Object)this.getCredentialsProvider());
                return context;
            }
        };
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.delegate.execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.delegate.execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.delegate.execute(target, request);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.delegate.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(target, request, responseHandler, context);
    }

    @Override
    public void setBasicAuthenticateToRequest() throws SocialClientLibException {
        if (this.delegate == null) {
            return;
        }
        if (SocialClientContext.getUsername() == null || SocialClientContext.getPassword() == null) {
            throw new SocialClientLibException("401 Unauthorized", new UnAuthenticatedException());
        }
        this.delegate.getCredentialsProvider().setCredentials(new AuthScope(SocialClientContext.getHost(), SocialClientContext.getPort()), (Credentials)new UsernamePasswordCredentials(SocialClientContext.getUsername(), SocialClientContext.getPassword()));
        this.delegate.addRequestInterceptor(this.preemptiveAuthInterceptor, 0);
    }
}

