/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.common.RealtimeListAccess;
import org.exoplatform.social.client.api.model.RestActivity;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.net.SocialHttpClientException;
import org.exoplatform.social.client.api.service.ActivityService;
import org.exoplatform.social.client.api.service.QueryParams;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.core.model.RestActivityImpl;
import org.exoplatform.social.client.core.service.QueryParamsImpl;
import org.exoplatform.social.client.core.util.SocialHttpClientSupport;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ActivitiesRealtimeListAccessV1Alpha3
implements RealtimeListAccess<RestActivity> {
    private ActivityType activityType;
    private RestIdentity ownerIdentity;
    QueryParams queryParams = new QueryParamsImpl();
    private static final String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);

    public ActivitiesRealtimeListAccessV1Alpha3(RestIdentity ownerIdentity, ActivityType activityType, QueryParams queryParams) {
        this.ownerIdentity = ownerIdentity;
        this.activityType = activityType;
        if (queryParams != null) {
            this.queryParams.append(queryParams.get(QueryParams.NUMBER_OF_COMMENTS_PARAM));
            this.queryParams.append(queryParams.get(QueryParams.NUMBER_OF_LIKES_PARAM));
        }
    }

    @Override
    public int getNumberOfNewer(RestActivity baseElement) {
        return 0;
    }

    @Override
    public int getNumberOfOlder(RestActivity baseElement) {
        return 0;
    }

    @Override
    public boolean hasNewer(RestActivity baseElement) throws SocialClientLibException {
        return this.loadNewerAsList(baseElement, 1).size() > 0;
    }

    @Override
    public boolean hasOlder(RestActivity baseElement) throws SocialClientLibException {
        return this.loadOlderAsList(baseElement, 1).size() > 0;
    }

    public RestActivity[] loadNewer(RestActivity baseElement, int limit) throws SocialClientLibException {
        return this.convertListToArray(this.loadNewerAsList(baseElement, limit), RestActivity.class);
    }

    @Override
    public List<RestActivity> loadNewerAsList(RestActivity baseElement, int limit) throws SocialClientLibException {
        String requestURL = null;
        HttpResponse response = null;
        this.queryParams.append(QueryParams.LIMIT_PARAM.setValue(limit));
        this.queryParams.append(QueryParams.SINCE_ID_PARAM.setValue(baseElement.getId()));
        switch (this.activityType) {
            case ACTIVITY_STREAM: {
                requestURL = BASE_URL + "activity_stream/" + this.ownerIdentity.getId() + ".json?" + this.queryParams.buildQuery();
                break;
            }
            case ACTIVITY_FEED: {
                requestURL = BASE_URL + "activity_stream/feed.json?" + this.queryParams.buildQuery();
                break;
            }
            case CONNECTIONS_ACTIVITIES: {
                requestURL = BASE_URL + "activity_stream/connections.json?" + this.queryParams.buildQuery();
                break;
            }
            case USER_SPACE_ACTIVITIES: {
                requestURL = BASE_URL + "activity_stream/spaces.json?" + this.queryParams.buildQuery();
            }
        }
        this.queryParams.remove(QueryParams.LIMIT_PARAM);
        this.queryParams.remove(QueryParams.SINCE_ID_PARAM);
        try {
            response = SocialHttpClientSupport.executeGet(requestURL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return this.getListActivitiesFromResponse(response);
    }

    public RestActivity[] loadOlder(RestActivity baseElement, int limit) throws SocialClientLibException {
        return this.convertListToArray(this.loadOlderAsList(baseElement, limit), RestActivity.class);
    }

    @Override
    public List<RestActivity> loadOlderAsList(RestActivity baseElement, int limit) throws SocialClientLibException {
        String requestURL = null;
        HttpResponse response = null;
        this.queryParams.append(QueryParams.LIMIT_PARAM.setValue(limit));
        this.queryParams.append(QueryParams.MAX_ID_PARAM.setValue(baseElement.getId()));
        switch (this.activityType) {
            case ACTIVITY_STREAM: {
                requestURL = BASE_URL + "activity_stream/" + this.ownerIdentity.getId() + ".json?" + this.queryParams.buildQuery();
                break;
            }
            case ACTIVITY_FEED: {
                requestURL = BASE_URL + "activity_stream/feed.json?" + this.queryParams.buildQuery();
                break;
            }
            case CONNECTIONS_ACTIVITIES: {
                requestURL = BASE_URL + "activity_stream/connections.json?" + this.queryParams.buildQuery();
                break;
            }
            case USER_SPACE_ACTIVITIES: {
                requestURL = BASE_URL + "activity_stream/spaces.json?" + this.queryParams.buildQuery();
            }
        }
        this.queryParams.remove(QueryParams.LIMIT_PARAM);
        this.queryParams.remove(QueryParams.MAX_ID_PARAM);
        try {
            response = SocialHttpClientSupport.executeGet(requestURL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return this.getListActivitiesFromResponse(response);
    }

    @Override
    public int getSize() {
        return 0;
    }

    public RestActivity[] load(int index, int limit) throws SocialClientLibException {
        return this.convertListToArray(this.loadAsList(index, limit), RestActivity.class);
    }

    @Override
    public List<RestActivity> loadAsList(int index, int limit) throws SocialClientLibException {
        String requestURL = null;
        HttpResponse response = null;
        switch (this.activityType) {
            case ACTIVITY_STREAM: {
                requestURL = BASE_URL + "activity_stream/" + this.ownerIdentity.getId() + ".json?limit=" + limit;
                break;
            }
            case ACTIVITY_FEED: {
                requestURL = BASE_URL + "activity_stream/feed.json?limit=" + limit;
                break;
            }
            case CONNECTIONS_ACTIVITIES: {
                requestURL = BASE_URL + "activity_stream/connections.json?limit=" + limit;
                break;
            }
            case USER_SPACE_ACTIVITIES: {
                requestURL = BASE_URL + "activity_stream/spaces.json?limit=" + limit;
            }
        }
        try {
            response = SocialHttpClientSupport.executeGet(requestURL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        return this.getListActivitiesFromResponse(response);
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public RestIdentity getOwnerIdentity() {
        return this.ownerIdentity;
    }

    public void setOwnerIdentity(RestIdentity ownerIdentity) {
        this.ownerIdentity = ownerIdentity;
    }

    private List<RestActivity> getListActivitiesFromResponse(HttpResponse response) {
        try {
            JSONObject jsonObject = (JSONObject)JSONValue.parse((String)SocialHttpClientSupport.getContent(response));
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"activities");
            List<RestActivityImpl> activities = SocialJSONDecodingSupport.JSONArrayObjectParser(RestActivityImpl.class, jsonArray.toJSONString());
            ArrayList<RestActivity> copyRestActivities = new ArrayList<RestActivity>(activities);
            Collections.copy(copyRestActivities, activities);
            return copyRestActivities;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityService.class, "invalid response", null);
        }
    }

    private <T> T[] convertListToArray(List<T> list, Class<T> type) {
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static enum ActivityType {
        ACTIVITY_FEED,
        ACTIVITY_STREAM,
        CONNECTIONS_ACTIVITIES,
        USER_SPACE_ACTIVITIES;

    }
}

