/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.event.CRUDLifecycle;
import org.exoplatform.social.client.api.event.CRUDLifecycleListener;
import org.exoplatform.social.client.api.event.Lifecycle;
import org.exoplatform.social.client.api.event.LifecycleException;
import org.exoplatform.social.client.api.event.LifecycleListener;
import org.exoplatform.social.client.api.service.Service;
import org.exoplatform.social.client.core.util.CRUDLifecycleSupport;
import org.exoplatform.social.client.core.util.LifecycleSupport;

public abstract class ServiceBase<M, S>
implements Service<M>,
CRUDLifecycle<M>,
Lifecycle<M, S> {
    protected boolean started = false;
    protected LifecycleSupport<M, S> lifecycle = new LifecycleSupport(this);
    protected CRUDLifecycleSupport<M> crudLifecycle = new CRUDLifecycleSupport(this);

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.lifecycle.broadcastEvent("before_start", null);
        this.started = true;
        this.lifecycle.broadcastEvent("start", null);
        this.lifecycle.broadcastEvent("after_start", null);
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.broadcastEvent("before_stop", null);
        this.lifecycle.broadcastEvent("stop", null);
        this.started = false;
        this.lifecycle.broadcastEvent("after_stop", null);
    }

    @Override
    public void addLifecycleListener(LifecycleListener<M, S> listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener<M, S> listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public LifecycleListener<M, S>[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void addCRUDLifecycleListener(CRUDLifecycleListener<M> listener) {
        this.crudLifecycle.addCRUDLifecycleListener(listener);
    }

    @Override
    public void removeCRUDLifecycleListener(CRUDLifecycleListener<M> listener) {
        this.crudLifecycle.removeCRUDLifecycleListener(listener);
    }

    @Override
    public CRUDLifecycleListener<M>[] findCRUDLifecycleListeners() {
        return this.crudLifecycle.findCRUDLifecycleListeners();
    }

    public final void doCreate(M newInstance) throws SocialClientLibException {
        this.preCreate(newInstance);
        this.create(newInstance);
        this.postCreate(newInstance);
    }

    public void preCreate(M newInstance) throws SocialClientLibException {
        this.crudLifecycle.broadcastEvent("before_create", newInstance);
    }

    public void postCreate(M newInstance) throws SocialClientLibException {
        this.crudLifecycle.broadcastEvent("after_create", newInstance);
    }

    public final void doDelete(M existingInstance) throws SocialClientLibException {
        this.preDelete(existingInstance);
        this.delete(existingInstance);
        this.postDelete(existingInstance);
    }

    public void preDelete(M existingInstance) throws SocialClientLibException {
        this.crudLifecycle.broadcastEvent("before_delete", existingInstance);
    }

    public void postDelete(M existingInstance) throws SocialClientLibException {
        this.crudLifecycle.broadcastEvent("after_delete", existingInstance);
    }

    public final void doUpdate(M existingInstance) throws SocialClientLibException {
        this.preUpdate(existingInstance);
        this.update(existingInstance);
        this.postUpdate(existingInstance);
    }

    public void preUpdate(M existingInstance) throws SocialClientLibException {
        this.crudLifecycle.broadcastEvent("before_update", existingInstance);
    }

    public void postUpdate(M existingInstance) throws SocialClientLibException {
        this.crudLifecycle.broadcastEvent("after_update", existingInstance);
    }
}

