/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.model.Node;

public class XMLBalancerFilterPlugin
extends BaseXMLFilterPlugin {
    public Object doFilter(Object input) {
        if (input instanceof String) {
            input = this.createDOMTree((String)input).toString();
        }
        return input;
    }

    private Node createDOMTree(String xmlString) {
        Node rootNode;
        Node parsingNode = rootNode = new Node();
        Node currentNode = rootNode;
        List<String> xmlTokens = Tokenizer.tokenize(xmlString);
        for (String token : xmlTokens) {
            String tag;
            Matcher startMatcher = DOMParser.TAGSTARTPATTERN.matcher(token);
            Matcher endMatcher = DOMParser.TAGCLOSEPATTERN.matcher(token);
            if (DOMParser.COMMENTPATTERN.matcher(token).find()) {
                parsingNode = new Node();
                parsingNode.setParentNode(currentNode);
                currentNode.addChildNode(parsingNode);
                parsingNode.setTitle(token);
                continue;
            }
            if (startMatcher.find()) {
                tag = startMatcher.group(1).toLowerCase();
                parsingNode = new Node();
                parsingNode.setParentNode(currentNode);
                parsingNode.setTitle(tag);
                String tokenBody = startMatcher.group(2);
                Matcher attributes = DOMParser.ATTRIBUTESPATTERN.matcher(tokenBody);
                while (attributes.find()) {
                    String attr = attributes.group(1).toLowerCase();
                    String val = attributes.group(4) == null ? attributes.group(3) : attributes.group(4);
                    parsingNode.addAttribute(attr, val);
                }
                currentNode.addChildNode(parsingNode);
                if (DOMParser.SELFTCLOSETAGPATTERN.matcher(token).find()) continue;
                currentNode = parsingNode;
                continue;
            }
            if (endMatcher.find()) {
                tag = endMatcher.group(1).toLowerCase();
                Node searchOpenedNode = currentNode;
                while (!searchOpenedNode.getTitle().equals(tag) && searchOpenedNode.getParentNode() != null) {
                    searchOpenedNode = searchOpenedNode.getParentNode();
                }
                if (searchOpenedNode.getParentNode() == null) {
                    Node invalidNode = new Node();
                    invalidNode.setContent(StringEscapeUtils.escapeHtml((String)token));
                    currentNode.addChildNode(invalidNode);
                    continue;
                }
                if (searchOpenedNode.getTitle().equals(currentNode.getTitle())) {
                    currentNode = currentNode.getParentNode();
                    continue;
                }
                currentNode = searchOpenedNode.getParentNode();
                continue;
            }
            parsingNode = new Node();
            parsingNode.setParentNode(currentNode);
            parsingNode.setContent(StringEscapeUtils.escapeHtml((String)token));
            currentNode.addChildNode(parsingNode);
        }
        return rootNode;
    }
}

