/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial;

import java.io.File;
import java.io.IOException;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.util.TimeSource;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.gadget.core.SecurityTokenGenerator;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.web.application.RequestContext;

public class ExoSocialSecurityTokenGenerator
implements SecurityTokenGenerator {
    private String containerKey = "key.txt";
    private final TimeSource timeSource = new TimeSource();

    protected String createToken(String gadgetURL, String owner, String viewer, Long moduleId, String container) {
        try {
            BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(this.getBlobCrypter(this.containerKey), container, null);
            t.setAppUrl(gadgetURL);
            t.setModuleId(moduleId.longValue());
            t.setOwnerId(owner);
            t.setViewerId(viewer);
            t.setTrustedJson("trusted");
            return t.encrypt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BlobCrypterException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String createToken(String gadgetURL, Long moduleId) {
        RequestContext context = RequestContext.getCurrentInstance();
        String rUserId = this.getIdentityId(context.getRemoteUser());
        PortalRequestContext request = Util.getPortalRequestContext();
        String uri = request.getNodePath();
        String[] els = uri.split("/");
        String ownerId = rUserId;
        if (els.length >= 3 && els[1].equals("people")) {
            ownerId = this.getIdentityId(els[2]);
        }
        return this.createToken(gadgetURL, ownerId, rUserId, moduleId, "default");
    }

    protected String getIdentityId(String remoteId) {
        PortalContainer pc = PortalContainer.getInstance();
        IdentityManager im = (IdentityManager)pc.getComponentInstanceOfType(IdentityManager.class);
        Identity id = null;
        try {
            id = im.getIdentityByRemoteId("organization", remoteId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (id != null) {
            return id.getId();
        }
        return null;
    }

    private BlobCrypter getBlobCrypter(String fileName) throws IOException {
        BasicBlobCrypter c = new BasicBlobCrypter(new File(fileName));
        c.timeSource = this.timeSource;
        return c;
    }
}

