/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.spi;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.RelationshipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoService {
    protected Set<Identity> getIdSet(UserId user, GroupId group, SecurityToken token) throws Exception {
        String userId = user.getUserId(token);
        Identity id = this.getIdentity(userId);
        LinkedHashSet returnVal = Sets.newLinkedHashSet();
        if (group == null) {
            returnVal.add(id);
        } else {
            switch (group.getType()) {
                case all: 
                case friends: 
                case groupId: {
                    returnVal.addAll(this.getFriendsList(id));
                    break;
                }
                case self: {
                    returnVal.add(id);
                }
            }
        }
        return returnVal;
    }

    protected List<Identity> getFriendsList(Identity id) throws Exception {
        PortalContainer pc = PortalContainer.getInstance();
        RelationshipManager rm = (RelationshipManager)pc.getComponentInstanceOfType(RelationshipManager.class);
        List rels = rm.getContacts(id);
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (Relationship rel : rels) {
            if (rel.getIdentity1().getId().equals(id.getId())) {
                ids.add(rel.getIdentity2());
                continue;
            }
            ids.add(rel.getIdentity1());
        }
        return ids;
    }

    protected Set<Identity> getIdSet(Set<UserId> users, GroupId group, SecurityToken token) throws Exception {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (UserId user : users) {
            ids.addAll(this.getIdSet(user, group, token));
        }
        return ids;
    }

    protected Identity getIdentity(String id) throws Exception {
        PortalContainer pc = PortalContainer.getInstance();
        IdentityManager im = (IdentityManager)pc.getComponentInstanceOfType(IdentityManager.class);
        Identity identity = im.getIdentityById(id);
        if (identity == null) {
            throw new ProtocolException(400, "this user does not exist");
        }
        return identity;
    }
}

