/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.opensocial.model.ServiceProviderData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderStore {
    public static final String SHARED_SECRET = "sharedSecret";
    public static final String CONSUMER_KEY = "consumerKey";
    public static final String CALLBACK_URL = "callbackUrl";
    private static Log log = ExoLogger.getExoLogger(ServiceProviderStore.class);
    private Map<String, ServiceProviderData> providers = new HashMap<String, ServiceProviderData>();

    public ServiceProviderStore(InitParams params) {
        try {
            if (params == null) {
                return;
            }
            Iterator it = params.getPropertiesParamIterator();
            while (it.hasNext()) {
                PropertiesParam propertiesParam = (PropertiesParam)it.next();
                String name = propertiesParam.getName();
                String description = propertiesParam.getDescription();
                String consumerKey = propertiesParam.getProperty(CONSUMER_KEY);
                String sharedSecret = propertiesParam.getProperty(SHARED_SECRET);
                String callbackUrl = propertiesParam.getProperty(CALLBACK_URL);
                ServiceProviderData provider = new ServiceProviderData(name, description, consumerKey, sharedSecret, callbackUrl);
                this.providers.put(consumerKey, provider);
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to initialize properties from init-params", (Throwable)e);
        }
    }

    public ServiceProviderData getServiceProvider(String consumerKey) {
        return this.providers.get(consumerKey);
    }

    public void setProviders(Map<String, ServiceProviderData> providers) {
        this.providers = providers;
    }
}

