/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.service;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.UrlImpl;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Url;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.opensocial.auth.ExoBlobCrypterSecurityToken;
import org.exoplatform.social.opensocial.model.ExoPersonImpl;
import org.exoplatform.social.opensocial.model.Space;
import org.exoplatform.social.opensocial.model.SpaceImpl;
import org.exoplatform.social.opensocial.service.ExoService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoPeopleService
extends ExoService
implements PersonService,
AppDataService {
    private Injector injector;
    private static final Comparator<Person> NAME_COMPARATOR = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person1) {
            String name = person.getName().getFormatted();
            String name1 = person1.getName().getFormatted();
            return name.compareTo(name1);
        }
    };

    @Inject
    public ExoPeopleService(Injector injector) {
        this.injector = injector;
    }

    public Future<RestfulCollection<Person>> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions collectionOptions, Set<String> fields, SecurityToken token) throws ProtocolException {
        List result = Lists.newArrayList();
        try {
            Set<Identity> idSet = this.getIdSet(userIds, groupId, token);
            for (Identity id : idSet) {
                if (id == null) continue;
                result.add(this.convertToPerson(id, fields, token));
            }
            if (collectionOptions.getSortBy().equals(Person.Field.NAME.toString())) {
                Collections.sort(result, NAME_COMPARATOR);
            }
            if (collectionOptions.getSortOrder().equals((Object)SortOrder.descending)) {
                Collections.reverse(result);
            }
            int totalSize = result.size();
            int last = collectionOptions.getFirst() + collectionOptions.getMax();
            result = result.subList(collectionOptions.getFirst(), Math.min(last, totalSize));
            return ImmediateFuture.newInstance((Object)new RestfulCollection(result, collectionOptions.getFirst(), totalSize));
        }
        catch (Exception je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    public Future<Person> getPerson(UserId id, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            if (token instanceof AnonymousSecurityToken) {
                throw new Exception(Integer.toString(403));
            }
            Identity identity = this.getIdentity(id.getUserId(token), true, token);
            return ImmediateFuture.newInstance((Object)this.convertToPerson(identity, fields, token));
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
    }

    private Person convertToPerson(Identity identity, Set<String> fields, SecurityToken st) throws Exception {
        ExoPersonImpl p = new ExoPersonImpl();
        Profile pro = identity.getProfile();
        PortalContainer container = this.getPortalContainer(st);
        String host = this.getHost(st);
        for (String field : fields) {
            if (Person.Field.DISPLAY_NAME.toString().equals(field)) {
                p.setDisplayName(pro.getFullName());
                continue;
            }
            if (Person.Field.EMAILS.toString().equals(field)) {
                p.setEmails(this.convertToListFields((List)pro.getProperty("emails")));
                continue;
            }
            if (Person.Field.URLS.toString().equals(field)) {
                p.setUrls(this.convertToURLListFields((List)pro.getProperty("urls")));
                continue;
            }
            if (Person.Field.IMS.toString().equals(field)) {
                p.setIms(this.convertToListFields((List)pro.getProperty("ims")));
                continue;
            }
            if (Person.Field.ID.toString().equals(field)) {
                p.setId(identity.getId());
                continue;
            }
            if (Person.Field.NAME.toString().equals(field)) {
                NameImpl name = new NameImpl();
                name.setFamilyName((String)pro.getProperty("lastName"));
                name.setGivenName((String)pro.getProperty("firstName"));
                name.setFormatted(name.getGivenName() + " " + name.getFamilyName());
                p.setName((Name)name);
                continue;
            }
            if (Person.Field.PROFILE_URL.toString().equals(field)) {
                String portalOwner = this.getPortalOwner(st);
                String portalName = this.getPortalContainer(st).getName();
                p.setProfileUrl(LinkProvider.getAbsoluteProfileUrl((String)identity.getRemoteId(), (String)portalName, (String)portalOwner, (String)host));
                continue;
            }
            if (Person.Field.GENDER.toString().equals(field)) {
                String gender = (String)pro.getProperty("gender");
                if (gender != null && gender.equals("female")) {
                    p.setGender(Person.Gender.female);
                    continue;
                }
                p.setGender(Person.Gender.male);
                continue;
            }
            if (ExoPersonImpl.Field.SPACES.toString().equals(field)) {
                ArrayList<Space> spaces = new ArrayList<Space>();
                SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
                try {
                    List allSpaces = spaceService.getAllSpaces();
                    SpaceImpl space = new SpaceImpl();
                    for (org.exoplatform.social.core.space.model.Space obj : allSpaces) {
                        if (!spaceService.isMember(obj, identity.getRemoteId())) continue;
                        space.setId(obj.getId());
                        space.setDisplayName(obj.getName());
                        spaces.add(space);
                    }
                    p.setSpaces(spaces);
                }
                catch (SpaceException e) {}
                continue;
            }
            if (Person.Field.THUMBNAIL_URL.toString().equals(field)) {
                p.setThumbnailUrl(host + pro.getAvatarUrl());
                continue;
            }
            if (ExoPersonImpl.Field.PORTAL_CONTAINER.toString().equals(field)) {
                p.setPortalName(container.getName());
                continue;
            }
            if (ExoPersonImpl.Field.REST_CONTEXT.toString().equals(field)) {
                p.setRestContextName(container.getRestContextName());
                continue;
            }
            if (!ExoPersonImpl.Field.HOST.toString().equals(field)) continue;
            p.setHostName(this.getHost(st));
        }
        return p;
    }

    private String getRestContext(SecurityToken st) {
        return this.getPortalContainer(st).getRestContextName();
    }

    private List<ListField> convertToListFields(List<Map> fields) {
        ArrayList<ListField> l = new ArrayList<ListField>();
        if (fields == null) {
            return null;
        }
        for (Map field : fields) {
            l.add((ListField)new ListFieldImpl((String)field.get("key"), (String)field.get("value")));
        }
        return l;
    }

    private List<Url> convertToURLListFields(List<Map> fields) {
        ArrayList<Url> l = new ArrayList<Url>();
        if (fields == null) {
            return null;
        }
        for (Map field : fields) {
            l.add((Url)new UrlImpl((String)field.get("value"), (String)field.get("key"), (String)field.get("key")));
        }
        return l;
    }

    public Future<DataCollection> getPersonData(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            Set<Identity> idSet = this.getIdSet(userIds, groupId, token);
            HashMap<String, Map<String, String>> idToData = new HashMap<String, Map<String, String>>();
            Iterator<Identity> it = idSet.iterator();
            String gadgetId = this.clean(appId);
            String instanceId = "" + token.getModuleId();
            while (it.hasNext()) {
                Identity id = it.next();
                idToData.put(id.getId(), this.getPreferences(id.getRemoteId(), gadgetId, instanceId, fields));
            }
            return ImmediateFuture.newInstance((Object)new DataCollection(idToData));
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
    }

    private String clean(String url) {
        url = URLEncoder.encode(url);
        url = url.replaceAll(":", "");
        return url;
    }

    private Map<String, String> getPreferences(String userID, String gadgetId, String instanceID, Set<String> fields) throws Exception {
        Map<String, String> values = null;
        return values;
    }

    private void savePreferences(String userID, String gadgetId, String instanceID, Map<String, String> values) throws Exception {
    }

    private void deletePreferences(String userID, String gadgetId, String instanceID, Set<String> keys) throws Exception {
    }

    public Future<Void> deletePersonData(UserId user, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            if (token instanceof AnonymousSecurityToken) {
                throw new Exception(Integer.toString(403));
            }
            String userId = user.getUserId(token);
            String portalName = PortalContainer.getCurrentPortalContainerName();
            if (token instanceof ExoBlobCrypterSecurityToken) {
                portalName = ((ExoBlobCrypterSecurityToken)token).getPortalContainer();
            }
            Identity id = this.getIdentity(userId, true, token);
            String gadgetId = this.clean(appId);
            String instanceId = "" + token.getModuleId();
            this.deletePreferences(id.getRemoteId(), gadgetId, instanceId, fields);
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }

    public Future<Void> updatePersonData(UserId user, GroupId groupId, String appId, Set<String> fields, Map<String, String> values, SecurityToken token) throws ProtocolException {
        try {
            if (token instanceof AnonymousSecurityToken) {
                throw new Exception(Integer.toString(403));
            }
            String userId = user.getUserId(token);
            Identity id = this.getIdentity(userId, true, token);
            String gadgetId = this.clean(appId);
            String instanceId = "" + token.getModuleId();
            this.savePreferences(id.getRemoteId(), gadgetId, instanceId, values);
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }

    private String getRepository(SecurityToken st) throws Exception {
        PortalContainer pContainer = this.getPortalContainer(st);
        RepositoryService rService = (RepositoryService)pContainer.getComponentInstanceOfType(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }
}

