/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.auth;

import java.util.Map;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoBlobCrypterSecurityToken
extends BlobCrypterSecurityToken {
    protected static final String PORTAL_CONTAINER_KEY = "p";
    protected static final String HOST_NAME = "h";
    protected static final String PORTAL_OWNER_KEY = "w";
    protected String portalContainer;
    private String hostName;
    private String portalOwner;

    public ExoBlobCrypterSecurityToken(BlobCrypter crypter, String container, String domain) {
        super(crypter, container, domain);
    }

    public String getPortalContainer() {
        return this.portalContainer;
    }

    public void setPortalContainer(String portalContainer) {
        this.portalContainer = portalContainer;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPortalOwner() {
        return this.portalOwner;
    }

    public void setPortalOwner(String portalOwner) {
        this.portalOwner = portalOwner;
    }

    protected Map<String, String> buildValuesMap() {
        Map map = super.buildValuesMap();
        if (this.portalContainer != null) {
            map.put(PORTAL_CONTAINER_KEY, this.portalContainer);
        }
        if (this.hostName != null) {
            map.put(HOST_NAME, this.hostName);
        }
        if (this.portalOwner != null) {
            map.put(PORTAL_OWNER_KEY, this.portalOwner);
        }
        return map;
    }

    static BlobCrypterSecurityToken decrypt(BlobCrypter crypter, String container, String domain, String token, String activeUrl) throws BlobCrypterException {
        Map values = crypter.unwrap(token, 3600);
        ExoBlobCrypterSecurityToken t = new ExoBlobCrypterSecurityToken(crypter, container, domain);
        t.setOwnerId((String)values.get("o"));
        t.setViewerId((String)values.get("v"));
        t.setAppUrl((String)values.get("g"));
        String moduleId = (String)values.get("i");
        if (moduleId != null) {
            t.setModuleId(Long.parseLong(moduleId));
        }
        t.setTrustedJson((String)values.get("j"));
        t.setPortalContainer((String)values.get(PORTAL_CONTAINER_KEY));
        t.setActiveUrl(activeUrl);
        t.setHostName((String)values.get(HOST_NAME));
        t.setPortalOwner((String)values.get(PORTAL_OWNER_KEY));
        return t;
    }
}

