/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.impl.organization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.JCRStorage;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationIdentityProvider
extends IdentityProvider {
    private JCRStorage storage;
    private OrganizationService organizationService;
    public static final String NAME = "organization";
    private Map<String, User> userCache = new HashMap<String, User>();

    public OrganizationIdentityProvider(JCRStorage storage, OrganizationService organizationService) {
        this.storage = storage;
        PortalContainer container = PortalContainer.getInstance();
        this.organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Identity getIdentityByRemoteId(Identity identity) throws Exception {
        User user = null;
        String remote = identity.getRemoteId();
        user = this.getUserFromCache(remote);
        if (user == null) {
            try {
                UserHandler userHandler = this.organizationService.getUserHandler();
                user = userHandler.findUserByName(remote);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (user == null) {
            return null;
        }
        this.addUserToCache(user);
        this.loadIdentity(user, identity);
        return identity;
    }

    private Identity loadIdentity(User user, Identity identity) throws Exception {
        Profile profile = identity.getProfile();
        profile.setProperty("firstName", user.getFirstName());
        profile.setProperty("lastName", user.getLastName());
        profile.setProperty("username", user.getUserName());
        this.storage.loadProfile(profile);
        if (user.getEmail() != null && !profile.contains("emails")) {
            ArrayList emails = new ArrayList();
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("key", "work");
            email.put("value", user.getEmail());
            emails.add(email);
            profile.setProperty("emails", emails);
        }
        return identity;
    }

    @Override
    public void saveProfile(Profile p) throws Exception {
        this.storage.saveProfile(p);
    }

    @Override
    public List<String> getAllUserId() throws Exception {
        PageList pl = this.organizationService.getUserHandler().getUserPageList(20);
        List userList = pl.getAll();
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : userList) {
            userIds.add(user.getUserName());
        }
        return userIds;
    }

    private User getUserFromCache(String userName) {
        return this.userCache.get(userName);
    }

    private void addUserToCache(User user) {
        if (this.getUserFromCache(user.getUserName()) == null) {
            this.userCache.put(user.getUserName(), user);
        }
    }

    private void refreshCache() {
        this.userCache.clear();
    }
}

