/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activitystream;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.jcr.JCRSessionManager;
import org.exoplatform.social.jcr.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRStorage {
    private static final Log LOG = ExoLogger.getLogger(JCRStorage.class);
    private static final String PUBLISHED_NODE = "published".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String ACTIVITY_NODETYPE = "exo:activity".intern();
    private static final String BODY = "exo:body".intern();
    private static final String BODY_TEMPLATE = "exo:bodyTemplate".intern();
    private static final String EXTERNAL_ID = "exo:externalId".intern();
    private static final String ID = "exo:id".intern();
    private static final String UPDATED_TIMESTAMP = "exo:updatedTimestamp".intern();
    private static final String POSTED_TIME = "exo:postedTime".intern();
    private static final String PRIORITY = "exo:priority".intern();
    private static final String TITLE = "exo:title".intern();
    private static final String TITLE_TEMPLATE = "exo:titleTemplate".intern();
    private static final String URL = "exo:url".intern();
    private static final String USER_ID = "exo:userId".intern();
    private static final String TYPE = "exo:type".intern();
    private static final String REPLY_TO_ID = "exo:replyToId".intern();
    private static final String HIDDEN = "exo:hidden".intern();
    private static final String LIKE_IDENTITY_IDS = "exo:likeIdentityIds".intern();
    private static final String PARAMS = "exo:params";
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;

    public JCRStorage(SocialDataLocation dataLocation) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
    }

    private Node getActivityServiceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialActivitiesHome();
        return session.getRootNode().getNode(path);
    }

    private Node getStreamLocation(Identity owner) {
        String type = owner.getProviderId();
        String id = owner.getRemoteId();
        if (type != null && id != null) {
            return this.getStreamsLocationByType(type, id);
        }
        LOG.warn((Object)("attempting to get a stream for non prefixed owner : " + id));
        return this.getStreamsLocationByType("default", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getStreamsLocationByType(String type, String username) {
        Session session = this.sessionManager.openSession();
        try {
            Node activityHomeNode = this.getActivityServiceHome(session);
            Node typeHome = null;
            if (activityHomeNode.hasNode(type)) {
                typeHome = activityHomeNode.getNode(type);
            } else {
                typeHome = activityHomeNode.addNode(type, NT_UNSTRUCTURED);
                activityHomeNode.save();
            }
            if (typeHome.hasNode(username)) {
                Node node = typeHome.getNode(username);
                return node;
            }
            Node streamNode = typeHome.addNode(username, NT_UNSTRUCTURED);
            typeHome.save();
            Node node = streamNode;
            return node;
        }
        catch (Exception e) {
            LOG.error((Object)("failed to locate stream owner node for " + username), (Throwable)e);
            Node node = null;
            return node;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    private Node getPublishedActivityServiceHome(Identity owner) {
        try {
            Node userActivityHomeNode = this.getStreamLocation(owner);
            try {
                return userActivityHomeNode.getNode(PUBLISHED_NODE);
            }
            catch (PathNotFoundException ex) {
                Node appNode = userActivityHomeNode.addNode(PUBLISHED_NODE, NT_UNSTRUCTURED);
                appNode.addMixin("mix:referenceable");
                userActivityHomeNode.save();
                return appNode;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get published activity service location for " + owner), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity save(Identity owner, Activity activity) throws Exception {
        LOG.info((Object)("storing activity for owner " + owner + " by " + activity.getUserId()));
        Validate.notNull((Object)activity.getUpdated(), (String)"Activity.getUpdated() must not be null.");
        Validate.notNull((Object)activity.getPostedTime(), (String)"Activity.getPostedTime() must not be null.");
        Validate.notNull((Object)activity.getTitle(), (String)"Activity.getTitle() must not be null.");
        Node activityHomeNode = this.getPublishedActivityServiceHome(owner);
        try {
            Node activityNode;
            Session session = this.sessionManager.openSession();
            if (activity.getId() == null) {
                activityNode = activityHomeNode.addNode(ACTIVITY_NODETYPE, ACTIVITY_NODETYPE);
                activityNode.addMixin("mix:referenceable");
            } else {
                activityNode = session.getNodeByUUID(activity.getId());
            }
            this.setStreamInfo(activity, activityNode);
            activityNode.setProperty(TITLE, activity.getTitle());
            if (activity.getTitleId() != null) {
                activityNode.setProperty(TITLE_TEMPLATE, activity.getTitleId());
            }
            activityNode.setProperty(UPDATED_TIMESTAMP, activity.getUpdatedTimestamp().longValue());
            activityNode.setProperty(POSTED_TIME, activity.getPostedTime().longValue());
            if (activity.getBody() != null) {
                activityNode.setProperty(BODY, activity.getBody());
            }
            if (activity.getExternalId() != null) {
                activityNode.setProperty(EXTERNAL_ID, activity.getExternalId());
            }
            if (activity.getPriority() != null) {
                activityNode.setProperty(PRIORITY, (double)activity.getPriority().floatValue());
            }
            if (activity.getTitle() != null) {
                activityNode.setProperty(TITLE, activity.getTitle());
            }
            if (activity.getUserId() != null) {
                activityNode.setProperty(USER_ID, activity.getUserId());
            }
            if (activity.getType() != null) {
                activityNode.setProperty(TYPE, activity.getType());
            }
            if (activity.getReplyToId() != null) {
                activityNode.setProperty(REPLY_TO_ID, activity.getReplyToId());
            }
            if (activity.getUrl() != null) {
                activityNode.setProperty(URL, activity.getUrl());
            }
            activityNode.setProperty(LIKE_IDENTITY_IDS, activity.getLikeIdentityIds());
            activityNode.setProperty(HIDDEN, activity.isHidden());
            activityNode.setProperty(TITLE_TEMPLATE, activity.getTitleId());
            activityNode.setProperty(BODY_TEMPLATE, activity.getBodyId());
            activityNode.setProperty(PARAMS, this.mapToArray(activity.getTemplateParams()));
            if (activity.getId() == null) {
                activityHomeNode.save();
                activity.setId(activityNode.getUUID());
            } else {
                activityNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save activity", (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activity;
    }

    private void setStreamInfo(Activity activity, Node activityNode) throws Exception {
        try {
            activity.setStreamOwner(activityNode.getParent().getParent().getName());
            activity.setStreamId(activityNode.getParent().getUUID());
        }
        catch (UnsupportedRepositoryOperationException e) {
            activityNode.getParent().addMixin("mix:referenceable");
            activity.setStreamId(activityNode.getParent().getUUID());
        }
    }

    private String[] mapToArray(Map<String, String> templateParams) {
        if (templateParams == null) {
            return null;
        }
        Set<String> keys = templateParams.keySet();
        String[] result = new String[keys.size()];
        int i = 0;
        for (String key : keys) {
            result[i++] = key + "=" + templateParams.get(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteActivity(String activityId) throws Exception {
        this.deleteActivityComments(activityId);
        Session session = this.sessionManager.openSession();
        Node activityNode = null;
        try {
            activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                activityNode.remove();
                session.save();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to delete activity", (Throwable)ex);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity load(String activityId) {
        Session session = this.sessionManager.openSession();
        try {
            Node activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                Activity activity = this.load(activityNode);
                return activity;
            }
        }
        catch (Exception e) {
            Activity activity = null;
            return activity;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    private Activity load(Node activityNode) throws Exception {
        Activity activity = new Activity();
        activity.setId(activityNode.getUUID());
        activity.setStreamId(activityNode.getParent().getUUID());
        activity.setStreamOwner(activityNode.getParent().getParent().getName());
        if (activityNode.hasProperty(BODY)) {
            activity.setBody(activityNode.getProperty(BODY).getString());
        }
        if (activityNode.hasProperty(EXTERNAL_ID)) {
            activity.setExternalId(activityNode.getProperty(EXTERNAL_ID).getString());
        }
        if (activityNode.hasProperty(HIDDEN)) {
            activity.setHidden(activityNode.getProperty(HIDDEN).getBoolean());
        }
        if (activityNode.hasProperty(POSTED_TIME)) {
            activity.setPostedTime(activityNode.getProperty(POSTED_TIME).getLong());
        }
        if (activityNode.hasProperty(PRIORITY)) {
            activity.setPriority((int)activityNode.getProperty(PRIORITY).getLong());
        }
        if (activityNode.hasProperty(TITLE)) {
            activity.setTitle(activityNode.getProperty(TITLE).getString());
        }
        if (activityNode.hasProperty(TYPE)) {
            activity.setType(activityNode.getProperty(TYPE).getString());
        }
        if (activityNode.hasProperty(REPLY_TO_ID)) {
            activity.setReplyToId(activityNode.getProperty(REPLY_TO_ID).getString());
        }
        if (activityNode.hasProperty(UPDATED_TIMESTAMP)) {
            activity.setUpdatedTimestamp(activityNode.getProperty(UPDATED_TIMESTAMP).getLong());
        }
        if (activityNode.hasProperty(URL)) {
            activity.setUrl(activityNode.getProperty(URL).getString());
        }
        if (activityNode.hasProperty(USER_ID)) {
            activity.setUserId(activityNode.getProperty(USER_ID).getString());
        }
        if (activityNode.hasProperty(LIKE_IDENTITY_IDS)) {
            activity.setLikeIdentityIds(this.ValuesToStrings(activityNode.getProperty(LIKE_IDENTITY_IDS).getValues()));
        }
        if (activityNode.hasProperty(PARAMS)) {
            activity.setTemplateParams(this.valuesToMap(activityNode.getProperty(PARAMS).getValues()));
        }
        if (activityNode.hasProperty(TITLE_TEMPLATE)) {
            activity.setTitleId(activityNode.getProperty(TITLE_TEMPLATE).getString());
        }
        if (activityNode.hasProperty(BODY_TEMPLATE)) {
            activity.setBodyId(activityNode.getProperty(BODY_TEMPLATE).getString());
        }
        return activity;
    }

    private Map<String, String> valuesToMap(Value[] values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Value value : values) {
            try {
                String val = value.getString();
                if (val.indexOf("=") <= 0) continue;
                result.put(val.split("=")[0], val.split("=")[1]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getActivities(Identity owner, long offset, long limit) throws Exception {
        ArrayList activities = Lists.newArrayList();
        Node n = this.getPublishedActivityServiceHome(owner);
        String path = n.getPath();
        try {
            Session session = this.sessionManager.getOrOpenSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String queryStr = "select * from exo:activity where jcr:path like '" + path + "[%]/exo:activity[%]' and NOT exo:replyToId='" + "IS_COMMENT" + "' order by exo:updatedTimestamp desc";
            QueryImpl query = (QueryImpl)queryManager.createQuery(queryStr, "sql");
            query.setOffset(offset);
            query.setLimit(limit);
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                activities.add(this.load(node));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to retrieve activities for owner", (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    public List<Activity> getActivities(Identity owner) throws Exception {
        ArrayList activities = Lists.newArrayList();
        Node n = this.getPublishedActivityServiceHome(owner);
        NodeIterator nodes = n.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            if (node.hasProperty(REPLY_TO_ID)) {
                String replyToId = node.getProperty(REPLY_TO_ID).getString();
                if (replyToId.equals("IS_COMMENT")) continue;
                activities.add(this.load(node));
                continue;
            }
            activities.add(this.load(node));
        }
        return activities;
    }

    private void deleteActivityComments(String activityId) {
        Activity activity = this.load(activityId);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null) {
            if (rawCommentIds.equals("IS_COMMENT")) {
                return;
            }
            Object[] commentIds = rawCommentIds.split(",");
            for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                try {
                    this.deleteActivity((String)commentId);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Failed to delete comment actvity " + (String)commentId + ": " + ex.getMessage()));
                }
            }
        }
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }
}

