/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.SecurityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.ActivityRestIn;
import org.exoplatform.social.service.rest.api.models.ActivityRestOut;
import org.exoplatform.social.service.rest.api.models.ActivityStreamRestOut;
import org.exoplatform.social.service.rest.api.models.CommentRestIn;
import org.exoplatform.social.service.rest.api.models.CommentRestOut;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;

@Path(value="api/social/v1-alpha3/{portalContainerName}/")
public class ActivityResources
implements ResourceContainer {
    private static final String[] SUPPORTED_FORMAT = new String[]{"json"};
    private static final int MAX_NUMBER_OF_COMMENT = 100;
    private static final int MAX_NUMBER_OF_LIKE = 100;

    @GET
    @Path(value="activity/{activityId}.{format}")
    public Response getActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @QueryParam(value="poster_identity") String showPosterIdentity, @QueryParam(value="number_of_comments") int numberOfComments, @QueryParam(value="activity_stream") String showActivityStream, @QueryParam(value="number_of_likes") int numberOfLikes) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (activity.isComment()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!SecurityManager.canAccessActivity(portalContainer, ConversationState.getCurrent().getIdentity().getUserId(), activity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ActivityRestOut model = new ActivityRestOut(activity, portalContainerName);
        model.setNumberOfLikes(numberOfLikes, activity, portalContainerName);
        if (this.isPassed(showPosterIdentity)) {
            model.setPosterIdentity(new IdentityRestOut(identityManager.getIdentity(activity.getUserId(), false)));
        }
        if (this.isPassed(showActivityStream)) {
            model.setActivityStream(new ActivityStreamRestOut(activity.getActivityStream(), portalContainerName));
        }
        model.setNumberOfComments(numberOfComments, activity, portalContainerName);
        return Util.getResponse(model, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="activity.{format}")
    public Response createNewActivity(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="format") String format, @QueryParam(value="identity_id") String identityIdStream, ActivityRestIn newActivity) {
        Identity postToIdentity;
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        if (newActivity == null || newActivity.getTitle() == null || newActivity.getTitle().trim().equals("")) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedUserIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        if (identityIdStream != null && !identityIdStream.equals("")) {
            postToIdentity = identityManager.getIdentity(identityIdStream, false);
            if (postToIdentity == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        } else {
            postToIdentity = authenticatedUserIdentity;
        }
        if (!SecurityManager.canPostActivity(portalContainer, authenticatedUserIdentity, postToIdentity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(newActivity.getTitle());
        activity.setType(newActivity.getType());
        activity.setPriority(newActivity.getPriority());
        activity.setTitleId(newActivity.getTitleId());
        activity.setTemplateParams(newActivity.getTemplateParams());
        activity.setUserId(authenticatedUserIdentity.getId());
        activityManager.saveActivityNoReturn(postToIdentity, (ExoSocialActivity)activity);
        ActivityRestOut model = new ActivityRestOut((ExoSocialActivity)activity, portalContainerName);
        model.setIdentityId(postToIdentity.getId());
        return Util.getResponse(model, uriInfo, mediaType, Response.Status.OK);
    }

    @DELETE
    @Path(value="activity/{activityId}.{format}")
    public Response deleteExistingActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedUserIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity existingActivity = null;
        try {
            existingActivity = activityManager.getActivity(activityId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!SecurityManager.canDeleteActivity(portalContainer, authenticatedUserIdentity, existingActivity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        activityManager.deleteActivity(existingActivity);
        HashMap<String, String> resultJson = new HashMap<String, String>();
        resultJson.put("id", existingActivity.getId());
        return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="activity/destroy/{activityId}.{format}")
    public Response postToDeleteActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        return this.deleteExistingActivityById(uriInfo, portalContainerName, activityId, format);
    }

    @GET
    @Path(value="activity/{activityId}/comments.{format}")
    public Response getCommentsByActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
            if (!SecurityManager.canAccessActivity(portalContainer, authenticatedIdentity, activity)) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            ArrayList<CommentRestOut> commentWrapers = null;
            RealtimeListAccess comments = activityManager.getCommentsWithListAccess(activity);
            int total = comments.getSize();
            ExoSocialActivity[] commentsLimited = (ExoSocialActivity[])comments.load(0, total);
            commentWrapers = new ArrayList<CommentRestOut>(total);
            for (int i = 0; i < total; ++i) {
                CommentRestOut commentRestOut = new CommentRestOut(commentsLimited[i], portalContainerName);
                commentRestOut.setPosterIdentity(commentsLimited[i], portalContainerName);
                commentWrapers.add(commentRestOut);
            }
            HashMap<String, Serializable> resultJson = new HashMap<String, Serializable>();
            resultJson.put("totalNumberOfComments", Integer.valueOf(commentWrapers.size()));
            resultJson.put("comments", commentWrapers);
            return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="activity/{activityId}/comment.{format}")
    public Response createCommentActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, CommentRestIn comment) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        if (comment == null || comment.getText() == null || comment.getText().trim().equals("")) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!SecurityManager.canCommentToActivity(portalContainer, authenticatedIdentity, activity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ExoSocialActivityImpl commentActivity = new ExoSocialActivityImpl();
        commentActivity.setTitle(comment.getText());
        commentActivity.setUserId(authenticatedIdentity.getId());
        activityManager.saveComment(activity, (ExoSocialActivity)commentActivity);
        CommentRestOut commentOut = new CommentRestOut((ExoSocialActivity)commentActivity, portalContainerName);
        return Util.getResponse(commentOut, uriInfo, mediaType, Response.Status.OK);
    }

    @DELETE
    @Path(value="activity/{activityId}/comment/{commentId}.{format}")
    public Response deleteCommentById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @PathParam(value="commentId") String commentId) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity commentActivity = null;
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
            commentActivity = activityManager.getActivity(commentId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!commentActivity.isComment()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!SecurityManager.canDeleteActivity(portalContainer, authenticatedIdentity, commentActivity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        activityManager.deleteComment(activity, commentActivity);
        HashMap<String, String> resultHashmap = new HashMap<String, String>();
        resultHashmap.put("id", commentActivity.getId());
        return Util.getResponse(resultHashmap, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="activity/{activityId}/comment/destroy/{commentId}.{format}")
    public Response postDeleteCommentById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @PathParam(value="commentId") String commentId) {
        return this.deleteCommentById(uriInfo, portalContainerName, activityId, format, commentId);
    }

    @GET
    @Path(value="activity/{activityId}/likes.{format}")
    public Response getLikesFromIdentityId(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!SecurityManager.canAccessActivity(portalContainer, authenticatedIdentity, activity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        HashMap<String, Serializable> hashmapResult = new HashMap<String, Serializable>();
        if (activity.getLikeIdentityIds() != null && activity.getLikeIdentityIds().length > 0) {
            int numberOfLikeLimited = Math.min(100, activity.getLikeIdentityIds().length);
            ArrayList<IdentityRestOut> likedIdentitiesLimited = null;
            String[] getLikeIdentityIds = activity.getLikeIdentityIds();
            likedIdentitiesLimited = new ArrayList<IdentityRestOut>(numberOfLikeLimited);
            for (int i = 0; i < numberOfLikeLimited; ++i) {
                likedIdentitiesLimited.add(new IdentityRestOut(getLikeIdentityIds[getLikeIdentityIds.length - i - 1], portalContainerName));
            }
            hashmapResult.put("totalNumberOfLikes", Integer.valueOf(activity.getLikeIdentityIds().length));
            hashmapResult.put("likesByIdentities", likedIdentitiesLimited);
        } else {
            hashmapResult.put("totalNumberOfLikes", Integer.valueOf(0));
            hashmapResult.put("likesByIdentities", new ArrayList());
        }
        return Util.getResponse(hashmapResult, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="activity/{activityId}/like.{format}")
    public Response createLikeActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedUserIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!SecurityManager.canCommentToActivity(portalContainer, authenticatedUserIdentity, activity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        activityManager.saveLike(activity, authenticatedUserIdentity);
        HashMap<String, Boolean> resultJson = new HashMap<String, Boolean>();
        resultJson.put("liked", true);
        return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
    }

    @DELETE
    @Path(value="activity/{activityId}/like.{format}")
    public Response deleteLikeActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        Identity authenticatedUserIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!SecurityManager.canCommentToActivity(portalContainer, authenticatedUserIdentity, activity)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        activityManager.deleteLike(activity, authenticatedUserIdentity);
        HashMap<String, Boolean> resultJson = new HashMap<String, Boolean>();
        resultJson.put("liked", false);
        return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="activity/{activityId}/like/destroy.{format}")
    public Response postDeleteLikeActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        return this.deleteLikeActivityById(uriInfo, portalContainerName, activityId, format);
    }

    private boolean isPassed(String value) {
        return value != null && ("true".equals(value) || "t".equals(value) || "1".equals(value));
    }
}

