/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space;

import com.ibm.icu.text.Transliterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceUtils {
    public static Group createGroupFromExistGroup(Group parrentGroup, Group exitsGroup, String name) throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        OrganizationService orgSrc = (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
        GroupHandler groupHandler = orgSrc.getGroupHandler();
        MembershipHandler memberShipHandler = orgSrc.getMembershipHandler();
        Group newGroup = groupHandler.createGroupInstance();
        newGroup.setGroupName(name);
        newGroup.setLabel(name);
        newGroup.setDescription(exitsGroup.getDescription());
        groupHandler.addChild(parrentGroup, newGroup, true);
        Collection memberShips = memberShipHandler.findMembershipsByGroup(exitsGroup);
        for (Membership membership : memberShips) {
            User user = orgSrc.getUserHandler().findUserByName(membership.getUserName());
            MembershipType memberShipType = orgSrc.getMembershipTypeHandler().findMembershipType(membership.getMembershipType());
            memberShipHandler.linkMembership(user, newGroup, memberShipType, true);
        }
        return newGroup;
    }

    public static List<Application> getAllApplications(String spaceId) throws Exception {
        CopyOnWriteArrayList<Application> list = new CopyOnWriteArrayList<Application>();
        PortalContainer portalContainer = PortalContainer.getInstance();
        ApplicationRegistryService appRegistrySrc = (ApplicationRegistryService)portalContainer.getComponentInstanceOfType(ApplicationRegistryService.class);
        String[] applicationTypes = new String[]{"portlet"};
        List listCategory = appRegistrySrc.getApplicationCategories(Util.getPortalRequestContext().getRemoteUser(), applicationTypes);
        for (ApplicationCategory cate : listCategory) {
            List applications = cate.getApplications();
            Iterator appIterator = applications.iterator();
            while (appIterator.hasNext()) {
                list.add((Application)appIterator.next());
            }
        }
        return list;
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '_') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '_';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '_') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 95 || cleanedStr.charAt(i - 1) != '_') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static void setNavigation(List<PageNavigation> navs, PageNavigation nav) {
        for (int i = 0; i < navs.size(); ++i) {
            if (navs.get(i).getId() != nav.getId()) continue;
            navs.set(i, nav);
            return;
        }
    }
}

