/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.application.SpaceApplicationHandler;
import org.exoplatform.social.application.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.social.space.impl.JCRStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceServiceImpl
implements SpaceService {
    public static final String SPACE_PARENT = "/spaces";
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    private JCRStorage storage;
    private OrganizationService orgService = null;
    private Map<String, SpaceApplicationHandler> spaceApplicationHandlers = null;

    public SpaceServiceImpl(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.storage = new JCRStorage(nodeHierarchyCreator);
    }

    private OrganizationService getOrgService() {
        if (this.orgService == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.orgService;
    }

    @Override
    public Space createSpace(String spaceName, String creator) throws SpaceException {
        Group newGroup;
        OrganizationService orgService = this.getOrgService();
        GroupHandler groupHandler = orgService.getGroupHandler();
        try {
            Group groupParent = groupHandler.findGroupById(SPACE_PARENT);
            newGroup = groupHandler.createGroupInstance();
            String spaceNameCleaned = SpaceUtils.cleanString(spaceName);
            String groupId = groupParent.getId() + "/" + spaceNameCleaned;
            if (groupHandler.findGroupById(groupId) != null) {
                throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
            }
            newGroup.setGroupName(spaceNameCleaned);
            newGroup.setLabel(spaceName);
            groupHandler.addChild(groupParent, newGroup, true);
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                throw (SpaceException)e;
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_GROUP, (Throwable)e);
        }
        try {
            User user = orgService.getUserHandler().findUserByName(creator);
            MembershipType mbShipType = orgService.getMembershipTypeHandler().findMembershipType(MANAGER);
            orgService.getMembershipHandler().linkMembership(user, newGroup, mbShipType, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
        Space space = new Space();
        space.setName(spaceName);
        space.setGroupId(newGroup.getId());
        space.setType("classic");
        space.setDescription("edit this description to explain what your space is about");
        space.setTag("");
        this.saveSpace(space, true);
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.initSpace(space);
        this.installApplication(space, "UserListPortlet");
        this.activateApplication(space, "UserListPortlet");
        return space;
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.installApplication(space, appId);
        this.setApp(space, appId, "install");
    }

    @Override
    public void installApplication(String spaceId, String appId) throws SpaceException {
        this.installApplication(this.getSpace(spaceId), appId);
    }

    @Override
    public void deactiveApplication(Space space, String appId) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.deactiveApplication(space, appId);
        this.setApp(space, appId, "deactived");
    }

    @Override
    public void activateApplication(Space space, String appId) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.activateApplication(space, appId);
        this.setApp(space, appId, "actived");
    }

    @Override
    public void activateApplication(String spaceId, String appId) throws SpaceException {
        this.activateApplication(this.getSpace(spaceId), appId);
    }

    @Override
    public void removeApplication(Space space, String appId) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.removeApplication(space, appId);
        this.removeApp(space, appId);
    }

    @Override
    public List<Space> getAllSpaces() throws SpaceException {
        try {
            return this.storage.getAllSpaces();
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public Space getSpace(String id) throws SpaceException {
        try {
            return this.storage.getSpace(id);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public void saveSpace(Space space, boolean isNew) throws SpaceException {
        try {
            this.storage.saveSpace(space, isNew);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public void leave(String spaceId, String userId) throws SpaceException {
        this.leave(this.getSpace(spaceId), userId);
    }

    @Override
    public void leave(Space space, String userId) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            String groupID = space.getGroupId();
            MembershipHandler memberShipHandler = orgService.getMembershipHandler();
            Collection memberships = memberShipHandler.findMembershipsByUserAndGroup(userId, groupID);
            if (memberships.size() == 0) {
                throw new SpaceException(SpaceException.Code.USER_NOT_MEMBER);
            }
            for (Membership mbShip : memberships) {
                memberShipHandler.removeMembership(mbShip.getId(), true);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_USER, (Throwable)e);
        }
    }

    @Override
    public void invite(Space space, String userId) throws SpaceException {
        OrganizationService orgService = this.getOrgService();
        try {
            User user = orgService.getUserHandler().findUserByName(userId);
            if (user == null) {
                throw new SpaceException(SpaceException.Code.USER_NOT_EXIST);
            }
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                throw (SpaceException)e;
            }
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER, (Throwable)e);
        }
        if (this.isInvited(space, userId)) {
            throw new SpaceException(SpaceException.Code.USER_ALREADY_INVITED);
        }
        if (this.isMember(space, userId)) {
            throw new SpaceException(SpaceException.Code.USER_ALREADY_MEMBER);
        }
        if (this.isPending(space, userId)) {
            String[] pendingUsers = space.getPendingUsers();
            space.setPendingUsers(this.removeItemFromArray(pendingUsers, userId));
            this.addMember(space, userId);
        } else {
            String[] invitedUsers = space.getInvitedUsers();
            space.setInvitedUsers(this.addItemToArray(invitedUsers, userId));
        }
        this.saveSpace(space, false);
    }

    @Override
    public void acceptInvitation(String spaceId, String userId) throws SpaceException {
        this.acceptInvitation(this.getSpace(spaceId), userId);
    }

    @Override
    public void acceptInvitation(Space space, String userId) throws SpaceException {
        String[] invitedUser = space.getInvitedUsers();
        boolean check = false;
        if (invitedUser != null) {
            for (String user : invitedUser) {
                if (!user.equals(userId)) continue;
                check = true;
                break;
            }
        }
        if (!check) {
            throw new SpaceException(SpaceException.Code.USER_NOT_INVITED);
        }
        space.setInvitedUsers(this.removeItemFromArray(invitedUser, userId));
        this.saveSpace(space, false);
        this.addMember(space, userId);
    }

    @Override
    public void addMember(Space space, String userId) throws SpaceException {
        OrganizationService orgService = this.getOrgService();
        try {
            UserHandler userHandler = orgService.getUserHandler();
            User user = userHandler.findUserByName(userId);
            MembershipType mbShipType = orgService.getMembershipTypeHandler().findMembershipType(MEMBER);
            MembershipHandler membershipHandler = orgService.getMembershipHandler();
            Group spaceGroup = orgService.getGroupHandler().findGroupById(space.getGroupId());
            membershipHandler.linkMembership(user, spaceGroup, mbShipType, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_USER, (Throwable)e);
        }
    }

    @Override
    public void removeMember(Space space, String userId) throws SpaceException {
        OrganizationService orgService = this.getOrgService();
        UserHandler userHandler = orgService.getUserHandler();
        try {
            User user = userHandler.findUserByName(userId);
            MembershipHandler membershipHandler = orgService.getMembershipHandler();
            Membership memberShip = membershipHandler.findMembershipByUserGroupAndType(user.getUserName(), space.getGroupId(), MEMBER);
            if (memberShip == null) {
                memberShip = membershipHandler.findMembershipByUserGroupAndType(user.getUserName(), space.getGroupId(), MANAGER);
            }
            membershipHandler.removeMembership(memberShip.getId(), true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_USER, (Throwable)e);
        }
    }

    @Override
    public void denyInvitation(String spaceId, String userId) throws SpaceException {
        this.denyInvitation(this.getSpace(spaceId), userId);
    }

    @Override
    public void denyInvitation(Space space, String userId) throws SpaceException {
        String[] invitedUsers = space.getInvitedUsers();
        space.setInvitedUsers(this.removeItemFromArray(invitedUsers, userId));
        this.saveSpace(space, false);
    }

    @Override
    public void revokeInvitation(String spaceId, String userId) throws SpaceException {
        this.revokeInvitation(this.getSpace(spaceId), userId);
    }

    @Override
    public void revokeInvitation(Space space, String userId) throws SpaceException {
        this.denyInvitation(space, userId);
    }

    @Override
    public void requestJoin(String spaceId, String userId) throws SpaceException {
        this.requestJoin(this.getSpace(spaceId), userId);
    }

    @Override
    public void requestJoin(Space space, String userId) throws SpaceException {
        String[] pendingUsers = space.getPendingUsers();
        space.setPendingUsers(this.addItemToArray(pendingUsers, userId));
        this.saveSpace(space, false);
    }

    @Override
    public void declineRequest(String spaceId, String userId) throws SpaceException {
        this.declineRequest(this.getSpace(spaceId), userId);
    }

    @Override
    public void declineRequest(Space space, String userId) throws SpaceException {
        String[] pendingUsers = space.getPendingUsers();
        space.setPendingUsers(this.removeItemFromArray(pendingUsers, userId));
        this.saveSpace(space, false);
    }

    @Override
    public void validateRequest(String spaceId, String userId) throws SpaceException {
        this.validateRequest(this.getSpace(spaceId), userId);
    }

    @Override
    public void validateRequest(Space space, String userId) throws SpaceException {
        String[] pendingUsers = space.getPendingUsers();
        space.setPendingUsers(this.removeItemFromArray(pendingUsers, userId));
        this.saveSpace(space, false);
        this.addMember(space, userId);
    }

    @Override
    public List<String> getMembers(Space space) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            PageList usersPageList = orgService.getUserHandler().findUsersByGroup(space.getGroupId());
            List users = usersPageList.getAll();
            ArrayList<String> usernames = new ArrayList<String>();
            for (User obj : users) {
                usernames.add(obj.getUserName());
            }
            return usernames;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_MEMBER_LIST, (Throwable)e);
        }
    }

    @Override
    public boolean isLeader(Space space, String userId) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            MembershipHandler memberShipHandler = orgService.getMembershipHandler();
            return memberShipHandler.findMembershipByUserGroupAndType(userId, space.getGroupId(), MANAGER) != null;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_MEMBER_LIST, (Throwable)e);
        }
    }

    @Override
    public void setLeader(Space space, String userId, boolean status) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            UserHandler userHandler = orgService.getUserHandler();
            User user = userHandler.findUserByName(userId);
            MembershipHandler membershipHandler = orgService.getMembershipHandler();
            if (status) {
                Membership memberShipMember = membershipHandler.findMembershipByUserGroupAndType(user.getUserName(), space.getGroupId(), MEMBER);
                membershipHandler.removeMembership(memberShipMember.getId(), true);
                MembershipType mbshipTypeManager = orgService.getMembershipTypeHandler().findMembershipType(MANAGER);
                GroupHandler groupHandler = orgService.getGroupHandler();
                membershipHandler.linkMembership(user, groupHandler.findGroupById(space.getGroupId()), mbshipTypeManager, true);
            } else {
                Membership memberShip = membershipHandler.findMembershipByUserGroupAndType(user.getUserName(), space.getGroupId(), MANAGER);
                membershipHandler.removeMembership(memberShip.getId(), true);
                MembershipType mbShipTypeMember = orgService.getMembershipTypeHandler().findMembershipType(MEMBER);
                GroupHandler groupHandler = orgService.getGroupHandler();
                membershipHandler.linkMembership(user, groupHandler.findGroupById(space.getGroupId()), mbShipTypeMember, true);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_SETTING_LEADER_STATUS, (Throwable)e);
        }
    }

    @Override
    public boolean isMember(Space space, String userId) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            MembershipHandler memberShipHandler = orgService.getMembershipHandler();
            return memberShipHandler.findMembershipsByUserAndGroup(userId, space.getGroupId()).size() > 0;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_MEMBER_LIST, (Throwable)e);
        }
    }

    @Override
    public boolean isInvited(Space space, String userId) {
        String[] invitedUsers = space.getInvitedUsers();
        if (invitedUsers == null) {
            return false;
        }
        for (String user : invitedUsers) {
            if (!user.equals(userId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPending(Space space, String userId) {
        String[] pendingUsers = space.getPendingUsers();
        if (pendingUsers == null) {
            return false;
        }
        for (String user : pendingUsers) {
            if (!user.equals(userId)) continue;
            return true;
        }
        return false;
    }

    private Map<String, SpaceApplicationHandler> getSpaceApplicationHandlers() {
        if (this.spaceApplicationHandlers == null) {
            this.spaceApplicationHandlers = new HashMap<String, SpaceApplicationHandler>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            DefaultSpaceApplicationHandler appHandler = (DefaultSpaceApplicationHandler)container.getComponentInstanceOfType(DefaultSpaceApplicationHandler.class);
            this.spaceApplicationHandlers.put(appHandler.getName(), appHandler);
        }
        return this.spaceApplicationHandlers;
    }

    private SpaceApplicationHandler getSpaceApplicationHandler(Space space) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandlers().get(space.getType());
        if (appHandler == null) {
            throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TYPE);
        }
        return appHandler;
    }

    private void setApp(Space space, String appId, String status) throws SpaceException {
        String apps = space.getApp();
        if (apps == null) {
            apps = appId + ":" + status;
        } else if (status.equals("install")) {
            apps = apps + "," + appId + ":" + status;
        } else {
            String oldStatus = apps.substring(apps.indexOf(appId));
            if (oldStatus.indexOf(",") != -1) {
                oldStatus = oldStatus.substring(0, oldStatus.indexOf(",") - 1);
            }
            apps = apps.replaceFirst(oldStatus, appId + ":" + status);
        }
        space.setApp(apps);
        this.saveSpace(space, false);
    }

    private void removeApp(Space space, String appId) throws SpaceException {
        String apps = space.getApp();
        String oldStatus = apps.substring(apps.indexOf(appId));
        if (oldStatus.indexOf(",") != -1) {
            oldStatus = oldStatus.substring(0, oldStatus.indexOf(","));
        }
        if ((apps = apps.replaceFirst(oldStatus, "")).equals("")) {
            apps = null;
        }
        space.setApp(apps);
        this.saveSpace(space, false);
    }

    private String[] removeItemFromArray(String[] arrays, String str) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(arrays));
        list.remove(str);
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    private String[] addItemToArray(String[] arrays, String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (arrays != null && arrays.length > 0) {
            list.addAll(Arrays.asList(arrays));
            list.add(str);
            return list.toArray(new String[list.size()]);
        }
        return new String[]{str};
    }
}

