/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.application.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.application.SpaceApplicationHandler;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpaceApplicationHandler
implements SpaceApplicationHandler {
    public static final String NAME = "classic";
    public static final String APPLICATION = "Application";
    public static final String SPACE_TEMPLATE_PAGE_ID = "portal::classic::spacetemplate";
    private ExoContainer container = ExoContainerContext.getCurrentContainer();
    private UserPortalConfigService configService = (UserPortalConfigService)this.container.getComponentInstanceOfType(UserPortalConfigService.class);
    private static Map<ApplicationCategory, List<Application>> appStoreCache = null;
    private static List<Application> appCache = new ArrayList<Application>();

    @Override
    public void initApp(Space space, String homeNodeApp, List<String> apps) throws SpaceException {
        try {
            PageNavigation spaceNav = SpaceUtils.createGroupNavigation(space.getGroupId());
            PageNode homeNode = this.createPageNodeFromApplication(space, homeNodeApp, true);
            for (String app : apps) {
                app = app.trim().split(":")[0];
                PageNode appNode = this.createPageNodeFromApplication(space, app, false);
                ArrayList<PageNode> childNodes = homeNode.getChildren();
                if (childNodes == null) {
                    childNodes = new ArrayList<PageNode>();
                }
                childNodes.add(appNode);
                homeNode.setChildren(childNodes);
            }
            spaceNav.addNode(homeNode);
            this.configService.update(spaceNav);
            SpaceUtils.setNavigation(spaceNav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_INIT_APP, (Throwable)e);
        }
    }

    @Override
    public void deInitApp(Space space) throws SpaceException {
        try {
            String groupId = space.getGroupId();
            PageNavigation spaceNav = SpaceUtils.getGroupNavigation(groupId);
            ArrayList spaceNodes = spaceNav.getNodes();
            for (PageNode spaceNode : spaceNodes) {
                String pageId = spaceNode.getPageReference();
                Page page = this.configService.getPage(pageId);
                this.configService.remove(page);
            }
            SpaceUtils.removeGroupNavigation(groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_DEINIT_APP, (Throwable)e);
        }
    }

    @Override
    public void activateApplication(Space space, String appId) throws SpaceException {
        this.activeApplicationClassic(space, appId);
    }

    @Override
    public void deactiveApplication(Space space, String appId) throws SpaceException {
        this.deactivateApplicationClassic(space, appId);
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
    }

    @Override
    public void removeApplication(Space space, String appId) throws SpaceException {
        this.removeApplicationClassic(space, appId);
    }

    @Override
    public void removeApplications(Space space) throws SpaceException {
        try {
            List<Application> apps = this.getSpaceApplications(space);
            for (Application app : apps) {
                this.removeApplication(space, app.getApplicationName());
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATIONS, (Throwable)e);
        }
    }

    private List<Application> getSpaceApplications(Space space) throws Exception {
        List<Application> allApps = SpaceUtils.getApplications(space.getGroupId());
        ArrayList<Application> appList = new ArrayList<Application>();
        String spaceApps = space.getApp();
        if (spaceApps != null) {
            String[] apps;
            block0: for (String obj : apps = spaceApps.split(",")) {
                String appId = obj.split(":")[0];
                for (Application app : allApps) {
                    if (!app.getApplicationName().equals(appId)) continue;
                    appList.add(app);
                    continue block0;
                }
            }
        }
        return appList;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void activeApplicationClassic(Space space, String appId) throws SpaceException {
        PageNavigation nav = SpaceUtils.createGroupNavigation(space.getGroupId());
        PageNode pageNode = this.createPageNodeFromApplication(space, appId, false);
        try {
            PageNode homeNode = nav.getNode(space.getUrl());
            ArrayList<PageNode> childNodes = homeNode.getChildren();
            if (childNodes == null) {
                childNodes = new ArrayList<PageNode>();
            }
            childNodes.add(pageNode);
            homeNode.setChildren(childNodes);
            this.configService.update(nav);
            SpaceUtils.setNavigation(nav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_APPLICATION, (Throwable)e);
        }
    }

    private void deactivateApplicationClassic(Space space, String appId) {
    }

    private void removeApplicationClassic(Space space, String appId) throws SpaceException {
        StringBuffer sb = new StringBuffer(space.getShortName());
        String applicationId = sb.append(appId).toString();
        try {
            String spaceNav = space.getGroupId();
            PageNavigation nav = this.configService.getPageNavigation("group", spaceNav);
            PageNode homeNode = nav.getNode(space.getShortName());
            List childNodes = homeNode.getChildren();
            childNodes.remove(homeNode.getChild(applicationId));
            homeNode.setChildren((ArrayList)childNodes);
            this.configService.update(nav);
            Page page = this.configService.getPage("group::" + spaceNav + "::" + applicationId);
            this.configService.remove(page);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATION, (Throwable)e);
        }
    }

    private Application getApplication(List<Application> apps, String appId) {
        for (Application app : apps) {
            if (!app.getApplicationName().equals(appId)) continue;
            return app;
        }
        return null;
    }

    private PageNode createPageNodeFromApplication(Space space, String appId, boolean isRoot) throws SpaceException {
        String contentId;
        Application app = this.getApplication(appCache, appId);
        if (app == null) {
            try {
                if (appStoreCache == null) {
                    appStoreCache = SpaceUtils.getAppStore(space);
                }
                if ((app = this.getApplication(appStoreCache, appId)) == null && (app = this.getApplication(appStoreCache = SpaceUtils.getAppStore(space), appId)) == null && (app = SpaceUtils.getAppFromPortalContainer(appId)) == null) {
                    throw new Exception("app is null!");
                }
                appCache.add(app);
            }
            catch (Exception e) {
                throw new SpaceException(SpaceException.Code.UNABLE_TO_LIST_AVAILABLE_APPLICATIONS, (Throwable)e);
            }
        }
        if ((contentId = app.getContentId()) == null) {
            contentId = app.getCategoryName() + "/" + app.getApplicationName();
        }
        String appInstanceId = "group#" + space.getGroupId() + ":/" + contentId + "/" + app.getApplicationName() + app.hashCode();
        org.exoplatform.portal.config.model.Application gadgetApplication = null;
        org.exoplatform.portal.config.model.Application<Portlet> portletApplication = null;
        if (app.getType() == ApplicationType.GADGET) {
            TransientApplicationState state = new TransientApplicationState(app.getApplicationName());
            gadgetApplication = org.exoplatform.portal.config.model.Application.createGadgetApplication();
            gadgetApplication.setState((ApplicationState)state);
            gadgetApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            gadgetApplication.setShowInfoBar(false);
        } else {
            portletApplication = this.createPortletApplication(appInstanceId);
            portletApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            portletApplication.setShowInfoBar(false);
        }
        Page page = null;
        String pageName = null;
        pageName = isRoot ? space.getUrl() : app.getApplicationName();
        try {
            String newName = space.getUrl();
            if (!isRoot) {
                newName = newName + pageName;
            }
            page = this.configService.renewPage(SPACE_TEMPLATE_PAGE_ID, newName.trim(), "group", space.getGroupId());
            pageName = page.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_PAGE, (Throwable)e);
        }
        page.setName(pageName);
        page.setOwnerType("group");
        page.setOwnerId(space.getGroupId());
        String visibility = space.getVisibility();
        if (visibility.equals("public")) {
            page.setAccessPermissions(new String[]{"Everyone"});
        } else {
            page.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
        }
        page.setEditPermission("manager:" + space.getGroupId());
        page.setModifiable(true);
        ArrayList<ModelObject> pageChilds = page.getChildren();
        Container container = this.findContainerById(pageChilds, APPLICATION);
        ArrayList childs = container.getChildren();
        if (app.getType() == ApplicationType.GADGET) {
            childs.add(gadgetApplication);
        } else {
            childs.add(portletApplication);
        }
        container.setChildren(childs);
        pageChilds = this.setContainerById(pageChilds, container);
        page.setChildren(pageChilds);
        try {
            this.configService.create(page);
            String portalName = Util.getPortalRequestContext().getPortalOwner();
            Page tmpPage = this.configService.getPage("portal::" + portalName + "::" + pageName);
            this.configService.remove(tmpPage);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_PAGE, (Throwable)e);
        }
        PageNode pageNode = new PageNode();
        String label = app.getDisplayName();
        if (isRoot) {
            label = space.getName();
            pageNode.setUri(pageName);
        } else {
            pageNode.setUri(space.getUrl() + "/" + pageName);
        }
        pageNode.setName(pageName);
        pageNode.setLabel(label);
        pageNode.setPageReference(page.getPageId());
        return pageNode;
    }

    private Application getApplication(Map<ApplicationCategory, List<Application>> appStore, String appId) {
        for (ApplicationCategory category : appStore.keySet()) {
            List<Application> appList = appStore.get(category);
            for (Application app : appList) {
                if (!app.getApplicationName().equals(appId)) continue;
                return app;
            }
        }
        return null;
    }

    private Container findContainerById(ArrayList<ModelObject> childs, String id) {
        Container found = null;
        for (ModelObject obj : childs) {
            if (org.exoplatform.portal.config.model.Application.class.isInstance(obj)) continue;
            Container child = (Container)obj;
            if (child.getId() == null) {
                found = this.findContainerById(child.getChildren(), id);
                if (found == null) continue;
                return found;
            }
            if (child.getId().equals(id)) {
                return child;
            }
            found = this.findContainerById(child.getChildren(), id);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    private ArrayList<ModelObject> setContainerById(ArrayList<ModelObject> childs, Container container) {
        ArrayList<ModelObject> result = childs;
        int index = result.indexOf(container);
        if (index != -1) {
            result.set(index, (ModelObject)container);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                ModelObject obj = result.get(i);
                if (org.exoplatform.portal.config.model.Application.class.isInstance(obj)) continue;
                Container objContainer = (Container)obj;
                ArrayList<ModelObject> tmp = this.setContainerById(objContainer.getChildren(), container);
                objContainer.setChildren(tmp);
                result.set(i, (ModelObject)objContainer);
            }
        }
        return result;
    }

    private org.exoplatform.portal.config.model.Application<Portlet> createPortletApplication(String instanceId) {
        int i0 = instanceId.indexOf("#");
        int i1 = instanceId.indexOf(":/", i0 + 1);
        String ownerType = instanceId.substring(0, i0);
        String ownerId = instanceId.substring(i0 + 1, i1);
        String persistenceid = instanceId.substring(i1 + 2);
        String[] persistenceChunks = Utils.split((String)"/", (String)persistenceid);
        TransientApplicationState state = new TransientApplicationState(persistenceChunks[0] + "/" + persistenceChunks[1], null, ownerType, ownerId, persistenceChunks[2]);
        org.exoplatform.portal.config.model.Application portletApp = org.exoplatform.portal.config.model.Application.createPortletApplication();
        portletApp.setState((ApplicationState)state);
        return portletApp;
    }
}

