/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space;

import com.ibm.icu.text.Transliterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.util.Tools;
import org.gatein.mop.api.content.ContentType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceUtils {
    private static final String SPACE_GROUP = "/spaces";
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    private static ExoContainer exoContainer;
    private static SpaceService spaceService;
    private static List<Application> appList;
    private static UserPortalConfigService userPortalConfigService;
    private static ApplicationRegistryService appService;
    private static final String REMOTE_CATEGORY_NAME = "remote";

    public static Group createGroupFromExistingGroup(Group parentGroup, Group existingGroup, String name) throws Exception {
        OrganizationService orgSrc = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = orgSrc.getGroupHandler();
        MembershipHandler memberShipHandler = orgSrc.getMembershipHandler();
        Group newGroup = groupHandler.createGroupInstance();
        newGroup.setGroupName(name);
        newGroup.setLabel(name);
        newGroup.setDescription(existingGroup.getDescription());
        groupHandler.addChild(parentGroup, newGroup, true);
        Collection memberShips = memberShipHandler.findMembershipsByGroup(existingGroup);
        for (Membership membership : memberShips) {
            User user = orgSrc.getUserHandler().findUserByName(membership.getUserName());
            MembershipType memberShipType = orgSrc.getMembershipTypeHandler().findMembershipType(membership.getMembershipType());
            memberShipHandler.linkMembership(user, newGroup, memberShipType, true);
        }
        return newGroup;
    }

    public static List<Application> getApplications(String groupId) throws Exception {
        CopyOnWriteArrayList<Application> list = new CopyOnWriteArrayList<Application>();
        ApplicationRegistryService appRegistrySrc = SpaceUtils.getApplicationRegistryService();
        List listCategory = appRegistrySrc.getApplicationCategories();
        Iterator cateItr = listCategory.iterator();
        while (cateItr.hasNext()) {
            ApplicationCategory cate = (ApplicationCategory)cateItr.next();
            if (!SpaceUtils.hasAccessPermission(cate, groupId)) {
                cateItr.remove();
                continue;
            }
            ApplicationType portletType = ApplicationType.PORTLET;
            List applications = appRegistrySrc.getApplications(cate, new ApplicationType[]{portletType});
            Iterator appIterator = applications.iterator();
            while (appIterator.hasNext()) {
                Application app = (Application)appIterator.next();
                if (!SpaceUtils.hasAccessPermission(app, groupId)) {
                    appIterator.remove();
                    continue;
                }
                list.add(app);
            }
        }
        return list;
    }

    public static Map<ApplicationCategory, List<Application>> getAppStore(Space space) throws Exception {
        HashMap<ApplicationCategory, List<Application>> appStore = new HashMap<ApplicationCategory, List<Application>>();
        ApplicationRegistryService appRegistryService = SpaceUtils.getApplicationRegistryService();
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        if (remoteUser == null || remoteUser.equals("")) {
            return appStore;
        }
        List categoryList = appRegistryService.getApplicationCategories(remoteUser, new ApplicationType[0]);
        Collections.sort(categoryList, new PortletCategoryComparator());
        for (ApplicationCategory appCategory : categoryList) {
            List appList = appRegistryService.getApplications(appCategory, new ApplicationType[0]);
            Collections.sort(appList, new PortletComparator());
            if (appList.size() <= 0) continue;
            appStore.put(appCategory, appList);
        }
        return appStore;
    }

    public static Application getAppFromPortalContainer(String appId) throws Exception {
        if (exoContainer == null) {
            exoContainer = ExoContainerContext.getCurrentContainer();
        }
        PortletInvoker portletInvoker = (PortletInvoker)exoContainer.getComponentInstance(PortletInvoker.class);
        Set portlets = portletInvoker.getPortlets();
        ApplicationRegistryService appRegistryService = SpaceUtils.getApplicationRegistryService();
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        if (remoteUser == null || remoteUser.equals("")) {
            return null;
        }
        for (Portlet portlet : portlets) {
            String contentId;
            Application app;
            Object[] arr$;
            int len$;
            int i$;
            String keywords;
            PortletInfo info = portlet.getInfo();
            String portletApplicationName = info.getApplicationName();
            String portletName = info.getName();
            portletApplicationName = portletApplicationName.replace('/', '_');
            if (!(portletName = portletName.replace('/', '_')).equals(appId)) continue;
            LocalizedString keywordsLS = info.getMeta().getMetaValue("keywords");
            Object[] categoryNames = null;
            if (keywordsLS != null && (keywords = keywordsLS.getDefaultString()) != null && keywords.length() != 0) {
                categoryNames = keywords.split(",");
            }
            if (categoryNames == null || categoryNames.length == 0) {
                categoryNames = new String[]{portletApplicationName};
            }
            if (portlet.isRemote()) {
                categoryNames = (String[])Tools.appendTo((Object[])categoryNames, (Object)REMOTE_CATEGORY_NAME);
            }
            if ((i$ = 0) >= (len$ = (arr$ = categoryNames).length)) continue;
            Object categoryName = arr$[i$];
            ApplicationCategory category = appRegistryService.getApplicationCategory((String)(categoryName = ((String)categoryName).trim()));
            if (category == null) {
                category = new ApplicationCategory();
                category.setName((String)categoryName);
                category.setDisplayName((String)categoryName);
            }
            if ((app = appRegistryService.getApplication((String)categoryName + "/" + portletName)) != null) {
                return app;
            }
            LocalizedString descriptionLS = portlet.getInfo().getMeta().getMetaValue("description");
            LocalizedString displayNameLS = portlet.getInfo().getMeta().getMetaValue("display-name");
            SpaceUtils.getLocalizedStringValue(descriptionLS, portletName);
            app = new Application();
            if (portlet.isRemote()) {
                ContentType contentType = WSRP.CONTENT_TYPE;
                contentId = portlet.getContext().getId();
            } else {
                contentId = info.getApplicationName() + "/" + info.getName();
            }
            app.setContentId(contentId);
            app.setApplicationName(portletName);
            app.setCategoryName((String)categoryName);
            app.setDisplayName(SpaceUtils.getLocalizedStringValue(displayNameLS, portletName));
            app.setDescription(SpaceUtils.getLocalizedStringValue(descriptionLS, portletName));
            appList.add(app);
            return app;
        }
        return null;
    }

    public static List<Application> getAppList() {
        return appList;
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '_') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '_';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '_') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 95 || cleanedStr.charAt(i - 1) != '_') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static String getSpaceUrl() {
        String portalUrl;
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestUrl = pcontext.getRequestURI();
        String spaceUrl = requestUrl.replace(portalUrl = pcontext.getPortalURI(), "");
        if (spaceUrl.contains("/")) {
            spaceUrl = spaceUrl.split("/")[0];
        }
        return spaceUrl;
    }

    public static void setNavigation(PageNavigation nav) {
        UIPortal uiPortal = Util.getUIPortal();
        try {
            List navs = null;
            navs = uiPortal.getNavigations();
            boolean alreadyExisted = false;
            for (int i = 0; i < navs.size(); ++i) {
                if (((PageNavigation)navs.get(i)).getId() != nav.getId()) continue;
                navs.set(i, nav);
                alreadyExisted = true;
                return;
            }
            if (!alreadyExisted) {
                navs.add(nav);
                PageNode selectedPageNode = null;
                selectedPageNode = uiPortal.getSelectedNode();
                uiPortal.setNavigation(navs);
                uiPortal.setSelectedNode(selectedPageNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNavigation(PageNavigation nav) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        if (exoContainer == null) {
            exoContainer = ExoContainerContext.getCurrentContainer();
        }
        if (userPortalConfigService == null) {
            userPortalConfigService = (UserPortalConfigService)exoContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        }
        List navs = uiPortal.getNavigations();
        navs.remove(nav);
        try {
            uiPortal.setNavigation(navs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String portalOwner = Util.getPortalRequestContext().getPortalOwner();
        PageNavigation portalNavigation = null;
        for (PageNavigation pn : navs) {
            if (!pn.getOwnerId().equals(portalOwner)) continue;
            portalNavigation = pn;
            break;
        }
        ArrayList nodes = portalNavigation.getNodes();
        PageNode selectedPageNode = null;
        for (PageNode node : nodes) {
            if (!node.getUri().equals("spaces")) continue;
            selectedPageNode = node;
            break;
        }
        uiPortal.setSelectedNavigation(portalNavigation);
        uiPortal.setSelectedNode(selectedPageNode);
        String uri = portalNavigation.getId() + "::spaces";
        PageNodeEvent pnevent = new PageNodeEvent((UIComponent)uiPortal, "ChangePageNode", uri);
        uiPortal.broadcast((Event)pnevent, Event.Phase.PROCESS);
    }

    public static void reloadNavigation() throws Exception {
        String groupId;
        if (exoContainer == null) {
            exoContainer = ExoContainerContext.getCurrentContainer();
        }
        if (spaceService == null) {
            spaceService = (SpaceService)exoContainer.getComponentInstanceOfType(SpaceService.class);
        }
        String userId = Util.getPortalRequestContext().getRemoteUser();
        List<Space> spaces = spaceService.getAccessibleSpaces(userId);
        List navs = Util.getUIPortal().getNavigations();
        ArrayList<PageNavigation> spaceNavs = new ArrayList<PageNavigation>();
        for (PageNavigation nav : navs) {
            String ownerId = nav.getOwnerId();
            try {
                Space space = SpaceUtils.getSpaceByGroupId(ownerId);
                if (space == null) continue;
                spaceNavs.add(nav);
            }
            catch (Exception e) {}
        }
        for (Space space : spaces) {
            groupId = space.getGroupId();
            boolean spaceContained = false;
            for (PageNavigation nav : spaceNavs) {
                if (!groupId.equals(nav.getOwnerId())) continue;
                spaceContained = true;
                break;
            }
            if (spaceContained) continue;
            SpaceUtils.setNavigation(SpaceUtils.getGroupNavigation(groupId));
        }
        if (spaces.size() == 0) {
            for (PageNavigation nav : spaceNavs) {
                SpaceUtils.removeNavigation(nav);
            }
        } else {
            for (PageNavigation nav : spaceNavs) {
                boolean navContained = false;
                for (Space space : spaces) {
                    groupId = space.getGroupId();
                    if (!groupId.equals(nav.getOwnerId())) continue;
                    navContained = true;
                    break;
                }
                if (navContained) continue;
                SpaceUtils.removeNavigation(nav);
            }
        }
    }

    private static Space getSpaceByGroupId(String groupId) throws SpaceException {
        List<Space> spaces = spaceService.getAllSpaces();
        for (Space space : spaces) {
            if (!space.getGroupId().equals(groupId)) continue;
            return space;
        }
        return null;
    }

    public static void updateWorkingWorkSpace() {
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApplication.getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.setFullRender(true);
    }

    public static String createGroup(String spaceName, String creator) throws SpaceException {
        String groupId;
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = organizationService.getGroupHandler();
        try {
            Group parentGroup = groupHandler.findGroupById(SPACE_GROUP);
            Group newGroup = groupHandler.createGroupInstance();
            String shortName = SpaceUtils.cleanString(spaceName);
            groupId = parentGroup.getId() + "/" + shortName;
            if (SpaceUtils.isSpaceNameExisted(spaceName)) {
                throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
            }
            newGroup.setGroupName(shortName);
            newGroup.setLabel(spaceName);
            groupHandler.addChild(parentGroup, newGroup, true);
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                throw (SpaceException)e;
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_GROUP, (Throwable)e);
        }
        try {
            SpaceUtils.addCreatorToGroup(creator, groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
        return groupId;
    }

    public static void removeGroup(Space space) throws SpaceException {
        try {
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            groupHandler.removeGroup(group, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_GROUP, (Throwable)e);
        }
    }

    public static boolean isSpaceNameExisted(String spaceName) throws SpaceException {
        PortalContainer portalContainer = PortalContainer.getInstance();
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        List<Space> spaces = spaceService.getAllSpaces();
        for (Space space : spaces) {
            if (!space.getName().equalsIgnoreCase(spaceName)) continue;
            return true;
        }
        return false;
    }

    public static void addCreatorToGroup(String creator, String groupId) throws SpaceException {
        PortalContainer portalContainer = PortalContainer.getInstance();
        OrganizationService organizationService = (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
        try {
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group existingGroup = groupHandler.findGroupById(groupId);
            User user = organizationService.getUserHandler().findUserByName(creator);
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(MANAGER);
            organizationService.getMembershipHandler().linkMembership(user, existingGroup, membershipType, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
    }

    public static PageNavigation createGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService configService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        try {
            PageNavigation spaceNav = configService.getPageNavigation("group", groupId);
            if (spaceNav == null) {
                spaceNav = new PageNavigation();
                spaceNav.setOwnerType("group");
                spaceNav.setOwnerId(groupId);
                spaceNav.setModifiable(true);
                UIPortal uiPortal = Util.getUIPortal();
                List pnavigations = uiPortal.getNavigations();
                pnavigations.add(spaceNav);
                configService.create(spaceNav);
            }
            return spaceNav;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREAT_NAV, (Throwable)e);
        }
    }

    public static void removeGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService configService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        try {
            PageNavigation spaceNav = configService.getPageNavigation("group", groupId);
            if (spaceNav == null) {
                throw new Exception("spaceNav is null");
            }
            UIPortal uiPortal = Util.getUIPortal();
            List pnavigations = uiPortal.getNavigations();
            pnavigations.remove(spaceNav);
            configService.remove(spaceNav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_NAV, (Throwable)e);
        }
    }

    public static PageNavigation getGroupNavigation(String groupId) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService configService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        return configService.getPageNavigation("group", groupId);
    }

    public static List<Space> getOrderedSpaces(List<Space> spaces) {
        Iterator<Space> itr = spaces.iterator();
        ArrayList<Space> orderedSpaces = new ArrayList<Space>();
        ArrayList<Space> middleSpaces = new ArrayList<Space>();
        ArrayList<Space> lowSpaces = new ArrayList<Space>();
        Space space = null;
        while (itr.hasNext()) {
            space = itr.next();
            String priority = space.getPriority();
            if (priority.equals("1")) {
                orderedSpaces.add(space);
                continue;
            }
            if (priority.equals("2")) {
                middleSpaces.add(space);
                continue;
            }
            if (!priority.equals("3")) continue;
            lowSpaces.add(space);
        }
        for (Space sp : middleSpaces) {
            orderedSpaces.add(sp);
        }
        for (Space sp : lowSpaces) {
            orderedSpaces.add(sp);
        }
        return orderedSpaces;
    }

    public static int countMembers(Space space) throws SpaceException {
        PortalContainer portalContainer = PortalContainer.getInstance();
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        return spaceService.getMembers(space).size();
    }

    public static String getAppStatus(Space space, String appId) {
        String installedApps = space.getApp();
        String[] appSplit = null;
        if (installedApps == null) {
            installedApps = "";
        }
        if (installedApps.contains(appId)) {
            String[] apps;
            for (String app : apps = installedApps.split(",")) {
                if (!app.contains(appId)) continue;
                appSplit = app.split(":");
                return appSplit[appSplit.length - 1];
            }
        }
        return null;
    }

    public static boolean isRemovableApp(Space space, String appId) {
        String installedApps = space.getApp();
        boolean removable = false;
        String remove = null;
        appId = appId.split("/")[1];
        String[] appSplit = null;
        if (installedApps == null) {
            installedApps = "";
        }
        if (installedApps.contains(appId)) {
            String[] apps;
            for (String app : apps = installedApps.split(",")) {
                if (!app.contains(appId)) continue;
                appSplit = app.split(":");
                remove = appSplit.length >= 3 ? appSplit[1] : "true";
                return Boolean.parseBoolean(remove);
            }
        }
        return removable;
    }

    public static String getAbsoluteUrl() throws SpaceException {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest request = portalRequestContext.getRequest();
        String str = request.getRequestURL().toString();
        return str.substring(0, str.indexOf(portalRequestContext.getRequestContextPath()));
    }

    private static boolean hasAccessPermission(Application app, String groupId) throws Exception {
        ArrayList permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!SpaceUtils.hasViewPermission(ele, groupId)) continue;
            return true;
        }
        return false;
    }

    private static OrganizationService getOrganizationService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
    }

    private static boolean hasAccessPermission(ApplicationCategory app, String groupId) throws Exception {
        List permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!SpaceUtils.hasViewPermission(ele, groupId)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasViewPermission(String expPerm, String groupId) throws Exception {
        if ("Everyone".equals(expPerm)) {
            return true;
        }
        String[] temp = expPerm.split(":");
        if (temp.length < 2) {
            return false;
        }
        String tempExp = temp[1].trim();
        return tempExp.equals(groupId) || tempExp.equals(SPACE_GROUP);
    }

    private static String getLocalizedStringValue(LocalizedString localizedString, String portletName) {
        if (localizedString == null || localizedString.getDefaultString() == null) {
            return portletName;
        }
        return localizedString.getDefaultString();
    }

    private static ApplicationRegistryService getApplicationRegistryService() {
        if (appService == null) {
            PortalContainer portalContainer = PortalContainer.getInstance();
            appService = (ApplicationRegistryService)portalContainer.getComponentInstanceOfType(ApplicationRegistryService.class);
        }
        return appService;
    }

    static {
        appList = new ArrayList<Application>();
        appService = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletComparator
    implements Comparator<Application> {
        PortletComparator() {
        }

        @Override
        public int compare(Application p1, Application p2) {
            return p1.getDisplayName().compareTo(p2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletCategoryComparator
    implements Comparator<ApplicationCategory> {
        PortletCategoryComparator() {
        }

        @Override
        public int compare(ApplicationCategory cat1, ApplicationCategory cat2) {
            return cat1.getDisplayName().compareTo(cat2.getDisplayName());
        }
    }
}

