/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.social.space.JCRSessionManager;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceAttachment;
import org.exoplatform.social.space.impl.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRStorage {
    private static final String SPACE_NODETYPE = "exo:space".intern();
    private static final String SPACE_NAME = "exo:name".intern();
    private static final String SPACE_GROUPID = "exo:groupId".intern();
    private static final String SPACE_APP = "exo:app".intern();
    private static final String SPACE_PARENT = "exo:parent".intern();
    private static final String SPACE_DESCRIPTION = "exo:description".intern();
    private static final String SPACE_TAG = "exo:tag".intern();
    private static final String SPACE_PENDING_USER = "exo:pendingUsers".intern();
    private static final String SPACE_INVITED_USER = "exo:invitedUsers".intern();
    private static final String SPACE_TYPE = "exo:type".intern();
    private static final String SPACE_URL = "exo:url".intern();
    private static final String SPACE_VISIBILITY = "exo:visibility".intern();
    private static final String SPACE_REGISTRATION = "exo:registration".intern();
    private static final String SPACE_PRIORITY = "exo:priority".intern();
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private String repository;
    private String workspace;

    public JCRStorage(SocialDataLocation dataLocation) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
        this.repository = dataLocation.getRepository();
        this.workspace = dataLocation.getWorkspace();
    }

    private Node getSpaceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialSpaceHome();
        return session.getRootNode().getNode(path);
    }

    public String getRepository() throws Exception {
        return this.repository;
    }

    public String getWorkspace() throws Exception {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Space> getAllSpaces() {
        ArrayList<Space> spaces = new ArrayList<Space>();
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            NodeIterator iter = spaceHomeNode.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                Space space = this.getSpace(spaceNode, session);
                spaces.add(space);
            }
            ArrayList<Space> arrayList = spaces;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<Space> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceById(String id) {
        try {
            Session session = this.sessionManager.openSession();
            Space space = this.getSpace(session.getNodeByUUID(id), session);
            return space;
        }
        catch (Exception e) {
            Space space = null;
            return space;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByUrl(String url) {
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            NodeIterator iter = spaceHomeNode.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                Space space = this.getSpace(spaceNode, session);
                if (!space.getUrl().equals(url)) continue;
                Space space2 = space;
                return space2;
            }
        }
        catch (Exception e) {
            Space space = null;
            return space;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpace(String id) {
        Session session = this.sessionManager.openSession();
        try {
            Node spaceNode = session.getNodeByUUID(id);
            if (spaceNode != null) {
                spaceNode.remove();
                session.save();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSpace(Space space, boolean isNew) {
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            this.saveSpace(spaceHomeNode, space, isNew, session);
        }
        catch (Exception exception) {
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSpace(Node spaceHomeNode, Space space, boolean isNew, Session session) {
        block20: {
            try {
                Node spaceNode;
                if (isNew) {
                    spaceNode = spaceHomeNode.addNode(SPACE_NODETYPE, SPACE_NODETYPE);
                    spaceNode.addMixin("mix:referenceable");
                } else {
                    spaceNode = session.getNodeByUUID(space.getId());
                }
                if (space.getId() == null) {
                    space.setId(spaceNode.getUUID());
                }
                spaceNode.setProperty(SPACE_NAME, space.getName());
                spaceNode.setProperty(SPACE_GROUPID, space.getGroupId());
                spaceNode.setProperty(SPACE_APP, space.getApp());
                spaceNode.setProperty(SPACE_PARENT, space.getParent());
                spaceNode.setProperty(SPACE_DESCRIPTION, space.getDescription());
                spaceNode.setProperty(SPACE_TAG, space.getTag());
                spaceNode.setProperty(SPACE_PENDING_USER, space.getPendingUsers());
                spaceNode.setProperty(SPACE_INVITED_USER, space.getInvitedUsers());
                spaceNode.setProperty(SPACE_TYPE, space.getType());
                spaceNode.setProperty(SPACE_URL, space.getUrl());
                spaceNode.setProperty(SPACE_VISIBILITY, space.getVisibility());
                spaceNode.setProperty(SPACE_REGISTRATION, space.getRegistration());
                spaceNode.setProperty(SPACE_PRIORITY, space.getPriority());
                SpaceAttachment attachment = space.getSpaceAttachment();
                if (attachment != null) {
                    ExtendedNode extNode = (ExtendedNode)spaceNode;
                    if (extNode.canAddMixin("exo:privilegeable")) {
                        extNode.addMixin("exo:privilegeable");
                    }
                    String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                    extNode.setPermission(SystemIdentity.ANY, arrayPers);
                    List permsList = extNode.getACL().getPermissionEntries();
                    for (AccessControlEntry accessControlEntry : permsList) {
                        extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
                    }
                    if (attachment.getFileName() != null) {
                        Node nodeFile = null;
                        try {
                            nodeFile = spaceNode.getNode("image");
                        }
                        catch (PathNotFoundException ex) {
                            nodeFile = spaceNode.addNode("image", "nt:file");
                        }
                        Node nodeContent = null;
                        try {
                            nodeContent = nodeFile.getNode("jcr:content");
                        }
                        catch (PathNotFoundException ex) {
                            nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                        }
                        long lastModified = attachment.getLastModified();
                        long lastSaveTime = 0L;
                        if (nodeContent.hasProperty("jcr:lastModified")) {
                            lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
                        }
                        if (lastModified != 0L && lastModified != lastSaveTime) {
                            nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                            nodeContent.setProperty("jcr:data", attachment.getInputStream(session));
                            nodeContent.setProperty("jcr:lastModified", attachment.getLastModified());
                        }
                    }
                } else if (spaceNode.hasNode("image")) {
                    spaceNode.getNode("image").remove();
                    session.save();
                }
                if (isNew) {
                    spaceHomeNode.save();
                    break block20;
                }
                spaceNode.save();
            }
            catch (Exception e) {}
        }
    }

    private Space getSpace(Node spaceNode, Session session) throws Exception {
        Node image;
        Space space = new Space();
        space.setId(spaceNode.getUUID());
        if (spaceNode.hasProperty(SPACE_NAME)) {
            space.setName(spaceNode.getProperty(SPACE_NAME).getString());
        }
        if (spaceNode.hasProperty(SPACE_GROUPID)) {
            space.setGroupId(spaceNode.getProperty(SPACE_GROUPID).getString());
        }
        if (spaceNode.hasProperty(SPACE_APP)) {
            space.setApp(spaceNode.getProperty(SPACE_APP).getString());
        }
        if (spaceNode.hasProperty(SPACE_PARENT)) {
            space.setParent(spaceNode.getProperty(SPACE_PARENT).getString());
        }
        if (spaceNode.hasProperty(SPACE_DESCRIPTION)) {
            space.setDescription(spaceNode.getProperty(SPACE_DESCRIPTION).getString());
        }
        if (spaceNode.hasProperty(SPACE_TAG)) {
            space.setTag(spaceNode.getProperty(SPACE_TAG).getString());
        }
        if (spaceNode.hasProperty(SPACE_PENDING_USER)) {
            space.setPendingUsers(this.ValuesToStrings(spaceNode.getProperty(SPACE_PENDING_USER).getValues()));
        }
        if (spaceNode.hasProperty(SPACE_INVITED_USER)) {
            space.setInvitedUsers(this.ValuesToStrings(spaceNode.getProperty(SPACE_INVITED_USER).getValues()));
        }
        if (spaceNode.hasProperty(SPACE_TYPE)) {
            space.setType(spaceNode.getProperty(SPACE_TYPE).getString());
        }
        if (spaceNode.hasProperty(SPACE_URL)) {
            space.setUrl(spaceNode.getProperty(SPACE_URL).getString());
        }
        if (spaceNode.hasProperty(SPACE_VISIBILITY)) {
            space.setVisibility(spaceNode.getProperty(SPACE_VISIBILITY).getString());
        }
        if (spaceNode.hasProperty(SPACE_REGISTRATION)) {
            space.setRegistration(spaceNode.getProperty(SPACE_REGISTRATION).getString());
        }
        if (spaceNode.hasProperty(SPACE_PRIORITY)) {
            space.setPriority(spaceNode.getProperty(SPACE_PRIORITY).getString());
        }
        if (spaceNode.hasNode("image") && (image = spaceNode.getNode("image")).isNodeType("nt:file")) {
            SpaceAttachment file = new SpaceAttachment();
            file.setId(image.getPath());
            file.setMimeType(image.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            try {
                file.setInputStream(image.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
            }
            catch (Exception ex) {
                ex.getStackTrace();
            }
            file.setFileName(image.getName());
            file.setLastModified(image.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
            file.setWorkspace(session.getWorkspace().getName());
            space.setSpaceAttachment(file);
        }
        return space;
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }
}

